/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.papyrusrt.umlrt.uml.FacadeObject;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTFactory;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTModel;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.FacadeAdapter;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.FacadeReference;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.FacadeType;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.InternalFacadeEList;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.UMLRTUMLFactoryImpl;
import org.eclipse.papyrusrt.umlrt.uml.internal.umlext.impl.UMLRTUMLPlugin;
import org.eclipse.papyrusrt.umlrt.uml.internal.util.InternalFacadeObject;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTExtensionUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;

public abstract class FacadeObjectImpl
extends MinimalEObjectImpl.Container
implements InternalFacadeObject {
    private static final ReferenceKind FACADE_REFERENCE_KIND_DEFAULT = ReferenceKind.SOFT;
    private static final ReferenceKind FACADE_REFERENCE_KIND;
    private Element element;
    private EObject stereotype;

    static {
        String config = System.getProperty("papyrusrt.facadeReferenceKind", FACADE_REFERENCE_KIND_DEFAULT.name());
        ReferenceKind referenceKind = FACADE_REFERENCE_KIND_DEFAULT;
        try {
            referenceKind = ReferenceKind.valueOf(config);
            if (referenceKind != FACADE_REFERENCE_KIND_DEFAULT) {
                UMLRTUMLPlugin.INSTANCE.log(String.format("Using %s references for facade.", new Object[]{referenceKind}));
            }
        }
        catch (Exception e) {
            UMLRTUMLPlugin.INSTANCE.log("Unrecognized value of papyrusrt.facadeReferenceKind system property: " + config);
            UMLRTUMLPlugin.INSTANCE.log(e);
        }
        FACADE_REFERENCE_KIND = referenceKind;
    }

    protected FacadeObjectImpl() {
    }

    protected BasicFacadeAdapter<? extends FacadeObjectImpl> createFacadeAdapter() {
        return new BasicFacadeAdapter<FacadeObjectImpl>(this);
    }

    <F extends FacadeObjectImpl> F init(Element element, EObject stereotype) {
        this.element = element;
        this.stereotype = stereotype;
        return (F)this;
    }

    static <T extends Element, U extends EObject, F extends FacadeObjectImpl> F getFacade(T element, FacadeType<T, U, F> type) {
        BasicFacadeAdapter<Object> adapter = null;
        if (element != null && (adapter = type.getAdapter(element)) == null) {
            adapter = type.createAdapter(element);
        }
        return adapter == null ? null : (F)type.getFacade(adapter);
    }

    @Override
    public Element toUML() {
        return this.element;
    }

    EObject toRT() {
        return this.stereotype;
    }

    @Override
    public boolean isExcluded() {
        return false;
    }

    public void destroy() {
        Optional.ofNullable(this.toUML()).ifPresent(uml -> UMLRTExtensionUtil.run(uml, () -> ((Element)uml).destroy()));
    }

    <T extends Element, U extends EObject, R extends FacadeObject, F extends R> List<R> getFacades(FacadeReference<T, U, R, F> reference) {
        return reference.getFacades(this);
    }

    <T extends Element, U extends EObject, R extends FacadeObject, F extends R> List<R> getFacades(FacadeReference<T, U, R, F> reference, boolean withExclusions) {
        return reference.getFacades(this, withExclusions);
    }

    <T extends Element, U extends EObject, R extends FacadeObject, F extends R> List<R> getFacades(FacadeReference<T, U, R, F> reference, boolean withExclusions, UnaryOperator<R> andThen) {
        return reference.getFacades(this, withExclusions, andThen);
    }

    <T extends Element, U extends EObject, R extends FacadeObject, F extends R> List<R> getFacades(FacadeReference<T, U, R, F> reference, UnaryOperator<R> andThen) {
        return reference.getFacades(this, andThen);
    }

    <T extends NamedElement, U extends EObject, R extends FacadeObject, F extends R> R create(FacadeReference<T, U, R, F> reference, String name) {
        NamedElement result = (NamedElement)UMLRTUMLFactoryImpl.eINSTANCE.create(reference.getEReferenceType());
        if (name != null && result != null) {
            result.setName(name);
        }
        reference.getUML(this.toUML()).add(result);
        reference.getType().applyStereotype(result);
        return (R)reference.getType().getFacade(result);
    }

    protected <E> EList<E> elist(EStructuralFeature feature, List<E> list) {
        return new EcoreEList.UnmodifiableEList.FastCompare((InternalEObject)this, feature, list.size(), list.toArray());
    }

    @Override
    public Object facadeGetAll(EReference reference) {
        int featureID = this.eDerivedStructuralFeatureID((EStructuralFeature)reference);
        return featureID >= 0 ? this.facadeGetAll(featureID) : this.eGet(featureID, true, true);
    }

    protected abstract Object facadeGetAll(int var1);

    public String toString() {
        String pattern = this.isExcluded() ? "%s[X]()" : "%s()";
        return String.format(pattern, this.eClass().getName());
    }

    protected static class BasicFacadeAdapter<F extends FacadeObjectImpl>
    extends AdapterImpl
    implements FacadeAdapter,
    Supplier<F> {
        private final Supplier<F> facade;

        BasicFacadeAdapter(F facade) {
            this.facade = FACADE_REFERENCE_KIND.supplierOf(facade);
        }

        @Override
        public final F get() {
            FacadeObjectImpl result = (FacadeObjectImpl)this.facade.get();
            if (result == null && this.getTarget() != null) {
                this.removeAdapter(this.getTarget());
            }
            return (F)result;
        }

        public final boolean isAdapterForType(Object type) {
            return type == FacadeAdapter.class || type instanceof Class && ((Class)type).isInstance(this.get());
        }

        protected boolean addAdapter(Notifier notifier) {
            EList eAdapters = notifier.eAdapters();
            return !eAdapters.contains((Object)this) && eAdapters.add((Object)this);
        }

        protected boolean removeAdapter(Notifier notifier) {
            return notifier.eAdapters().remove((Object)this);
        }

        public void setTarget(Notifier newTarget) {
            if (this.target == null || newTarget == null) {
                super.setTarget(newTarget);
            }
            if (newTarget != null) {
                UMLRTModel.getInstance(((EObject)newTarget).eResource());
            }
        }

        public final void notifyChanged(Notification msg) {
            Object facade = this.get();
            if (facade == null) {
                this.removeAdapter((Notifier)msg.getNotifier());
                return;
            }
            if (msg.isTouch()) {
                return;
            }
            this.handleNotification(msg);
        }

        protected void handleNotification(Notification msg) {
        }

        @Override
        public void tickle(NamedElement element) {
        }

        @Override
        public void excluded(Element element) {
        }

        @Override
        public void reinherited(Element element) {
        }
    }

    protected static class Reactor<F extends FacadeObjectImpl>
    extends BasicFacadeAdapter<F> {
        private List<Notifier> additionalTargets;

        protected final void adaptAdditional(Notifier notifier) {
            if (this.addAdapter(notifier) && notifier != this.getTarget()) {
                if (this.additionalTargets == null) {
                    this.additionalTargets = new ArrayList<Notifier>(4);
                }
                this.additionalTargets.add(notifier);
            }
        }

        protected final void unadaptAdditional(Notifier notifier) {
            this.removeAdapter(notifier);
            if (this.additionalTargets != null && this.additionalTargets.remove(notifier) && this.additionalTargets.isEmpty()) {
                this.additionalTargets = null;
            }
        }

        protected final void unadaptAdditional() {
            if (this.additionalTargets != null) {
                this.additionalTargets.forEach(this::removeAdapter);
                this.additionalTargets = null;
            }
        }

        protected Reactor(F facade) {
            super(facade);
        }

        @Override
        protected void handleNotification(Notification msg) {
            Object feature = msg.getFeature();
            if (feature instanceof EReference) {
                this.handleReference(msg);
            } else if (feature instanceof EAttribute) {
                this.handleAttribute(msg);
            }
        }

        protected void handleReference(Notification msg) {
            switch (msg.getEventType()) {
                case 3: {
                    this.handleObjectAdded(msg, msg.getPosition(), (EObject)msg.getNewValue());
                    break;
                }
                case 5: {
                    int addedAt = msg.getPosition();
                    for (Object next : (List)msg.getNewValue()) {
                        this.handleObjectAdded(msg, addedAt, (EObject)next);
                        if (addedAt == -1) continue;
                        ++addedAt;
                    }
                    break;
                }
                case 4: {
                    this.handleObjectRemoved(msg, msg.getPosition(), (EObject)msg.getOldValue());
                    break;
                }
                case 6: {
                    if (msg.getNewValue() instanceof int[]) {
                        int[] removedAt = (int[])msg.getNewValue();
                        List removed = (List)msg.getOldValue();
                        int i = 0;
                        while (i < removedAt.length) {
                            this.handleObjectRemoved(msg, removedAt[i], (EObject)removed.get(i));
                            ++i;
                        }
                    } else {
                        List removed = (List)msg.getOldValue();
                        int i = 0;
                        while (i < removed.size()) {
                            this.handleObjectRemoved(msg, i, (EObject)removed.get(i));
                            ++i;
                        }
                    }
                    break;
                }
                case 1: 
                case 2: 
                case 9: {
                    this.handleObjectReplaced(msg, msg.getPosition(), (EObject)msg.getOldValue(), (EObject)msg.getNewValue());
                    break;
                }
                case 7: {
                    this.handleObjectMoved(msg, (int)((Integer)msg.getOldValue()), msg.getPosition(), (EObject)msg.getNewValue());
                }
            }
        }

        protected void discover(EObject newObject, EReference containment) {
            this.handleReference((Notification)new ENotificationImpl((InternalEObject)newObject, 5, (EStructuralFeature)containment, null, UMLRTExtensionUtil.getUMLRTContents(newObject, (EStructuralFeature)containment, new EStructuralFeature[0])));
        }

        protected void undiscover(EObject oldObject, EReference containment) {
            this.handleReference((Notification)new ENotificationImpl((InternalEObject)oldObject, 6, (EStructuralFeature)containment, UMLRTExtensionUtil.getUMLRTContents(oldObject, (EStructuralFeature)containment, new EStructuralFeature[0]), null));
        }

        protected FacadeObject getFacade(Notification msg, EObject object) {
            return object == null ? null : this.getFacade((EObject)msg.getNotifier(), (EReference)msg.getFeature(), object);
        }

        protected FacadeObject getFacade(EObject umlOwner, EReference umlReference, EObject object) {
            List<FacadeObject> search;
            FacadeObject result;
            FacadeObject facadeObject = result = object == null ? null : UMLRTFactory.create(object);
            if (result == null && object != null && object.eResource() == null && (search = this.getFacadeList(umlOwner, umlReference, object)) != null) {
                for (FacadeObject next : search) {
                    if (next.toUML() != object) continue;
                    result = next;
                    break;
                }
            }
            return result;
        }

        protected List<? extends FacadeObject> getFacadeList(EObject owner, EReference reference, EObject object) {
            return null;
        }

        protected void handleObjectAdded(Notification msg, int position, EObject object) {
            FacadeObject facade = this.getFacade(msg, object);
            if (facade != null) {
                this.handleObjectAdded(msg, position, facade);
            }
        }

        protected void handleObjectRemoved(Notification msg, int position, EObject object) {
            FacadeObject facade = this.getFacade(msg, object);
            if (facade != null) {
                this.handleObjectRemoved(msg, position, facade);
            }
        }

        protected void handleObjectReplaced(Notification msg, int position, EObject oldObject, EObject newObject) {
            FacadeObject oldFacade = this.getFacade(msg, oldObject);
            FacadeObject newFacade = this.getFacade(msg, newObject);
            if (!(oldFacade == null && oldObject != null || newFacade == null && newObject != null)) {
                this.handleObjectReplaced(msg, position, oldFacade, newFacade);
            } else {
                this.handleObjectRemoved(msg, position, oldObject);
                this.handleObjectAdded(msg, position, newObject);
            }
        }

        protected void handleObjectMoved(Notification msg, int oldPosition, int newPosition, EObject object) {
            FacadeObject facade = this.getFacade(msg, object);
            if (facade != null) {
                this.handleObjectMoved(msg, oldPosition, newPosition, facade);
            }
        }

        protected void handleObjectAdded(Notification msg, int position, FacadeObject object) {
            InternalFacadeEList<FacadeObject> list = this.validateObject(msg, object);
            if (list != null) {
                list.facadeAdd(object);
            }
        }

        protected InternalFacadeEList<? extends FacadeObject> validateObject(Notification msg, FacadeObject object) {
            return this.validateObject((EObject)msg.getNotifier(), (EReference)msg.getFeature(), object);
        }

        protected InternalFacadeEList<? extends FacadeObject> validateObject(EObject owner, EReference reference, FacadeObject object) {
            return null;
        }

        protected void handleObjectRemoved(Notification msg, int position, FacadeObject object) {
            InternalFacadeEList<FacadeObject> list = this.validateObject(msg, object);
            if (list != null) {
                list.facadeRemove(object);
            }
        }

        protected void handleObjectReplaced(Notification msg, int position, FacadeObject oldObject, FacadeObject newObject) {
            if (oldObject == null) {
                this.handleObjectAdded(msg, position, newObject);
            } else if (newObject == null) {
                this.handleObjectRemoved(msg, position, oldObject);
            } else {
                InternalFacadeEList<FacadeObject> list = this.validateObject(msg, newObject);
                if (list != null) {
                    int index = list.indexOf(oldObject);
                    if (index >= 0) {
                        list.facadeSet(index, newObject);
                    } else {
                        this.handleObjectRemoved(msg, position, oldObject);
                        this.handleObjectAdded(msg, position, newObject);
                    }
                } else {
                    this.handleObjectRemoved(msg, position, oldObject);
                    this.handleObjectAdded(msg, position, newObject);
                }
            }
        }

        protected void handleObjectMoved(Notification msg, int oldPosition, int newPosition, FacadeObject object) {
            InternalFacadeEList<FacadeObject> list = this.validateObject(msg, object);
            if (list != null && list.contains(object)) {
                this.matchMove(msg, oldPosition, newPosition, object, list);
            }
        }

        protected <E extends FacadeObject> void matchMove(EObject umlOwner, EReference umlReference, int oldPosition, int newPosition, E object, InternalFacadeEList<E> list) {
            EList<EObject> umlList = this.getUMLList(umlOwner, umlReference);
            int insertion = list.size() - 1;
            int offset = newPosition < oldPosition ? 0 : -1;
            int i = newPosition + 1;
            while (i < umlList.size()) {
                int index;
                FacadeObject facade = this.getFacade(umlOwner, umlReference, (EObject)umlList.get(i));
                int n = index = facade == null ? -1 : list.indexOf(facade);
                if (index >= 0) {
                    insertion = index + offset;
                    break;
                }
                ++i;
            }
            if (insertion >= 0) {
                list.facadeMove(insertion, object);
            }
        }

        protected <E extends FacadeObject> void matchMove(Notification msg, int oldPosition, int newPosition, E object, InternalFacadeEList<E> list) {
            this.matchMove((EObject)msg.getNotifier(), (EReference)msg.getFeature(), oldPosition, newPosition, object, list);
        }

        protected <E extends FacadeObject> void matchAdd(EObject umlOwner, EReference umlReference, int position, E object, InternalFacadeEList<E> list) {
            EList<EObject> umlList = this.getUMLList(umlOwner, umlReference);
            int insertion = list.size();
            int i = umlList.size() - 1;
            while (i >= position) {
                int index;
                FacadeObject facade = this.getFacade(umlOwner, umlReference, (EObject)umlList.get(i));
                int n = index = facade == null ? -1 : list.indexOf(facade);
                if (index >= 0) {
                    insertion = index;
                    break;
                }
                --i;
            }
            list.facadeAdd(insertion, object);
        }

        protected EList<? extends EObject> getUMLList(EObject umlOwner, EReference umlReference) {
            return (EList)umlOwner.eGet((EStructuralFeature)umlReference);
        }

        protected void handleAttribute(Notification msg) {
            switch (msg.getEventType()) {
                case 3: {
                    this.handleValueAdded(msg, msg.getPosition(), msg.getNewValue());
                    break;
                }
                case 5: {
                    int addedAt = msg.getPosition();
                    for (Object next : (List)msg.getNewValue()) {
                        this.handleValueAdded(msg, addedAt, next);
                        if (addedAt < 0) continue;
                        ++addedAt;
                    }
                    break;
                }
                case 4: {
                    this.handleValueRemoved(msg, msg.getPosition(), msg.getOldValue());
                    break;
                }
                case 6: {
                    if (msg.getNewValue() instanceof int[]) {
                        int[] removedAt = (int[])msg.getNewValue();
                        List removed = (List)msg.getOldValue();
                        int i = removedAt.length - 1;
                        while (i >= 0) {
                            this.handleValueRemoved(msg, removedAt[i], removed.get(i));
                            ++i;
                        }
                    } else {
                        List removed = (List)msg.getOldValue();
                        int i = removed.size() - 1;
                        while (i >= 0) {
                            this.handleValueRemoved(msg, i, removed.get(i));
                            ++i;
                        }
                    }
                    break;
                }
                case 1: 
                case 2: 
                case 9: {
                    this.handleValueReplaced(msg, msg.getPosition(), msg.getOldValue(), msg.getNewValue());
                    break;
                }
                case 7: {
                    this.handleValueMoved(msg, (Integer)msg.getOldValue(), msg.getPosition(), msg.getNewValue());
                }
            }
        }

        protected void handleValueAdded(Notification msg, int position, Object value) {
        }

        protected void handleValueRemoved(Notification msg, int position, Object value) {
        }

        protected void handleValueReplaced(Notification msg, int position, Object oldValue, Object newValue) {
            this.handleValueAdded(msg, position, oldValue);
            this.handleValueRemoved(msg, position, newValue);
        }

        protected void handleValueMoved(Notification msg, int oldPosition, int newPosition, Object value) {
        }

        @Override
        public void tickle(NamedElement element) {
            InternalFacadeEList<FacadeObject> list;
            EReference reference;
            EObject owner = element.eContainer();
            FacadeObject facade = this.getFacade(owner, reference = element.eContainmentFeature(), (EObject)element);
            if (facade != null && (list = this.validateObject(owner, reference, facade)) != null && !list.contains(facade)) {
                EList umlList = (EList)owner.eGet((EStructuralFeature)reference);
                this.matchAdd(owner, reference, umlList.indexOf((Object)element), facade, list);
            }
        }

        @Override
        public void excluded(Element element) {
            EReference containment;
            InternalEObject internal = (InternalEObject)element;
            InternalEObject container = internal.eInternalContainer();
            FacadeObject facade = this.getFacade((EObject)container, containment = internal.eContainmentFeature(), (EObject)element);
            if (facade != null) {
                this.handleObjectExcluded((EObject)container, containment, facade);
            }
        }

        protected void handleObjectExcluded(EObject umlOwner, EReference umlReference, FacadeObject object) {
            InternalFacadeEList<FacadeObject> list = this.validateObject(umlOwner, umlReference, object);
            if (list != null) {
                list.facadeRemove(object);
            }
        }

        @Override
        public void reinherited(Element element) {
            EReference containment;
            InternalEObject internal = (InternalEObject)element;
            InternalEObject container = internal.eInternalContainer();
            FacadeObject facade = this.getFacade((EObject)container, containment = internal.eContainmentFeature(), (EObject)element);
            if (facade != null) {
                this.handleObjectReinherited((EObject)container, containment, facade);
            }
        }

        protected void handleObjectReinherited(EObject umlOwner, EReference umlReference, FacadeObject object) {
            InternalFacadeEList<FacadeObject> list = this.validateObject(umlOwner, umlReference, object);
            if (list != null && !list.contains(object)) {
                list.facadeAdd(object);
            }
        }
    }

    static enum ReferenceKind {
        HARD{

            @Override
            <T> Supplier<T> supplierOf(T referent) {
                return () -> referent;
            }
        }
        ,
        SOFT{

            @Override
            <T> Supplier<T> supplierOf(T referent) {
                return new SoftReference<T>(referent)::get;
            }
        };


        abstract <T> Supplier<T> supplierOf(T var1);
    }
}

