/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.CapsulePart;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.UMLRealTimePackage;
import org.eclipse.papyrusrt.umlrt.uml.FacadeObject;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTCapsule;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTCapsulePart;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTCapsulePartKind;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTConnector;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTPort;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.UMLRTUMLRTPackage;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.FacadeObjectImpl;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.FacadeType;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.UMLRTReplicatedElementImpl;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTElement;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class UMLRTCapsulePartImpl
extends UMLRTReplicatedElementImpl
implements UMLRTCapsulePart {
    static final FacadeType<Property, CapsulePart, UMLRTCapsulePartImpl> TYPE = new FacadeType(UMLRTCapsulePartImpl.class, UMLPackage.Literals.PROPERTY, UMLRealTimePackage.Literals.CAPSULE_PART, UMLRTCapsulePartImpl::getInstance, capsulePart -> (UMLRTCapsulePartImpl)capsulePart.getRedefinedPart(), UMLRTCapsulePartImpl::new);
    protected static final UMLRTCapsulePartKind KIND_EDEFAULT = UMLRTCapsulePartKind.FIXED;
    protected static final boolean OPTIONAL_EDEFAULT = false;

    protected UMLRTCapsulePartImpl() {
    }

    public static UMLRTCapsulePartImpl getInstance(Property part) {
        return UMLRTCapsulePartImpl.getFacade(part, TYPE);
    }

    @Override
    protected EClass eStaticClass() {
        return UMLRTUMLRTPackage.Literals.CAPSULE_PART;
    }

    protected FacadeObjectImpl.BasicFacadeAdapter<? extends UMLRTCapsulePartImpl> createFacadeAdapter() {
        return new CapsulePartAdapter<UMLRTCapsulePartImpl>(this);
    }

    @Override
    public UMLRTNamedElement getRedefinedElement() {
        UMLRTCapsulePart redefinedPart = this.getRedefinedPart();
        if (redefinedPart != null) {
            return redefinedPart;
        }
        return super.getRedefinedElement();
    }

    @Override
    public UMLRTNamedElement getRedefinitionContext() {
        UMLRTCapsule capsule = this.getCapsule();
        if (capsule != null) {
            return capsule;
        }
        return super.getRedefinitionContext();
    }

    @Override
    public UMLRTCapsulePartKind getKind() {
        Property uml = this.toUML();
        return UMLRTCapsulePartKind.get(uml.getLower(), uml.getUpper(), uml.getAggregation());
    }

    @Override
    public void setKind(UMLRTCapsulePartKind newKind) {
        if (Objects.requireNonNull(newKind, "newKind").isNull()) {
            throw new IllegalArgumentException(newKind.getName());
        }
        this.setOptional(!newKind.isRequired());
        if (this.toUML().getAggregation() == AggregationKind.COMPOSITE_LITERAL != newKind.isComposite()) {
            if (newKind.isComposite()) {
                this.toUML().setAggregation(AggregationKind.COMPOSITE_LITERAL);
            } else {
                this.toUML().setAggregation(AggregationKind.SHARED_LITERAL);
            }
        }
    }

    @Override
    public boolean isOptional() {
        return this.toUML().getLower() == 0;
    }

    @Override
    public void setOptional(boolean newOptional) {
        if (newOptional != this.isOptional()) {
            if (newOptional) {
                this.toUML().setLower(0);
            } else {
                final Property property = this.toUML();
                ValueSpecification upper = this.toUML().getUpperValue();
                if (upper == null) {
                    ValueSpecification lower = property.getLowerValue();
                    if (lower != null) {
                        lower.destroy();
                    }
                } else {
                    new UMLSwitch<ValueSpecification>(){

                        public ValueSpecification caseLiteralUnlimitedNatural(LiteralUnlimitedNatural object) {
                            property.setLower(object.getValue());
                            return property.getLowerValue();
                        }

                        public ValueSpecification caseValueSpecification(final ValueSpecification object) {
                            final ValueSpecification result = property.createLowerValue(null, null, object.eClass());
                            new EcoreUtil.Copier(){
                                private static final long serialVersionUID = 1L;

                                protected EObject createCopy(EObject eObject) {
                                    return eObject == object ? result : super.createCopy(eObject);
                                }
                            }.copy((EObject)object);
                            return result;
                        }
                    }.doSwitch((EObject)upper);
                }
                if (this.toUML().getAggregation() != AggregationKind.COMPOSITE_LITERAL) {
                    this.toUML().setAggregation(AggregationKind.COMPOSITE_LITERAL);
                }
            }
        }
    }

    @Override
    public void setReplicationFactor(int newReplicationFactor) {
        if (this.isSymbolicReplicationFactor() || this.getReplicationFactor() != newReplicationFactor) {
            Property property = this.toUML();
            if (!this.isOptional()) {
                property.setLower(newReplicationFactor);
            }
            property.setUpper(newReplicationFactor);
        }
    }

    @Override
    public void setReplicationFactorAsString(String newReplicationFactorAsString) {
        if (!Objects.equals(newReplicationFactorAsString, this.getReplicationFactorAsString())) {
            try {
                int asInt = Integer.parseInt(newReplicationFactorAsString);
                this.setReplicationFactor(asInt);
            }
            catch (Exception exception) {
                Property property = this.toUML();
                if (!this.isOptional()) {
                    UMLRTCapsulePartImpl.setReplicationFactor((MultiplicityElement)property, UMLPackage.Literals.MULTIPLICITY_ELEMENT__LOWER_VALUE, newReplicationFactorAsString);
                }
                UMLRTCapsulePartImpl.setReplicationFactor((MultiplicityElement)property, UMLPackage.Literals.MULTIPLICITY_ELEMENT__UPPER_VALUE, newReplicationFactorAsString);
            }
        }
    }

    @Override
    public UMLRTCapsulePart getRedefinedPart() {
        UMLRTCapsulePart result;
        if (this.toUML() instanceof InternalUMLRTElement) {
            Property superPart = (Property)((InternalUMLRTElement)this.toUML()).rtGetRedefinedElement();
            result = UMLRTCapsulePart.getInstance(superPart);
        } else {
            UMLRTNamedElement redef = super.getRedefinedElement();
            result = redef instanceof UMLRTCapsulePart ? (UMLRTCapsulePart)redef : null;
        }
        return result;
    }

    @Override
    public UMLRTCapsule getType() {
        Type result = this.toUML().getType();
        return result instanceof Class ? UMLRTCapsule.getInstance((Class)result) : null;
    }

    @Override
    public void setType(UMLRTCapsule newType) {
        if (newType == null) {
            this.toUML().setType(null);
        } else {
            this.toUML().setType((Type)newType.toUML());
        }
    }

    @Override
    public List<UMLRTConnector> getConnectorsOf(UMLRTPort port) {
        List result;
        UMLRTCapsule capsule = this.getCapsule();
        if (capsule == null) {
            result = Collections.emptyList();
        } else {
            Predicate<UMLRTConnector> excluded = UMLRTNamedElement::isExcluded;
            result = this.allConnectorsOf((UMLRTPort)port.getRootDefinition()).map(capsule::getRedefinitionOf).filter(Objects::nonNull).filter(excluded.negate()).distinct().collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }
        return result;
    }

    Stream<UMLRTConnector> allConnectorsOf(UMLRTPort portOnPart) {
        CacheAdapter cache = CacheAdapter.getCacheAdapter((Notifier)this.toUML());
        return this.getRedefinitionChain().stream().map(UMLRTNamedElement::toUML).flatMap(e -> cache.getNonNavigableInverseReferences((EObject)e).stream()).filter(s -> s.getEStructuralFeature() == UMLPackage.Literals.CONNECTOR_END__PART_WITH_PORT).map(EStructuralFeature.Setting::getEObject).map(ConnectorEnd.class::cast).filter(end -> UMLRTCapsulePartImpl.redefines(end.getRole(), portOnPart)).map(Element::getOwner).map(Connector.class::cast).map(UMLRTConnector::getInstance).filter(Objects::nonNull);
    }

    private static boolean redefines(ConnectableElement role, UMLRTPort port) {
        UMLRTPort rtRole;
        UMLRTPort uMLRTPort = rtRole = role instanceof Port ? UMLRTPort.getInstance((Port)role) : null;
        return rtRole != null && rtRole.redefines(port);
    }

    protected Stream<UMLRTCapsulePart> allRedefinitions() {
        Predicate<UMLRTCapsulePart> excluded = UMLRTNamedElement::isExcluded;
        UMLRTCapsule capsule = this.getCapsule();
        return capsule == null ? Stream.empty() : capsule.getHierarchy().map(c -> c.getRedefinitionOf(this)).filter(excluded.negate());
    }

    @Override
    public List<UMLRTConnector> getConnectorsOfPorts() {
        List result;
        UMLRTCapsule capsule = this.getCapsule();
        if (capsule == null) {
            result = Collections.emptyList();
        } else {
            Predicate<UMLRTConnector> excluded = UMLRTNamedElement::isExcluded;
            result = this.allConnectorsOfPorts().map(capsule::getRedefinitionOf).filter(Objects::nonNull).filter(excluded.negate()).distinct().collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }
        return result;
    }

    Stream<UMLRTConnector> allConnectorsOfPorts() {
        return this.getRedefinitionChain().stream().map(UMLRTCapsulePartImpl.class::cast).flatMap(UMLRTCapsulePartImpl::getEnds).map(Element::getOwner).map(Connector.class::cast).map(UMLRTConnector::getInstance).filter(Objects::nonNull);
    }

    Stream<ConnectorEnd> getEnds() {
        CacheAdapter cache = CacheAdapter.getCacheAdapter((Notifier)this.toUML());
        return cache.getNonNavigableInverseReferences((EObject)this.toUML()).stream().filter(s -> s.getEStructuralFeature() == UMLPackage.Literals.CONNECTOR_END__PART_WITH_PORT).map(EStructuralFeature.Setting::getEObject).map(ConnectorEnd.class::cast);
    }

    @Override
    public UMLRTCapsule getCapsule() {
        Class class_ = this.toUML().getClass_();
        return class_ == null ? null : UMLRTCapsule.getInstance(class_);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 17: {
                return this.getKind();
            }
            case 18: {
                return this.isOptional();
            }
            case 19: {
                return this.getRedefinedPart();
            }
            case 20: {
                return this.getCapsule();
            }
            case 21: {
                return this.getType();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    protected Object facadeGetAll(int referenceID) {
        return this.eGet(referenceID, true, true);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 17: {
                this.setKind((UMLRTCapsulePartKind)((Object)newValue));
                return;
            }
            case 18: {
                this.setOptional((Boolean)newValue);
                return;
            }
            case 21: {
                this.setType((UMLRTCapsule)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 17: {
                this.setKind(KIND_EDEFAULT);
                return;
            }
            case 18: {
                this.setOptional(false);
                return;
            }
            case 21: {
                this.setType(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return this.isSetRedefinedElement();
            }
            case 9: {
                return this.isSetRedefinitionContext();
            }
            case 17: {
                return this.getKind() != KIND_EDEFAULT;
            }
            case 18: {
                return this.isOptional();
            }
            case 19: {
                return this.getRedefinedPart() != null;
            }
            case 20: {
                return this.getCapsule() != null;
            }
            case 21: {
                return this.getType() != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public boolean isSetRedefinedElement() {
        return super.isSetRedefinedElement() || this.eIsSet(19);
    }

    @Override
    public boolean isSetRedefinitionContext() {
        return super.isSetRedefinitionContext() || this.eIsSet(20);
    }

    protected static class CapsulePartAdapter<F extends UMLRTCapsulePartImpl>
    extends UMLRTReplicatedElementImpl.ReplicationAdapter<F> {
        CapsulePartAdapter(F facade) {
            super(facade);
        }

        @Override
        protected void handleObjectReplaced(Notification msg, int position, FacadeObject oldObject, FacadeObject newObject) {
            if (msg.getFeature() == UMLPackage.Literals.TYPED_ELEMENT__TYPE) {
                if (((UMLRTCapsulePartImpl)this.get()).eNotificationRequired()) {
                    ((UMLRTCapsulePartImpl)this.get()).eNotify((Notification)new ENotificationImpl((InternalEObject)this.get(), msg.getEventType(), (EStructuralFeature)UMLRTUMLRTPackage.Literals.CAPSULE_PART__TYPE, (Object)oldObject, (Object)newObject));
                }
            } else {
                super.handleObjectReplaced(msg, position, oldObject, newObject);
            }
        }

        @Override
        protected void handleLowerBoundChanged(Object oldValue, Object newValue) {
            super.handleLowerBoundChanged(oldValue, newValue);
            int oldInt = CapsulePartAdapter.asIntegerBound(oldValue);
            int newInt = CapsulePartAdapter.asIntegerBound(newValue);
            if (oldInt != newInt && ((UMLRTCapsulePartImpl)this.get()).eNotificationRequired()) {
                UMLRTCapsulePartImpl part = (UMLRTCapsulePartImpl)this.get();
                Property uml = part.toUML();
                if (uml.getAggregation() == AggregationKind.COMPOSITE_LITERAL) {
                    part.eNotify((Notification)new ENotificationImpl((InternalEObject)part, 1, (EStructuralFeature)UMLRTUMLRTPackage.Literals.CAPSULE_PART__OPTIONAL, oldInt == 0, newInt == 0));
                }
                UMLRTCapsulePartKind kind = part.getKind();
                part.eNotify((Notification)new ENotificationImpl((InternalEObject)part, 1, (EStructuralFeature)UMLRTUMLRTPackage.Literals.CAPSULE_PART__KIND, (Object)UMLRTCapsulePartKind.get(oldInt, uml.getUpper(), uml.getAggregation()), (Object)kind));
            }
        }

        @Override
        protected void handleUpperBoundChanged(Object oldValue, Object newValue) {
            super.handleUpperBoundChanged(oldValue, newValue);
            int oldInt = CapsulePartAdapter.asIntegerBound(oldValue);
            int newInt = CapsulePartAdapter.asIntegerBound(newValue);
            if (oldInt != newInt && ((UMLRTCapsulePartImpl)this.get()).eNotificationRequired()) {
                UMLRTCapsulePartImpl part = (UMLRTCapsulePartImpl)this.get();
                Property uml = part.toUML();
                UMLRTCapsulePartKind kind = part.getKind();
                part.eNotify((Notification)new ENotificationImpl((InternalEObject)part, 1, (EStructuralFeature)UMLRTUMLRTPackage.Literals.CAPSULE_PART__KIND, (Object)UMLRTCapsulePartKind.get(uml.getLower(), oldInt, uml.getAggregation()), (Object)kind));
            }
        }

        @Override
        protected void handleValueReplaced(Notification msg, int position, Object oldValue, Object newValue) {
            if (msg.getFeature() == UMLPackage.Literals.PROPERTY__AGGREGATION) {
                if (((UMLRTCapsulePartImpl)this.get()).eNotificationRequired()) {
                    UMLRTCapsulePartImpl part = (UMLRTCapsulePartImpl)this.get();
                    Property uml = part.toUML();
                    UMLRTCapsulePartKind kind = part.getKind();
                    part.eNotify((Notification)new ENotificationImpl((InternalEObject)part, 1, (EStructuralFeature)UMLRTUMLRTPackage.Literals.CAPSULE_PART__KIND, (Object)UMLRTCapsulePartKind.get(uml.getLower(), uml.getUpper(), (AggregationKind)oldValue), (Object)kind));
                }
            } else {
                super.handleValueReplaced(msg, position, oldValue, newValue);
            }
        }
    }
}

