/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.PortRegistrationType;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTPort;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.UMLRealTimePackage;
import org.eclipse.papyrusrt.umlrt.uml.FacadeObject;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTCapsule;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTCapsulePart;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTConnector;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTPort;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTPortKind;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTProtocol;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.UMLRTUMLRTPackage;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.FacadeObjectImpl;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.FacadeType;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.UMLRTCapsulePartImpl;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.UMLRTReplicatedElementImpl;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTElement;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.common.util.DerivedUnionEObjectEList;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.util.UMLUtil;

public class UMLRTPortImpl
extends UMLRTReplicatedElementImpl
implements UMLRTPort {
    static final FacadeType<Port, RTPort, UMLRTPortImpl> TYPE = new FacadeType(UMLRTPortImpl.class, UMLPackage.Literals.PORT, UMLRealTimePackage.Literals.RT_PORT, UMLRTPortImpl::getInstance, port -> (UMLRTPortImpl)port.getRedefinedPort(), UMLRTPortImpl::new);
    protected static final UMLRTPortKind KIND_EDEFAULT = UMLRTPortKind.EXTERNAL_BEHAVIOR;
    protected static final boolean SERVICE_EDEFAULT = false;
    protected static final boolean BEHAVIOR_EDEFAULT = false;
    protected static final boolean CONJUGATED_EDEFAULT = false;
    protected static final boolean WIRED_EDEFAULT = false;
    protected static final boolean PUBLISH_EDEFAULT = false;
    protected static final boolean NOTIFICATION_EDEFAULT = false;
    protected static final PortRegistrationType REGISTRATION_EDEFAULT = PortRegistrationType.AUTOMATIC;
    protected static final String REGISTRATION_OVERRIDE_EDEFAULT = null;
    protected static final boolean IS_CONNECTED_EDEFAULT = false;
    protected static final boolean IS_CONNECTED_INSIDE_EDEFAULT = false;
    protected static final boolean IS_CONNECTED_OUTSIDE_EDEFAULT = false;
    protected static final int[] CONNECTOR_ESUBSETS = new int[]{33, 34};

    protected UMLRTPortImpl() {
    }

    public static UMLRTPortImpl getInstance(Port port) {
        return UMLRTPortImpl.getFacade(port, TYPE);
    }

    @Override
    protected EClass eStaticClass() {
        return UMLRTUMLRTPackage.Literals.PORT;
    }

    protected FacadeObjectImpl.BasicFacadeAdapter<? extends UMLRTPortImpl> createFacadeAdapter() {
        return new PortAdapter<UMLRTPortImpl>(this);
    }

    @Override
    public UMLRTNamedElement getRedefinedElement() {
        UMLRTPort redefinedPort = this.getRedefinedPort();
        if (redefinedPort != null) {
            return redefinedPort;
        }
        return super.getRedefinedElement();
    }

    @Override
    public List<UMLRTConnector> getConnectors() {
        CacheAdapter cache = this.getCacheAdapter();
        if (cache != null) {
            Resource eResource = this.eResource();
            List connectors = (List)cache.get(eResource, (EObject)this, (Object)UMLRTUMLRTPackage.Literals.PORT__CONNECTOR);
            if (connectors == null) {
                connectors = new DerivedUnionEObjectEList(UMLRTConnector.class, (InternalEObject)this, 32, CONNECTOR_ESUBSETS);
                cache.put(eResource, (EObject)this, (Object)UMLRTUMLRTPackage.Literals.PORT__CONNECTOR, (Object)connectors);
            }
            return connectors;
        }
        return new DerivedUnionEObjectEList(UMLRTConnector.class, (InternalEObject)this, 32, CONNECTOR_ESUBSETS);
    }

    @Override
    public UMLRTConnector getConnector(String name) {
        return this.getConnector(name, false);
    }

    @Override
    public UMLRTConnector getConnector(String name, boolean ignoreCase) {
        for (UMLRTConnector connector : this.getConnectors()) {
            if (name != null && (ignoreCase ? !name.equalsIgnoreCase(connector.getName()) : !name.equals(connector.getName()))) continue;
            return connector;
        }
        return null;
    }

    @Override
    public UMLRTNamedElement getRedefinitionContext() {
        UMLRTCapsule capsule = this.getCapsule();
        if (capsule != null) {
            return capsule;
        }
        return super.getRedefinitionContext();
    }

    @Override
    public boolean isConnected() {
        boolean result;
        CacheAdapter cache = this.getCacheAdapter();
        if (cache == null) {
            result = this.isConnectedInside() || this.isConnectedOutside();
        } else {
            Boolean cached = (Boolean)cache.get((EObject)this, (Object)UMLRTUMLRTPackage.Literals.PORT__IS_CONNECTED);
            if (cached == null) {
                cached = this.isConnectedInside() || this.isConnectedOutside();
                cache.put((EObject)this, (Object)UMLRTUMLRTPackage.Literals.PORT__IS_CONNECTED, (Object)cached);
            }
            result = cached;
        }
        return result;
    }

    @Override
    public UMLRTPortKind getKind() {
        return UMLRTPortKind.get(this.isService(), this.isBehavior(), this.isWired(), this.isPublish());
    }

    @Override
    public void setKind(UMLRTPortKind newKind) {
        if (Objects.requireNonNull(newKind, "kind").isNull()) {
            throw new IllegalArgumentException(newKind.getName());
        }
        switch (newKind) {
            case EXTERNAL_BEHAVIOR: {
                this.setService(true);
                this.setWired(true);
                this.setBehavior(true);
                this.setPublish(false);
                this.toUML().setVisibility(VisibilityKind.PUBLIC_LITERAL);
                break;
            }
            case INTERNAL_BEHAVIOR: {
                this.setService(false);
                this.setWired(true);
                this.setBehavior(true);
                this.setPublish(false);
                this.toUML().setVisibility(VisibilityKind.PROTECTED_LITERAL);
                break;
            }
            case RELAY: {
                this.setService(true);
                this.setWired(true);
                this.setBehavior(false);
                this.setPublish(false);
                this.toUML().setVisibility(VisibilityKind.PUBLIC_LITERAL);
                break;
            }
            case SAP: {
                this.setService(false);
                this.setWired(false);
                this.setBehavior(true);
                this.setPublish(false);
                this.toUML().setVisibility(VisibilityKind.PROTECTED_LITERAL);
                break;
            }
            case SPP: {
                this.setService(true);
                this.setWired(false);
                this.setBehavior(true);
                this.setPublish(true);
                this.toUML().setVisibility(VisibilityKind.PUBLIC_LITERAL);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid port kind: " + (Object)((Object)newKind));
            }
        }
    }

    @Override
    public UMLRTPort getRedefinedPort() {
        UMLRTPort result;
        if (this.toUML() instanceof InternalUMLRTElement) {
            Port superPort = (Port)((InternalUMLRTElement)this.toUML()).rtGetRedefinedElement();
            result = UMLRTPort.getInstance(superPort);
        } else {
            UMLRTNamedElement redef = super.getRedefinedElement();
            result = redef instanceof UMLRTPort ? (UMLRTPort)redef : null;
        }
        return result;
    }

    @Override
    public UMLRTProtocol getType() {
        Type result = this.toUML().getType();
        return result instanceof Collaboration ? UMLRTProtocol.getInstance((Collaboration)result, this.isConjugated()) : null;
    }

    @Override
    public void setType(UMLRTProtocol newType) {
        if (newType == null) {
            this.toUML().setType(null);
        } else {
            this.toUML().setType((Type)newType.toUML());
            this.setConjugated(newType.isConjugate());
        }
    }

    @Override
    public List<UMLRTCapsulePart> getPartsWithPort() {
        Predicate<UMLRTCapsulePart> excluded = UMLRTNamedElement::isExcluded;
        return (List)this.allPartsWithPort().filter(excluded.negate()).distinct().collect(Collectors.collectingAndThen(Collectors.toList(), list -> this.elist((EStructuralFeature)UMLRTUMLRTPackage.Literals.PORT__PARTS_WITH_PORT, list)));
    }

    @Override
    public UMLRTCapsulePart getPartsWithPort(String name) {
        return this.getPartsWithPort(name, false);
    }

    @Override
    public UMLRTCapsulePart getPartsWithPort(String name, boolean ignoreCase) {
        for (UMLRTCapsulePart partsWithPort : this.getPartsWithPort()) {
            if (name != null && (ignoreCase ? !name.equalsIgnoreCase(partsWithPort.getName()) : !name.equals(partsWithPort.getName()))) continue;
            return partsWithPort;
        }
        return null;
    }

    @Override
    public boolean isService() {
        return this.toUML().isService();
    }

    @Override
    public void setService(boolean newService) {
        this.toUML().setIsService(newService);
    }

    @Override
    public boolean isBehavior() {
        return this.toUML().isBehavior();
    }

    @Override
    public void setBehavior(boolean newBehavior) {
        this.toUML().setIsBehavior(newBehavior);
    }

    @Override
    public boolean isConjugated() {
        return this.toUML().isConjugated();
    }

    @Override
    public void setConjugated(boolean newConjugated) {
        this.toUML().setIsConjugated(newConjugated);
    }

    @Override
    public boolean isWired() {
        return this.toRT().isWired();
    }

    @Override
    public void setWired(boolean newWired) {
        this.toRT().setIsWired(newWired);
    }

    @Override
    public boolean isPublish() {
        return this.toRT().isPublish();
    }

    @Override
    public void setPublish(boolean newPublish) {
        this.toRT().setIsPublish(newPublish);
    }

    @Override
    public boolean isNotification() {
        return this.toRT().isNotification();
    }

    @Override
    public void setNotification(boolean newNotification) {
        this.toRT().setIsNotification(newNotification);
    }

    @Override
    public PortRegistrationType getRegistration() {
        return this.toRT().getRegistration();
    }

    @Override
    public void setRegistration(PortRegistrationType newRegistration) {
        this.toRT().setRegistration(newRegistration);
    }

    @Override
    public String getRegistrationOverride() {
        return this.toRT().getRegistrationOverride();
    }

    @Override
    public void setRegistrationOverride(String newRegistrationOverride) {
        this.toRT().setRegistrationOverride(newRegistrationOverride);
    }

    @Override
    public boolean isConnectedInside() {
        boolean result;
        CacheAdapter cache = this.getCacheAdapter();
        if (cache == null) {
            result = this.insideConnectors().findAny().isPresent();
        } else {
            Boolean cached = (Boolean)cache.get((EObject)this, (Object)UMLRTUMLRTPackage.Literals.PORT__IS_CONNECTED_INSIDE);
            if (cached == null) {
                cached = this.insideConnectors().findAny().isPresent();
                cache.put((EObject)this, (Object)UMLRTUMLRTPackage.Literals.PORT__IS_CONNECTED_INSIDE, (Object)cached);
            }
            result = cached;
        }
        return result;
    }

    @Override
    public boolean isConnectedOutside() {
        boolean result;
        CacheAdapter cache = this.getCacheAdapter();
        if (cache == null) {
            result = this.outsideConnectors().findAny().isPresent();
        } else {
            Boolean cached = (Boolean)cache.get((EObject)this, (Object)UMLRTUMLRTPackage.Literals.PORT__IS_CONNECTED_OUTSIDE);
            if (cached == null) {
                cached = this.outsideConnectors().findAny().isPresent();
                cache.put((EObject)this, (Object)UMLRTUMLRTPackage.Literals.PORT__IS_CONNECTED_OUTSIDE, (Object)cached);
            }
            result = cached;
        }
        return result;
    }

    @Override
    public List<UMLRTConnector> getInsideConnectors() {
        List result;
        CacheAdapter cache = this.getCacheAdapter();
        if (cache == null) {
            result = (List)this.insideConnectors().collect(Collectors.collectingAndThen(Collectors.toList(), list -> this.elist((EStructuralFeature)UMLRTUMLRTPackage.Literals.PORT__INSIDE_CONNECTOR, list)));
        } else {
            List cached = (List)cache.get((EObject)this, (Object)UMLRTUMLRTPackage.Literals.PORT__INSIDE_CONNECTOR);
            if (cached == null) {
                cached = (List)this.insideConnectors().collect(Collectors.collectingAndThen(Collectors.toList(), list -> this.elist((EStructuralFeature)UMLRTUMLRTPackage.Literals.PORT__INSIDE_CONNECTOR, list)));
                cache.put((EObject)this, (Object)UMLRTUMLRTPackage.Literals.PORT__INSIDE_CONNECTOR, (Object)cached);
            }
            result = cached;
        }
        return result;
    }

    protected Stream<UMLRTConnector> insideConnectors() {
        Stream<UMLRTConnector> result;
        UMLRTCapsule capsule = this.getCapsule();
        if (capsule == null) {
            result = Stream.empty();
        } else {
            Predicate<UMLRTConnector> excluded = UMLRTNamedElement::isExcluded;
            result = this.allConnectors().map(capsule::getRedefinitionOf).filter(Objects::nonNull).filter(excluded.negate()).distinct();
        }
        return result;
    }

    protected Stream<UMLRTConnector> allConnectors() {
        UMLRTCapsule capsule = this.getCapsule();
        Stream<UMLRTConnector> result = capsule == null ? Stream.empty() : this.getRedefinitionChain().stream().map(UMLRTPortImpl.class::cast).flatMap(UMLRTPortImpl::getEnds).map(Element::getOwner).map(Connector.class::cast).map(UMLRTConnector::getInstance).filter(Objects::nonNull);
        return result;
    }

    Stream<ConnectorEnd> getEnds() {
        return this.toUML().getEnds().stream();
    }

    @Override
    public UMLRTConnector getInsideConnector(String name) {
        return this.getInsideConnector(name, false);
    }

    @Override
    public UMLRTConnector getInsideConnector(String name, boolean ignoreCase) {
        for (UMLRTConnector insideConnector : this.getInsideConnectors()) {
            if (name != null && (ignoreCase ? !name.equalsIgnoreCase(insideConnector.getName()) : !name.equals(insideConnector.getName()))) continue;
            return insideConnector;
        }
        return null;
    }

    @Override
    public List<UMLRTConnector> getOutsideConnectors() {
        List result;
        CacheAdapter cache = this.getCacheAdapter();
        if (cache == null) {
            result = (List)this.outsideConnectors().collect(Collectors.collectingAndThen(Collectors.toList(), list -> this.elist((EStructuralFeature)UMLRTUMLRTPackage.Literals.PORT__OUTSIDE_CONNECTOR, list)));
        } else {
            List cached = (List)cache.get((EObject)this, (Object)UMLRTUMLRTPackage.Literals.PORT__OUTSIDE_CONNECTOR);
            if (cached == null) {
                cached = (List)this.outsideConnectors().collect(Collectors.collectingAndThen(Collectors.toList(), list -> this.elist((EStructuralFeature)UMLRTUMLRTPackage.Literals.PORT__OUTSIDE_CONNECTOR, list)));
                cache.put((EObject)this, (Object)UMLRTUMLRTPackage.Literals.PORT__OUTSIDE_CONNECTOR, (Object)cached);
            }
            result = cached;
        }
        return result;
    }

    protected Stream<UMLRTConnector> outsideConnectors() {
        UMLRTCapsule capsule = this.getCapsule();
        Stream<UMLRTConnector> result = capsule == null ? Stream.empty() : ((UMLRTPort)this.getRootDefinition()).getPartsWithPort().stream().flatMap(part -> part.getConnectorsOf(this).stream()).distinct();
        return result;
    }

    protected Stream<UMLRTCapsulePart> allPartsWithPort() {
        CacheAdapter cache = CacheAdapter.getCacheAdapter((Notifier)this.toUML());
        return this.allRedefinitions().map(UMLRTPort::getCapsule).map(UMLRTNamedElement::toUML).flatMap(e -> cache.getNonNavigableInverseReferences((EObject)e).stream()).filter(s -> s.getEStructuralFeature() == UMLPackage.Literals.TYPED_ELEMENT__TYPE).map(EStructuralFeature.Setting::getEObject).filter(Property.class::isInstance).map(Property.class::cast).map(UMLRTCapsulePart::getInstance).filter(Objects::nonNull).map(UMLRTCapsulePartImpl.class::cast).flatMap(UMLRTCapsulePartImpl::allRedefinitions).distinct();
    }

    protected Stream<UMLRTPort> allRedefinitions() {
        Predicate<UMLRTPort> excluded = UMLRTNamedElement::isExcluded;
        UMLRTCapsule capsule = this.getCapsule();
        return capsule == null ? Stream.of(this) : capsule.getHierarchy().map(c -> c.getRedefinitionOf(this)).filter(Objects::nonNull).filter(excluded.negate());
    }

    @Override
    public UMLRTConnector getOutsideConnector(String name) {
        return this.getOutsideConnector(name, false);
    }

    @Override
    public UMLRTConnector getOutsideConnector(String name, boolean ignoreCase) {
        for (UMLRTConnector outsideConnector : this.getOutsideConnectors()) {
            if (name != null && (ignoreCase ? !name.equalsIgnoreCase(outsideConnector.getName()) : !name.equals(outsideConnector.getName()))) continue;
            return outsideConnector;
        }
        return null;
    }

    @Override
    public UMLRTCapsule getCapsule() {
        return UMLRTCapsule.getInstance(this.toUML().getClass_());
    }

    @Override
    public Port toUML() {
        return (Port)super.toUML();
    }

    RTPort toRT() {
        return (RTPort)super.toRT();
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 32: {
                return this.getConnectors();
            }
            case 17: {
                return this.getKind();
            }
            case 18: {
                return this.getRedefinedPort();
            }
            case 19: {
                return this.getType();
            }
            case 20: {
                return this.getPartsWithPort();
            }
            case 21: {
                return this.isService();
            }
            case 22: {
                return this.isBehavior();
            }
            case 23: {
                return this.isConjugated();
            }
            case 24: {
                return this.isWired();
            }
            case 25: {
                return this.isPublish();
            }
            case 26: {
                return this.isNotification();
            }
            case 27: {
                return this.getRegistration();
            }
            case 28: {
                return this.getRegistrationOverride();
            }
            case 29: {
                return this.isConnected();
            }
            case 30: {
                return this.isConnectedInside();
            }
            case 31: {
                return this.isConnectedOutside();
            }
            case 33: {
                return this.getInsideConnectors();
            }
            case 34: {
                return this.getOutsideConnectors();
            }
            case 35: {
                return this.getCapsule();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    protected Object facadeGetAll(int referenceID) {
        return this.eGet(referenceID, true, true);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 17: {
                this.setKind((UMLRTPortKind)((Object)newValue));
                return;
            }
            case 19: {
                this.setType((UMLRTProtocol)newValue);
                return;
            }
            case 20: {
                this.getPartsWithPort().clear();
                this.getPartsWithPort().addAll((Collection)newValue);
                return;
            }
            case 21: {
                this.setService((Boolean)newValue);
                return;
            }
            case 22: {
                this.setBehavior((Boolean)newValue);
                return;
            }
            case 23: {
                this.setConjugated((Boolean)newValue);
                return;
            }
            case 24: {
                this.setWired((Boolean)newValue);
                return;
            }
            case 25: {
                this.setPublish((Boolean)newValue);
                return;
            }
            case 26: {
                this.setNotification((Boolean)newValue);
                return;
            }
            case 27: {
                this.setRegistration((PortRegistrationType)newValue);
                return;
            }
            case 28: {
                this.setRegistrationOverride((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 17: {
                this.setKind(KIND_EDEFAULT);
                return;
            }
            case 19: {
                this.setType(null);
                return;
            }
            case 20: {
                this.getPartsWithPort().clear();
                return;
            }
            case 21: {
                this.setService(false);
                return;
            }
            case 22: {
                this.setBehavior(false);
                return;
            }
            case 23: {
                this.setConjugated(false);
                return;
            }
            case 24: {
                this.setWired(false);
                return;
            }
            case 25: {
                this.setPublish(false);
                return;
            }
            case 26: {
                this.setNotification(false);
                return;
            }
            case 27: {
                this.setRegistration(REGISTRATION_EDEFAULT);
                return;
            }
            case 28: {
                this.setRegistrationOverride(REGISTRATION_OVERRIDE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return this.isSetRedefinedElement();
            }
            case 32: {
                return this.isSetConnectors();
            }
            case 9: {
                return this.isSetRedefinitionContext();
            }
            case 17: {
                return this.getKind() != KIND_EDEFAULT;
            }
            case 18: {
                return this.getRedefinedPort() != null;
            }
            case 19: {
                return this.getType() != null;
            }
            case 20: {
                return !this.getPartsWithPort().isEmpty();
            }
            case 21: {
                return this.isService();
            }
            case 22: {
                return this.isBehavior();
            }
            case 23: {
                return this.isConjugated();
            }
            case 24: {
                return this.isWired();
            }
            case 25: {
                return this.isPublish();
            }
            case 26: {
                return this.isNotification();
            }
            case 27: {
                return this.getRegistration() != REGISTRATION_EDEFAULT;
            }
            case 28: {
                return REGISTRATION_OVERRIDE_EDEFAULT == null ? this.getRegistrationOverride() != null : !REGISTRATION_OVERRIDE_EDEFAULT.equals(this.getRegistrationOverride());
            }
            case 29: {
                return this.isConnected();
            }
            case 30: {
                return this.isConnectedInside();
            }
            case 31: {
                return this.isConnectedOutside();
            }
            case 33: {
                return !this.getInsideConnectors().isEmpty();
            }
            case 34: {
                return !this.getOutsideConnectors().isEmpty();
            }
            case 35: {
                return this.getCapsule() != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public boolean isSetRedefinedElement() {
        return super.isSetRedefinedElement() || this.eIsSet(18);
    }

    public boolean isSetConnectors() {
        return this.eIsSet(33) || this.eIsSet(34);
    }

    @Override
    public boolean isSetRedefinitionContext() {
        return super.isSetRedefinitionContext() || this.eIsSet(35);
    }

    protected static class PortAdapter<F extends UMLRTPortImpl>
    extends UMLRTReplicatedElementImpl.ReplicationAdapter<F> {
        PortAdapter(F facade) {
            super(facade);
        }

        @Override
        public void setTarget(Notifier newTarget) {
            RTPort stereotype;
            super.setTarget(newTarget);
            if (newTarget instanceof Port && (stereotype = (RTPort)UMLUtil.getStereotypeApplication((Element)((Port)newTarget), RTPort.class)) != null) {
                this.addAdapter((Notifier)stereotype);
            }
        }

        @Override
        public void unsetTarget(Notifier newTarget) {
            RTPort stereotype;
            if (newTarget instanceof Port && (stereotype = (RTPort)UMLUtil.getStereotypeApplication((Element)((Port)newTarget), RTPort.class)) != null) {
                this.removeAdapter((Notifier)stereotype);
            }
            super.unsetTarget(newTarget);
        }

        @Override
        protected FacadeObject getFacade(EObject owner, EReference reference, EObject object) {
            FacadeObject result = super.getFacade(owner, reference, object);
            if (result instanceof UMLRTProtocol && ((UMLRTPortImpl)this.get()).isConjugated()) {
                result = ((UMLRTProtocol)result).getConjugate();
            }
            return result;
        }

        @Override
        protected void handleObjectReplaced(Notification msg, int position, FacadeObject oldObject, FacadeObject newObject) {
            if (msg.getFeature() == UMLPackage.Literals.TYPED_ELEMENT__TYPE) {
                if (((UMLRTPortImpl)this.get()).eNotificationRequired()) {
                    ((UMLRTPortImpl)this.get()).eNotify((Notification)new ENotificationImpl((InternalEObject)this.get(), msg.getEventType(), (EStructuralFeature)UMLRTUMLRTPackage.Literals.PORT__TYPE, (Object)oldObject, (Object)newObject));
                }
            } else {
                super.handleObjectReplaced(msg, position, oldObject, newObject);
            }
        }

        @Override
        protected void handleValueReplaced(Notification msg, int position, Object oldValue, Object newValue) {
            if (msg.getFeature() == UMLPackage.Literals.PORT__IS_CONJUGATED) {
                if (((UMLRTPortImpl)this.get()).eNotificationRequired()) {
                    ((UMLRTPortImpl)this.get()).eNotify((Notification)new ENotificationImpl((InternalEObject)this.get(), msg.getEventType(), (EStructuralFeature)UMLRTUMLRTPackage.Literals.PORT__CONJUGATED, oldValue, newValue));
                    UMLRTProtocol type = ((UMLRTPortImpl)this.get()).getType();
                    if (type != null) {
                        ((UMLRTPortImpl)this.get()).eNotify((Notification)new ENotificationImpl((InternalEObject)this.get(), msg.getEventType(), (EStructuralFeature)UMLRTUMLRTPackage.Literals.PORT__TYPE, (Object)type.getConjugate(), (Object)type));
                    }
                }
            } else if (msg.getFeature() == UMLPackage.Literals.PORT__IS_SERVICE) {
                if (((UMLRTPortImpl)this.get()).eNotificationRequired()) {
                    UMLRTPortImpl port = (UMLRTPortImpl)this.get();
                    port.eNotify((Notification)new ENotificationImpl((InternalEObject)port, msg.getEventType(), (EStructuralFeature)UMLRTUMLRTPackage.Literals.PORT__SERVICE, oldValue, newValue));
                    UMLRTPortKind kind = port.getKind();
                    port.eNotify((Notification)new ENotificationImpl((InternalEObject)port, msg.getEventType(), (EStructuralFeature)UMLRTUMLRTPackage.Literals.PORT__KIND, (Object)UMLRTPortKind.get((Boolean)oldValue, port.isBehavior(), port.isWired(), port.isPublish()), (Object)kind));
                }
            } else if (msg.getFeature() == UMLPackage.Literals.PORT__IS_BEHAVIOR) {
                if (((UMLRTPortImpl)this.get()).eNotificationRequired()) {
                    UMLRTPortImpl port = (UMLRTPortImpl)this.get();
                    port.eNotify((Notification)new ENotificationImpl((InternalEObject)port, msg.getEventType(), (EStructuralFeature)UMLRTUMLRTPackage.Literals.PORT__BEHAVIOR, oldValue, newValue));
                    UMLRTPortKind kind = port.getKind();
                    port.eNotify((Notification)new ENotificationImpl((InternalEObject)port, msg.getEventType(), (EStructuralFeature)UMLRTUMLRTPackage.Literals.PORT__KIND, (Object)UMLRTPortKind.get(port.isService(), (Boolean)oldValue, port.isWired(), port.isPublish()), (Object)kind));
                }
            } else if (msg.getFeature() == UMLRealTimePackage.Literals.RT_PORT__IS_WIRED) {
                if (((UMLRTPortImpl)this.get()).eNotificationRequired()) {
                    UMLRTPortImpl port = (UMLRTPortImpl)this.get();
                    port.eNotify((Notification)new ENotificationImpl((InternalEObject)port, msg.getEventType(), (EStructuralFeature)UMLRTUMLRTPackage.Literals.PORT__WIRED, oldValue, newValue));
                    UMLRTPortKind kind = port.getKind();
                    port.eNotify((Notification)new ENotificationImpl((InternalEObject)port, msg.getEventType(), (EStructuralFeature)UMLRTUMLRTPackage.Literals.PORT__KIND, (Object)UMLRTPortKind.get(port.isService(), port.isBehavior(), (Boolean)oldValue, port.isPublish()), (Object)kind));
                }
            } else if (msg.getFeature() == UMLRealTimePackage.Literals.RT_PORT__IS_PUBLISH) {
                if (((UMLRTPortImpl)this.get()).eNotificationRequired()) {
                    UMLRTPortImpl port = (UMLRTPortImpl)this.get();
                    port.eNotify((Notification)new ENotificationImpl((InternalEObject)port, msg.getEventType(), (EStructuralFeature)UMLRTUMLRTPackage.Literals.PORT__PUBLISH, oldValue, newValue));
                    UMLRTPortKind kind = port.getKind();
                    ((UMLRTPortImpl)this.get()).eNotify((Notification)new ENotificationImpl((InternalEObject)this.get(), msg.getEventType(), (EStructuralFeature)UMLRTUMLRTPackage.Literals.PORT__KIND, (Object)UMLRTPortKind.get(port.isService(), port.isBehavior(), port.isWired(), (Boolean)oldValue), (Object)kind));
                }
            } else if (msg.getFeature() == UMLRealTimePackage.Literals.RT_PORT__IS_NOTIFICATION) {
                if (((UMLRTPortImpl)this.get()).eNotificationRequired()) {
                    ((UMLRTPortImpl)this.get()).eNotify((Notification)new ENotificationImpl((InternalEObject)this.get(), msg.getEventType(), (EStructuralFeature)UMLRTUMLRTPackage.Literals.PORT__NOTIFICATION, oldValue, newValue));
                }
            } else if (msg.getFeature() == UMLRealTimePackage.Literals.RT_PORT__REGISTRATION) {
                if (((UMLRTPortImpl)this.get()).eNotificationRequired()) {
                    ((UMLRTPortImpl)this.get()).eNotify((Notification)new ENotificationImpl((InternalEObject)this.get(), msg.getEventType(), (EStructuralFeature)UMLRTUMLRTPackage.Literals.PORT__REGISTRATION, oldValue, newValue));
                }
            } else if (msg.getFeature() == UMLRealTimePackage.Literals.RT_PORT__REGISTRATION_OVERRIDE) {
                if (((UMLRTPortImpl)this.get()).eNotificationRequired()) {
                    ((UMLRTPortImpl)this.get()).eNotify((Notification)new ENotificationImpl((InternalEObject)this.get(), msg.getEventType(), (EStructuralFeature)UMLRTUMLRTPackage.Literals.PORT__REGISTRATION_OVERRIDE, oldValue, newValue));
                }
            } else {
                super.handleValueReplaced(msg, position, oldValue, newValue);
            }
        }
    }
}

