/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationWrapper;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageKind;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageSet;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTProtocol;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTProtocolMessage;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.UMLRTUMLRTPackage;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.FacadeObjectImpl;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.FacadeType;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.UMLRTNamedElementImpl;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.UMLRTProtocolImpl;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTElement;
import org.eclipse.papyrusrt.umlrt.uml.internal.util.CachedReference;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLRTProtocolMessageImpl
extends UMLRTNamedElementImpl
implements UMLRTProtocolMessage {
    static final FacadeType<Operation, EObject, UMLRTProtocolMessageImpl> TYPE = new FacadeType(UMLRTProtocolMessageImpl.class, UMLPackage.Literals.OPERATION, FacadeType.NO_STEREOTYPE, UMLRTProtocolMessageImpl::getInstance, message -> (UMLRTProtocolMessageImpl)message.getRedefinedMessage(), UMLRTProtocolMessageImpl::maybeCreate);
    protected static final RTMessageKind KIND_EDEFAULT = RTMessageKind.IN;
    protected static final boolean IS_CONJUGATE_EDEFAULT = false;
    private final boolean isConjugate;
    private final Supplier<UMLRTProtocolMessage> conjugate;
    private RTMessageKind kind;

    protected UMLRTProtocolMessageImpl() {
        this.isConjugate = false;
        this.conjugate = new CachedReference<UMLRTProtocolMessage>(() -> new UMLRTProtocolMessageImpl(this));
    }

    private UMLRTProtocolMessageImpl(UMLRTProtocolMessageImpl base) {
        this.isConjugate = true;
        this.conjugate = () -> base;
        this.init((Element)base.toUML(), base.toRT());
    }

    @Override
    <F extends FacadeObjectImpl> F init(Element element, EObject stereotype) {
        Object result = super.init(element, stereotype);
        this.getKind();
        return result;
    }

    public static UMLRTProtocolMessageImpl getInstance(Operation operation) {
        return UMLRTProtocolMessageImpl.getFacade(operation, TYPE);
    }

    static UMLRTProtocolMessage getInstance(Operation operation, boolean conjugate) {
        UMLRTProtocolMessageImpl result = UMLRTProtocolMessageImpl.getInstance(operation);
        return result == null || !conjugate ? result : result.getConjugate();
    }

    private static UMLRTProtocolMessageImpl maybeCreate(Operation operation) {
        return operation != null && UMLRTProtocolMessageImpl.isProtocolMessage(operation) ? new UMLRTProtocolMessageImpl() : null;
    }

    static boolean isProtocolMessage(Operation operation) {
        return operation.getNamespace() instanceof Interface && UMLRTProtocolImpl.isRTMessageSet((Interface)operation.getNamespace());
    }

    @Override
    protected EClass eStaticClass() {
        return UMLRTUMLRTPackage.Literals.PROTOCOL_MESSAGE;
    }

    protected FacadeObjectImpl.BasicFacadeAdapter<? extends UMLRTProtocolMessageImpl> createFacadeAdapter() {
        return new MessageAdapter<UMLRTProtocolMessageImpl>(this);
    }

    @Override
    public UMLRTNamedElement getRedefinedElement() {
        UMLRTProtocolMessage redefinedMessage = this.getRedefinedMessage();
        if (redefinedMessage != null) {
            return redefinedMessage;
        }
        return super.getRedefinedElement();
    }

    @Override
    public UMLRTNamedElement getRedefinitionContext() {
        UMLRTProtocol protocol = this.getProtocol();
        if (protocol != null) {
            return protocol;
        }
        return super.getRedefinitionContext();
    }

    @Override
    public RTMessageKind getKind() {
        if (this.kind == null) {
            this.kind = this.forConjugation(this.getMessageSet().map(RTMessageSet::getRtMsgKind).orElse(null));
        }
        return this.kind;
    }

    void kindChanged() {
        RTMessageKind oldKind = this.kind;
        this.kind = null;
        RTMessageKind newKind = this.getKind();
        if (oldKind != newKind && this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, (EStructuralFeature)UMLRTUMLRTPackage.Literals.PROTOCOL_MESSAGE__KIND, (Object)oldKind, (Object)newKind));
        }
    }

    Optional<RTMessageSet> getMessageSet() {
        return Optional.ofNullable(this.toUML().getNamespace()).filter(Interface.class::isInstance).map(Interface.class::cast).map(UMLRTProtocolImpl::getRTMessageSet);
    }

    private RTMessageKind forConjugation(RTMessageKind kind) {
        if (kind != null && this.isConjugate()) {
            switch (kind) {
                case IN: {
                    kind = RTMessageKind.OUT;
                    break;
                }
                case OUT: {
                    kind = RTMessageKind.IN;
                    break;
                }
            }
        }
        return kind;
    }

    @Override
    public void setKind(RTMessageKind newKind) {
        if (this.getKind() != Objects.requireNonNull(newKind, "newKind")) {
            ((UMLRTProtocolImpl)this.getProtocol()).requireMessageSet(this.forConjugation(newKind)).getOwnedOperations().add((Object)this.toUML());
        }
    }

    @Override
    public UMLRTProtocolMessage getRedefinedMessage() {
        UMLRTProtocolMessage result;
        if (this.toUML() instanceof InternalUMLRTElement) {
            Operation superOperation = (Operation)((InternalUMLRTElement)this.toUML()).rtGetRedefinedElement();
            result = UMLRTProtocolMessageImpl.getInstance(superOperation, this.isConjugate());
        } else {
            UMLRTNamedElement redef = super.getRedefinedElement();
            UMLRTProtocolMessage uMLRTProtocolMessage = result = redef instanceof UMLRTProtocolMessage ? (UMLRTProtocolMessage)redef : null;
            if (result != null && this.isConjugate()) {
                result = result.getConjugate();
            }
        }
        return result;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.toUML().getOwnedParameters();
    }

    @Override
    public Parameter getParameter(String name, Type type) {
        return this.getParameter(name, type, false);
    }

    @Override
    public Parameter getParameter(String name, Type type, boolean ignoreCase) {
        for (Parameter parameter : this.getParameters()) {
            if (name != null && (!ignoreCase ? !name.equals(parameter.getName()) : !name.equalsIgnoreCase(parameter.getName()))) continue;
            if (type != null && !type.equals(parameter.getType())) continue;
            return parameter;
        }
        return null;
    }

    @Override
    public boolean isConjugate() {
        return this.isConjugate;
    }

    @Override
    public UMLRTProtocolMessage getConjugate() {
        return this.conjugate.get();
    }

    @Override
    public UMLRTProtocol getProtocol() {
        Package protocolContainer = this.toUML().getNearestPackage();
        return UMLRTProtocol.getInstance((Collaboration)protocolContainer.getOwnedType(protocolContainer.getName(), false, UMLPackage.Literals.COLLABORATION, false), this.isConjugate());
    }

    @Override
    public Operation toUML() {
        return (Operation)super.toUML();
    }

    @Override
    public CallEvent toReceiveEvent() {
        return this.toUML().getNearestPackage().getPackagedElements().stream().filter(CallEvent.class::isInstance).map(CallEvent.class::cast).filter(ev -> ev.getOperation() == this.toUML()).findAny().orElse(null);
    }

    UMLRTProtocolMessageImpl initReceiveEvent() {
        CallEvent event = (CallEvent)this.toUML().getNearestPackage().createPackagedElement(null, UMLPackage.Literals.CALL_EVENT);
        event.setOperation(this.toUML());
        return this;
    }

    @Override
    public Parameter createParameter(String name, Type type) {
        return this.toUML().createOwnedParameter(name, type);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 14: {
                return this.getKind();
            }
            case 15: {
                return this.getRedefinedMessage();
            }
            case 16: {
                return this.getParameters();
            }
            case 17: {
                return this.isConjugate();
            }
            case 18: {
                return this.getConjugate();
            }
            case 19: {
                return this.getProtocol();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    protected Object facadeGetAll(int referenceID) {
        return this.eGet(referenceID, true, true);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 14: {
                this.setKind((RTMessageKind)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 14: {
                this.setKind(KIND_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return this.isSetRedefinedElement();
            }
            case 9: {
                return this.isSetRedefinitionContext();
            }
            case 14: {
                return this.getKind() != KIND_EDEFAULT;
            }
            case 15: {
                return this.getRedefinedMessage() != null;
            }
            case 16: {
                return !this.getParameters().isEmpty();
            }
            case 17: {
                return this.isConjugate();
            }
            case 18: {
                return this.getConjugate() != null;
            }
            case 19: {
                return this.getProtocol() != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public boolean isSetRedefinedElement() {
        return super.isSetRedefinedElement() || this.eIsSet(15);
    }

    @Override
    public boolean isSetRedefinitionContext() {
        return super.isSetRedefinitionContext() || this.eIsSet(19);
    }

    protected static class MessageAdapter<F extends UMLRTProtocolMessageImpl>
    extends UMLRTNamedElementImpl.NamedElementAdapter<F> {
        MessageAdapter(F facade) {
            super(facade);
        }

        @Override
        protected void handleReference(Notification msg) {
            if (msg.getFeature() == UMLPackage.Literals.BEHAVIORAL_FEATURE__OWNED_PARAMETER) {
                if (((UMLRTProtocolMessageImpl)this.get()).eNotificationRequired()) {
                    UMLRTProtocolMessageImpl message = (UMLRTProtocolMessageImpl)this.get();
                    message.eNotify((Notification)new NotificationWrapper(message, msg){

                        public Object getFeature() {
                            return UMLRTUMLRTPackage.Literals.PROTOCOL_MESSAGE__PARAMETER;
                        }
                    });
                }
            } else {
                super.handleReference(msg);
            }
        }
    }
}

