/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.internal.operations;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTElement;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTOpaqueBehavior;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTState;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTTransition;
import org.eclipse.papyrusrt.umlrt.uml.internal.umlext.ExtUMLExtPackage;
import org.eclipse.papyrusrt.umlrt.uml.internal.util.InheritableSingleContainment;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTExtensionUtil;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.RedefinableElement;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.uml2.uml.util.UMLUtil;

public class TransitionRTOperations
extends UMLUtil {
    protected TransitionRTOperations() {
    }

    public static Constraint getGuard(InternalUMLRTTransition transition, Trigger trigger) {
        return UMLRTExtensionUtil.getUMLRTContents((EObject)transition, (EStructuralFeature)UMLPackage.Literals.NAMESPACE__OWNED_RULE, new EStructuralFeature[0]).stream().filter(r -> r.getConstrainedElements().contains((Object)trigger)).findAny().orElse(null);
    }

    public static Vertex resolveVertex(InternalUMLRTTransition transition, EObject inherited) {
        Vertex result = null;
        if (inherited instanceof Vertex) {
            Vertex inheritedVertex;
            result = inheritedVertex = (Vertex)inherited;
            Region container = transition.getContainer();
            if (container != null) {
                StateMachine stateMachine;
                Vertex resolved;
                EReference containment = inheritedVertex.eContainmentFeature();
                if (containment == UMLPackage.Literals.REGION__SUBVERTEX || containment == ExtUMLExtPackage.Literals.REGION__IMPLICIT_SUBVERTEX) {
                    resolved = TransitionRTOperations.resolveVertex((Namespace)container, inheritedVertex);
                    if (resolved == null) {
                        container = container.getExtendedRegion();
                        while (container != null && resolved == null) {
                            resolved = TransitionRTOperations.resolveVertex((Namespace)container, inheritedVertex);
                            container = container.getExtendedRegion();
                        }
                    }
                    if (resolved != null) {
                        result = resolved;
                    }
                } else if (containment == UMLPackage.Literals.STATE_MACHINE__CONNECTION_POINT || containment == ExtUMLExtPackage.Literals.STATE_MACHINE__IMPLICIT_CONNECTION_POINT) {
                    Object machine = transition.containingStateMachine();
                    if (machine != null) {
                        Vertex resolved2 = TransitionRTOperations.resolveVertex((Namespace)machine, inheritedVertex);
                        if (resolved2 == null && !machine.getExtendedStateMachines().isEmpty()) {
                            machine = (StateMachine)machine.getExtendedStateMachines().get(0);
                            while (machine != null && resolved2 == null) {
                                resolved2 = TransitionRTOperations.resolveVertex((Namespace)machine, inheritedVertex);
                                machine = machine.getExtendedStateMachines().isEmpty() ? null : (StateMachine)machine.getExtendedStateMachines().get(0);
                            }
                        }
                        if (resolved2 != null) {
                            result = resolved2;
                        }
                    }
                } else if (containment == UMLPackage.Literals.STATE__CONNECTION_POINT || containment == ExtUMLExtPackage.Literals.STATE__IMPLICIT_CONNECTION_POINT) {
                    StateMachine machine;
                    resolved = null;
                    State state = container.getState();
                    if (state != null) {
                        resolved = TransitionRTOperations.resolveVertex((Namespace)state, inheritedVertex);
                    }
                    if (resolved == null && (machine = transition.containingStateMachine()) != null) {
                        InternalUMLRTState composite = (InternalUMLRTState)((Pseudostate)inheritedVertex).getState();
                        Optional<InternalUMLRTState> redefState = composite.rtDescendants().filter(s -> s.containingStateMachine() == machine).findAny();
                        resolved = redefState.map(myComposite -> TransitionRTOperations.resolveVertex((Namespace)myComposite, inheritedVertex)).orElse(null);
                    }
                    if (resolved != null) {
                        result = resolved;
                    }
                }
                if (result == inheritedVertex && (stateMachine = transition.containingStateMachine()) != null && inherited instanceof InternalUMLRTElement) {
                    InternalUMLRTElement internalInherited = (InternalUMLRTElement)inherited;
                    Iterator<Vertex> allVertices = TransitionRTOperations.allVertices(stateMachine);
                    while (allVertices.hasNext()) {
                        Vertex next = allVertices.next();
                        if (!(next instanceof InternalUMLRTElement) || !((InternalUMLRTElement)next).rtRedefines(internalInherited)) continue;
                        result = next;
                        break;
                    }
                }
            }
        }
        return result;
    }

    protected static Vertex resolveVertex(Namespace namespace, Vertex inherited) {
        Vertex result = null;
        result = inherited instanceof State ? (Vertex)namespace.getOwnedMembers().stream().filter(State.class::isInstance).map(State.class::cast).filter(state -> state.getRedefinedState() == inherited).findAny().orElse(null) : (Vertex)namespace.getOwnedMembers().stream().filter(arg_0 -> ((EClass)inherited.eClass()).isInstance(arg_0)).filter(InternalUMLRTElement.class::isInstance).map(InternalUMLRTElement.class::cast).filter(v -> v.rtGetRedefinedElement() == inherited).findAny().orElse(null);
        return result;
    }

    protected static Iterator<Vertex> allVertices(StateMachine stateMachine) {
        AbstractTreeIterator<EObject> tree = new AbstractTreeIterator<EObject>((Object)stateMachine, false){

            protected Iterator<? extends EObject> getChildren(Object object) {
                Iterator<Object> result = object instanceof Region ? this.contents((EObject)((Region)object), UMLPackage.Literals.REGION__SUBVERTEX, new EReference[0]) : (object instanceof State ? this.contents((EObject)((State)object), UMLPackage.Literals.STATE__REGION, UMLPackage.Literals.STATE__CONNECTION_POINT) : (object instanceof StateMachine ? this.contents((EObject)((StateMachine)object), UMLPackage.Literals.STATE_MACHINE__REGION, new EReference[0]) : Collections.emptyIterator()));
                return result;
            }

            private Iterator<? extends EObject> contents(EObject object, EReference reference, EReference ... rest) {
                return UMLRTExtensionUtil.getUMLRTContents(object, (EStructuralFeature)reference, (EStructuralFeature[])rest).iterator();
            }
        };
        return new Iterator<Vertex>((TreeIterator)tree){
            boolean done;
            Vertex prepared;
            private final /* synthetic */ TreeIterator val$tree;
            {
                this.val$tree = treeIterator;
            }

            @Override
            public boolean hasNext() {
                while (this.prepared == null) {
                    if (!this.val$tree.hasNext()) {
                        this.done = true;
                        break;
                    }
                    Object next = this.val$tree.next();
                    if (!(next instanceof Vertex)) continue;
                    this.prepared = (Vertex)next;
                }
                return !this.done;
            }

            @Override
            public Vertex next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Vertex result = this.prepared;
                this.prepared = null;
                return result;
            }
        };
    }

    static Effect getInheritableEffect(InternalUMLRTTransition owner) {
        return (Effect)EcoreUtil.getExistingAdapter((Notifier)owner, Effect.class);
    }

    static Effect demandInheritableEffect(InternalUMLRTTransition owner) {
        Effect result = TransitionRTOperations.getInheritableEffect(owner);
        if (result == null) {
            result = new Effect(owner);
            owner.eAdapters().add(0, (Object)result);
        }
        return result;
    }

    public static Behavior getEffect(InternalUMLRTTransition owner) {
        return (Behavior)TransitionRTOperations.demandInheritableEffect(owner).getInheritable();
    }

    public static void setEffect(InternalUMLRTTransition owner, Behavior newEffect) {
        TransitionRTOperations.demandInheritableEffect(owner).set(newEffect);
    }

    public static boolean isSetEffect(InternalUMLRTTransition owner) {
        Effect effect = TransitionRTOperations.getInheritableEffect(owner);
        return effect != null && effect.isSet();
    }

    public static void unsetEffect(InternalUMLRTTransition owner) {
        Effect effect = TransitionRTOperations.getInheritableEffect(owner);
        if (effect != null) {
            effect.unset();
        }
    }

    public static boolean isConsistentWith(InternalUMLRTTransition self, RedefinableElement transition) {
        boolean result = false;
        if (transition instanceof Transition && transition.isRedefinitionContextValid((RedefinableElement)self)) {
            Transition redefining = (Transition)transition;
            Vertex originalSource = self.getSource();
            Vertex source = redefining.getSource();
            if (source == null || originalSource == null || !UMLRTExtensionUtil.redefines(source, originalSource)) {
                return result;
            }
            EContentsEList originalTriggers = UMLRTExtensionUtil.getUMLRTContents((EObject)self, (EStructuralFeature)UMLPackage.Literals.TRANSITION__TRIGGER, new EStructuralFeature[0]);
            EContentsEList triggers = UMLRTExtensionUtil.getUMLRTContents((EObject)redefining, (EStructuralFeature)UMLPackage.Literals.TRANSITION__TRIGGER, new EStructuralFeature[0]);
            if (triggers.size() < originalTriggers.size()) {
                return result;
            }
            if (!originalTriggers.isEmpty() && !originalTriggers.stream().allMatch(t1 -> triggers.stream().anyMatch(t2 -> UMLRTExtensionUtil.redefines(t2, t1)))) {
                result = false;
            }
            result = true;
        }
        return result;
    }

    private static final class Effect
    extends InheritableSingleContainment<Behavior> {
        Effect(InternalUMLRTTransition owner) {
            super(owner.eDerivedStructuralFeatureID(19, Behavior.class));
        }

        public Object get(boolean resolve) {
            return ((InternalUMLRTTransition)this.getTarget()).umlGetEffect(resolve);
        }

        @Override
        protected NotificationChain basicSet(Behavior newEffect, NotificationChain msgs) {
            return ((InternalUMLRTTransition)this.getTarget()).umlBasicSetEffect(newEffect, msgs);
        }

        @Override
        protected Behavior createRedefinition(Behavior inherited) {
            InternalUMLRTOpaqueBehavior result = (InternalUMLRTOpaqueBehavior)super.createRedefinition(inherited);
            result.umlSetRedefinedElement((InternalUMLRTElement)inherited);
            result.handleRedefinedTransition((Transition)((InternalUMLRTTransition)this.getTarget()).rtGetRedefinedElement());
            return result;
        }
    }
}

