/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.internal.umlext.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.DelegatingEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.papyrusrt.umlrt.uml.internal.umlext.ExtElement;
import org.eclipse.papyrusrt.umlrt.uml.internal.umlext.ExtUMLExtFactory;
import org.eclipse.papyrusrt.umlrt.uml.internal.umlext.ExtUMLExtPackage;
import org.eclipse.papyrusrt.umlrt.uml.internal.umlext.operations.ElementOperations;
import org.eclipse.papyrusrt.umlrt.uml.internal.umlext.operations.NamespaceOperations;
import org.eclipse.papyrusrt.umlrt.uml.internal.umlext.util.ExtensionResource;
import org.eclipse.papyrusrt.umlrt.uml.internal.util.NotificationForwarder;
import org.eclipse.papyrusrt.umlrt.uml.internal.util.ReificationAdapter;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ExtensionHolder
extends UMLUtil {
    public static final int UML_EXTENSION_FEATURE_BASE = -2048;
    private final InternalEObject owner;
    private InternalEObject extension;
    private boolean suppressForwarding;

    public ExtensionHolder(InternalEObject owner) {
        this.owner = owner;
    }

    protected static EClass getExtensionEClass(EClass umlMetaclass) {
        return (EClass)ExtUMLExtPackage.eINSTANCE.getEClassifier(umlMetaclass.getName());
    }

    protected final EClass getExtensionEClass() {
        return ExtensionHolder.getExtensionEClass(this.owner.eClass());
    }

    protected final Class<?> getExtensionClass() {
        return this.getExtensionEClass().getInstanceClass();
    }

    protected final InternalEObject demandExtension() {
        if (this.extension == null) {
            if (ReificationAdapter.isUndoRedoInProgress((Notifier)this.owner)) {
                this.extension = this.findInverseExtension();
            }
            if (this.extension == null) {
                this.extension = (InternalEObject)ExtUMLExtFactory.eINSTANCE.create(this.getExtensionEClass());
                ((ExtElement)this.extension).setExtendedElement((Element)this.owner);
                ExtensionResource extent = ExtensionResource.demandExtensionExtent(this.owner);
                extent.run(this.owner, () -> {
                    boolean bl = extent.getContents().add((Object)this.extension);
                });
                this.extension.eAdapters().add((Object)new AdapterImpl(){

                    public void notifyChanged(Notification msg) {
                        if (!ExtensionHolder.this.suppressForwarding && msg.getFeature() != ExtUMLExtPackage.Literals.ELEMENT__EXTENDED_ELEMENT) {
                            NotificationForwarder.forward(ExtensionHolder.this.owner, msg);
                        }
                    }
                });
            }
        }
        return this.extension;
    }

    final InternalEObject findInverseExtension() {
        InternalEObject result = null;
        for (EStructuralFeature.Setting next : ExtensionHolder.getNonNavigableInverseReferences((EObject)this.owner)) {
            if (next.getEStructuralFeature() != ExtUMLExtPackage.Literals.ELEMENT__EXTENDED_ELEMENT) continue;
            result = (InternalEObject)next.getEObject();
            break;
        }
        return result;
    }

    public void createExtension() {
        this.demandExtension();
    }

    void setExtension(EObject extension) {
        if (!(extension instanceof ExtElement)) {
            throw new IllegalArgumentException("not an extension: " + extension);
        }
        ExtElement ext = (ExtElement)extension;
        if (ext.getExtendedElement() != this.owner) {
            throw new IllegalArgumentException("not an extension of owner: " + extension);
        }
        this.extension = (InternalEObject)ext;
        for (EReference containment : ext.eClass().getEAllContainments()) {
            Object value;
            if (containment.isDerived() || !containment.isChangeable() || !ext.eIsSet((EStructuralFeature)containment)) continue;
            if (containment.isMany()) {
                value = (List)ext.eGet((EStructuralFeature)containment);
                switch (value.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        NotificationForwarder.forward(this.owner, (Notification)new ENotificationImpl(this.extension, 3, (EStructuralFeature)containment, null, value.get(0), 0));
                        break;
                    }
                    default: {
                        NotificationForwarder.forward(this.owner, (Notification)new ENotificationImpl(this.extension, 5, (EStructuralFeature)containment, null, value, 0));
                        break;
                    }
                }
                continue;
            }
            value = ext.eGet((EStructuralFeature)containment);
            if (value == null) continue;
            NotificationForwarder.forward(this.owner, (Notification)new ENotificationImpl(this.extension, 1, (EStructuralFeature)containment, null, value));
        }
    }

    public void destroyExtension() {
        if (this.extension != null) {
            EcoreUtil.remove((EObject)this.extension);
            this.extension = null;
        }
    }

    public boolean hasExtension() {
        return this.extension != null;
    }

    public <T extends ExtElement> T getExtension(Class<T> metaclass) {
        return (T)(metaclass.isInstance(this.extension) ? (ExtElement)metaclass.cast(this.extension) : null);
    }

    public void suppressForwardingWhile(Runnable action) {
        boolean wasSuppressingForwarding = this.suppressForwarding;
        this.suppressForwarding = true;
        try {
            action.run();
        }
        finally {
            this.suppressForwarding = wasSuppressingForwarding;
        }
    }

    public static EStructuralFeature getExtensionFeature(EClass eClass, int featureID) {
        if (featureID <= -2048) {
            featureID = -2048 - featureID;
        }
        return ExtensionHolder.getExtensionEClass(eClass).getEStructuralFeature(featureID);
    }

    public <T> EList<T> getContents(InternalEObject object) {
        EStructuralFeature[] extContainments;
        EStructuralFeature[] realContainments = ((EClassImpl.FeatureSubsetSupplier)object.eClass().getEAllStructuralFeatures()).containments();
        EStructuralFeature[] eStructuralFeatureArray = extContainments = this.extension == null ? null : ((EClassImpl.FeatureSubsetSupplier)this.extension.eClass().getEAllStructuralFeatures()).containments();
        EStructuralFeature[] allContainments = extContainments == null || extContainments.length == 0 ? realContainments : (realContainments == null || realContainments.length == 0 ? extContainments : this.concat(realContainments, extContainments));
        return allContainments == null ? EContentsEList.emptyContentsEList() : new EContentsEList((EObject)object, allContainments);
    }

    <T> T[] concat(T[] first, T[] second) {
        Object[] result = (Object[])Array.newInstance(first.getClass().getComponentType(), first.length + second.length);
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public int getDerivedStructuralFeatureID(EStructuralFeature eStructuralFeature) {
        int result;
        Class containerClass = eStructuralFeature.getContainerClass();
        if (containerClass == null) {
            result = this.owner.eClass().getFeatureID(eStructuralFeature);
        } else if (containerClass.isAssignableFrom(this.getExtensionClass())) {
            int featureID = this.extension == null ? this.getExtensionEClass().getFeatureID(eStructuralFeature) : this.extension.eDerivedStructuralFeatureID(eStructuralFeature.getFeatureID(), containerClass);
            result = -2048 - featureID;
        } else {
            assert (this.owner.eClass().getEAllStructuralFeatures().contains((Object)eStructuralFeature)) : "The feature '" + eStructuralFeature.getName() + "' is not a valid feature";
            result = this.owner.eDerivedStructuralFeatureID(eStructuralFeature.getFeatureID(), containerClass);
        }
        return result;
    }

    public boolean isSet(EStructuralFeature eFeature) {
        Class containerClass = eFeature.getContainerClass();
        if (!containerClass.isAssignableFrom(this.getExtensionClass())) {
            throw new IllegalArgumentException(String.format("The feature '%s' is not a valid feature", eFeature.getName()));
        }
        boolean result = this.extension != null && this.extension.eIsSet(this.extension.eDerivedStructuralFeatureID(eFeature.getFeatureID(), containerClass));
        return result;
    }

    public boolean isSet(int featureID) {
        featureID = -2048 - featureID;
        return this.extension != null && this.extension.eIsSet(featureID);
    }

    public Object get(EStructuralFeature eFeature, boolean resolve) {
        Object result;
        Class containerClass = eFeature.getContainerClass();
        if (containerClass.isAssignableFrom(this.getExtensionClass())) {
            result = this.extension != null ? this.extension.eGet(eFeature, resolve) : (eFeature.isMany() ? (eFeature == ExtUMLExtPackage.Literals.ELEMENT__EXCLUDED_ELEMENT ? ElementOperations.getExcludedElements((Element)this.owner) : (eFeature == ExtUMLExtPackage.Literals.NAMESPACE__EXCLUDED_MEMBER ? NamespaceOperations.getExcludedMembers((Namespace)this.owner) : new DeferredEList(this.owner, eFeature))) : (eFeature == ExtUMLExtPackage.Literals.ELEMENT__EXTENDED_ELEMENT ? this.owner : null));
        } else {
            throw new IllegalArgumentException(String.format("The feature '%s' is not a valid feature", eFeature.getName()));
        }
        return result;
    }

    public Object get(int featureID, boolean resolve) {
        featureID = -2048 - featureID;
        return this.extension.eGet(featureID, resolve, true);
    }

    public void set(EStructuralFeature eFeature, Object newValue) {
        Class containerClass = eFeature.getContainerClass();
        if (!containerClass.isAssignableFrom(this.getExtensionClass())) {
            throw new IllegalArgumentException(String.format("The feature '%s' is not a valid changeable feature", eFeature.getName()));
        }
        int featureID = this.demandExtension().eDerivedStructuralFeatureID(eFeature.getFeatureID(), containerClass);
        this.extension.eSet(featureID, newValue);
    }

    public void set(int featureID, Object newValue) {
        featureID = -2048 - featureID;
        this.demandExtension().eSet(featureID, newValue);
    }

    public void unset(EStructuralFeature eFeature) {
        Class containerClass = eFeature.getContainerClass();
        if (containerClass.isAssignableFrom(this.getExtensionClass())) {
            if (this.extension != null) {
                this.extension.eUnset(this.extension.eDerivedStructuralFeatureID(eFeature.getFeatureID(), containerClass));
            }
        } else {
            throw new IllegalArgumentException(String.format("The feature '%s' is not a valid changeable feature", eFeature.getName()));
        }
    }

    public void unset(int featureID) {
        featureID = -2048 - featureID;
        if (this.extension != null) {
            this.extension.eUnset(featureID);
        }
    }

    public EStructuralFeature.Setting setting(EStructuralFeature eFeature) {
        EStructuralFeature.Setting result;
        Class containerClass = eFeature.getContainerClass();
        if (containerClass.isAssignableFrom(this.getExtensionClass())) {
            if (this.extension != null) {
                final EStructuralFeature.Setting setting = this.extension.eSetting(eFeature);
                result = new EStructuralFeature.Setting(){

                    public EObject getEObject() {
                        return ExtensionHolder.this.owner;
                    }

                    public EStructuralFeature getEStructuralFeature() {
                        return setting.getEStructuralFeature();
                    }

                    public Object get(boolean resolve) {
                        return setting.get(resolve);
                    }

                    public boolean isSet() {
                        return setting.isSet();
                    }

                    public void set(Object newValue) {
                        setting.set(newValue);
                    }

                    public void unset() {
                        setting.unset();
                    }
                };
            } else {
                result = eFeature.isMany() ? new DeferredEList(this.owner, eFeature) : new DeferredSetting(this.owner, eFeature);
            }
        } else {
            throw new IllegalArgumentException(String.format("The feature '%s' is not a valid feature", eFeature.getName()));
        }
        return result;
    }

    private final class DeferredEList<E>
    extends DelegatingEList<E>
    implements InternalEList.Unsettable<E>,
    EStructuralFeature.Setting {
        private static final long serialVersionUID = 1L;
        private InternalEObject owner;
        private final EStructuralFeature feature;
        private List<E> delegate = ECollections.emptyEList();

        DeferredEList(InternalEObject owner, EStructuralFeature feature) {
            this.owner = owner;
            this.feature = feature;
        }

        public EObject getEObject() {
            return this.owner;
        }

        public EStructuralFeature getEStructuralFeature() {
            return this.feature;
        }

        protected List<E> delegateList() {
            return this.delegate;
        }

        void demandList() {
            if (this.owner == ExtensionHolder.this.owner) {
                this.owner = ExtensionHolder.this.demandExtension();
                this.delegate = (EList)this.owner.eGet(this.getEStructuralFeature());
            }
        }

        protected void delegateAdd(E object) {
            this.demandList();
            super.delegateAdd(object);
        }

        protected void delegateAdd(int index, E object) {
            this.demandList();
            super.delegateAdd(index, object);
        }

        protected void delegateClear() {
            this.demandList();
            super.delegateClear();
        }

        protected E delegateRemove(int index) {
            this.demandList();
            return (E)super.delegateRemove(index);
        }

        protected E delegateSet(int index, E object) {
            this.demandList();
            return (E)super.delegateSet(index, object);
        }

        protected E delegateMove(int targetIndex, int sourceIndex) {
            this.demandList();
            return (E)super.delegateMove(targetIndex, sourceIndex);
        }

        public List<E> basicList() {
            return super.basicList();
        }

        public Iterator<E> basicIterator() {
            return super.basicIterator();
        }

        public ListIterator<E> basicListIterator() {
            return super.basicListIterator();
        }

        public ListIterator<E> basicListIterator(int index) {
            return super.basicListIterator(index);
        }

        public E basicGet(int index) {
            return (E)super.basicGet(index);
        }

        public Object[] basicToArray() {
            return this.delegate instanceof InternalEList ? ((InternalEList)this.delegate).basicToArray() : this.delegate.toArray();
        }

        public <T> T[] basicToArray(T[] array) {
            return this.delegate instanceof InternalEList ? ((InternalEList)this.delegate).basicToArray((Object[])array) : this.delegate.toArray(array);
        }

        public int basicIndexOf(Object object) {
            return this.delegate instanceof InternalEList ? ((InternalEList)this.delegate).basicIndexOf(object) : this.delegate.indexOf(object);
        }

        public int basicLastIndexOf(Object object) {
            return this.delegate instanceof InternalEList ? ((InternalEList)this.delegate).basicLastIndexOf(object) : this.delegate.lastIndexOf(object);
        }

        public boolean basicContains(Object object) {
            return this.delegate instanceof InternalEList ? ((InternalEList)this.delegate).basicContains(object) : this.delegate.contains(object);
        }

        public boolean basicContainsAll(Collection<?> collection) {
            return this.delegate instanceof InternalEList ? ((InternalEList)this.delegate).basicContainsAll(collection) : this.delegate.containsAll(collection);
        }

        public NotificationChain basicRemove(Object object, NotificationChain notifications) {
            this.demandList();
            return ((InternalEList)this.delegate).basicRemove(object, notifications);
        }

        public NotificationChain basicAdd(E object, NotificationChain notifications) {
            this.demandList();
            return ((InternalEList)this.delegate).basicAdd(object, notifications);
        }

        public Object get(boolean resolve) {
            return this.delegate instanceof EStructuralFeature.Setting ? ((EStructuralFeature.Setting)this.delegate).get(resolve) : this;
        }

        public void set(Object newValue) {
            this.demandList();
            ((EStructuralFeature.Setting)this.delegate).set(newValue);
        }

        public boolean isSet() {
            return this.delegate instanceof EStructuralFeature.Setting ? ((EStructuralFeature.Setting)this.delegate).isSet() : false;
        }

        public void unset() {
            this.demandList();
            ((EStructuralFeature.Setting)this.delegate).unset();
        }
    }

    private final class DeferredSetting
    implements EStructuralFeature.Setting {
        private InternalEObject owner;
        private final EStructuralFeature feature;

        DeferredSetting(InternalEObject owner, EStructuralFeature feature) {
            this.owner = owner;
            this.feature = feature;
        }

        public EObject getEObject() {
            return this.owner;
        }

        public EStructuralFeature getEStructuralFeature() {
            return this.feature;
        }

        public Object get(boolean resolve) {
            return ExtensionHolder.this.extension == null ? this.feature.getDefaultValue() : ExtensionHolder.this.extension.eGet(this.feature, resolve);
        }

        public void set(Object newValue) {
            ExtensionHolder.this.demandExtension().eSet(this.feature, newValue);
        }

        public boolean isSet() {
            return ExtensionHolder.this.extension != null && ExtensionHolder.this.extension.eIsSet(this.feature);
        }

        public void unset() {
            if (ExtensionHolder.this.extension != null) {
                ExtensionHolder.this.extension.eUnset(this.feature);
            }
        }
    }
}

