/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.internal.util;

import java.util.Collection;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTElement;
import org.eclipse.papyrusrt.umlrt.uml.internal.util.NotificationForwarder;
import org.eclipse.papyrusrt.umlrt.uml.internal.util.RedefinedElementsList;

public class RedefinedElementsListImpl<E>
extends EObjectResolvingEList<E>
implements RedefinedElementsList<E> {
    private static final long serialVersionUID = 1L;
    private final Consumer<? super E> onRedefinition;

    public RedefinedElementsListImpl(Class<?> dataClass, InternalUMLRTElement owner, int featureID) {
        this(dataClass, owner, featureID, null);
    }

    public RedefinedElementsListImpl(Class<?> dataClass, InternalUMLRTElement owner, int featureID, Consumer<? super E> onRedefinition) {
        super(dataClass, (InternalEObject)owner, featureID);
        this.onRedefinition = onRedefinition;
    }

    @Override
    public void setRedefinedElement(E redefinedElement) {
        if (redefinedElement == null) {
            if (!this.isEmpty()) {
                this.clear();
            }
        } else if (this.isEmpty()) {
            this.add(redefinedElement);
        } else {
            this.set(0, redefinedElement);
        }
    }

    protected void didAdd(int index, E newObject) {
        super.didAdd(index, newObject);
        InternalUMLRTElement owner = (InternalUMLRTElement)this.getEObject();
        if (this.size() == 1 && NotificationForwarder.getInstance(owner) == null) {
            Collection<? extends EStructuralFeature> inherited = owner.rtInheritedFeatures();
            NotificationForwarder.adapt(owner, () -> new NotificationForwarder(owner, (EReference)this.getEStructuralFeature(), inherited));
            if (this.onRedefinition != null) {
                this.onRedefinition.accept(newObject);
            }
        }
    }

    protected void didRemove(int index, E oldObject) {
        super.didRemove(index, oldObject);
        if (this.size() == 0) {
            NotificationForwarder.unadapt((InternalUMLRTElement)this.getEObject());
            if (this.onRedefinition != null) {
                this.onRedefinition.accept(null);
            }
        }
    }
}

