/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.aexpr.lexer.tokens;

import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@ToString(singleLine=true)
@Data
public abstract class Token {
    private final int line;
    private final int column;
    private final String text;

    public Token(int line, int column, String text) {
        this.line = line;
        this.column = column;
        this.text = text;
    }

    @Pure
    public int hashCode() {
        int result = 1;
        result = 31 * result + this.line;
        result = 31 * result + this.column;
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Token other = (Token)obj;
        if (other.line != this.line) {
            return false;
        }
        if (other.column != this.column) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.singleLine();
        b.add("line", (Object)this.line);
        b.add("column", (Object)this.column);
        b.add("text", (Object)this.text);
        return b.toString();
    }

    @Pure
    public int getLine() {
        return this.line;
    }

    @Pure
    public int getColumn() {
        return this.column;
    }

    @Pure
    public String getText() {
        return this.text;
    }
}

