/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.external;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;

public class ExternalPackageMetadata {
    private String packageId;
    private Kind kind;
    private String nsURI;
    private String basePathmap;
    private String rootId;
    private String folderName;
    private String fileName;
    private EPackage ePackage;
    private Resource resource;
    private EObject rootElement;
    private String packageLocation;

    public ExternalPackageMetadata(String packageId, Kind kind, String nsURI, String basePathmap, String rootId, String folderName, String fileName, EPackage ePackage) {
        this.packageId = packageId;
        this.kind = kind;
        this.nsURI = nsURI;
        this.basePathmap = basePathmap;
        this.rootId = rootId;
        this.folderName = folderName;
        this.fileName = fileName;
        this.ePackage = ePackage;
    }

    public String getPackageId() {
        return this.packageId;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getNsURI() {
        return this.nsURI;
    }

    public String getBasePathmap() {
        return this.basePathmap;
    }

    public String getRootId() {
        return this.rootId;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPathmap() {
        String pathmap = null;
        String basePathmap = this.getBasePathmap();
        if (basePathmap != null && !basePathmap.isEmpty()) {
            char last = basePathmap.charAt(basePathmap.length() - 1);
            String separator = last == '/' ? "" : "/";
            pathmap = String.valueOf(basePathmap) + separator + this.getFileName();
        }
        return pathmap;
    }

    public String getRootPathmap() {
        return String.valueOf(this.getPathmap()) + "#" + this.getRootId();
    }

    public URI getRootURI() {
        return URI.createURI((String)this.getRootPathmap());
    }

    public URI getPathmapURI() {
        return URI.createURI((String)this.getPathmap());
    }

    public String getPackageLocation() {
        return this.packageLocation;
    }

    public URI getPackageLocationURI() {
        return URI.createURI((String)this.getPackageLocation());
    }

    public EPackage getEPackage() {
        if (this.ePackage == null) {
            String nsURI = this.getNsURI();
            this.ePackage = EPackage.Registry.INSTANCE.getEPackage(nsURI);
        }
        return this.ePackage;
    }

    public Resource getResource() {
        return this.resource;
    }

    public EObject getRootElement() {
        return this.rootElement;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setRoot(EObject root) {
        this.rootElement = root;
    }

    public void setPackageLocation(String loc) {
        this.packageLocation = loc;
    }

    public void setup() {
    }

    public static enum Kind {
        Package("package"),
        Library("library"),
        Profile("profile");

        private String name;

        private Kind(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }
    }
}

