/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.trans.to.dot.ui.handlers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrusrt.xtumlrt.common.Model;
import org.eclipse.papyrusrt.xtumlrt.common.Package;
import org.eclipse.papyrusrt.xtumlrt.common.ProtocolContainer;
import org.eclipse.papyrusrt.xtumlrt.trans.to.dot.Xtumlrt2DotTranslator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.xtext.ui.editor.outline.impl.EObjectNode;

public class TranslateToDotHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object selected;
        EObject eobj;
        IStructuredSelection selection;
        HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (sel instanceof IStructuredSelection && !(selection = (IStructuredSelection)sel).isEmpty() && (eobj = TranslateToDotHandler.getEObject(selected = selection.getFirstElement())) != null) {
            EObject eobjRoot = EcoreUtil.getRootContainer((EObject)eobj);
            IFile newFile = TranslateToDotHandler.getNewFile(eobjRoot);
            final IStatus status = TranslateToDotHandler.generate(eobjRoot, newFile);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Translate to Dot", null, (IStatus)status);
                }
            });
        }
        return null;
    }

    public static IFile getNewFile(EObject eobj) {
        IResource currentResource = TranslateToDotHandler.getIResource(eobj);
        IProject project = currentResource.getProject();
        String currentFileName = currentResource.getName();
        String newExtension = "dot";
        String newName = String.valueOf(currentFileName) + "." + newExtension;
        IFile newFile = project.getFile(newName);
        return newFile;
    }

    public static IResource getIResource(EObject eobj) {
        Resource resource = eobj.eResource();
        URI uri = resource.getURI();
        String platformResourceString = uri.toPlatformString(true);
        Path path = new Path(platformResourceString);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = workspaceRoot.getFile((IPath)path);
        return file;
    }

    public static IStatus generate(EObject eobjRoot, IFile file) {
        CharSequence seq = null;
        if (eobjRoot instanceof Model) {
            seq = Xtumlrt2DotTranslator.translateTopLevel((ProtocolContainer)((Model)eobjRoot));
        } else if (eobjRoot instanceof Package) {
            seq = Xtumlrt2DotTranslator.translateTopLevel((ProtocolContainer)((Package)eobjRoot));
        }
        if (!file.exists()) {
            byte[] bytes = seq.toString().getBytes();
            ByteArrayInputStream source = new ByteArrayInputStream(bytes);
            try {
                file.create((InputStream)source, true, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public static EObject getEObject(Object obj) {
        EObject eobj = null;
        if (obj != null && obj instanceof EObjectNode) {
            EObjectNode on = (EObjectNode)obj;
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.getResource(on.getEObjectURI(), true);
            eobj = on.getEObject(resource);
        }
        return eobj;
    }
}

