/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.umlrt;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PortKind implements Enumerator
{
    EXTERNAL(0, "EXTERNAL", "EXTERNAL"),
    INTERNAL(1, "INTERNAL", "INTERNAL"),
    RELAY(2, "RELAY", "RELAY"),
    SAP(3, "SAP", "SAP"),
    SPP(4, "SPP", "SPP");

    public static final int EXTERNAL_VALUE = 0;
    public static final int INTERNAL_VALUE = 1;
    public static final int RELAY_VALUE = 2;
    public static final int SAP_VALUE = 3;
    public static final int SPP_VALUE = 4;
    private static final PortKind[] VALUES_ARRAY;
    public static final List<PortKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PortKind[]{EXTERNAL, INTERNAL, RELAY, SAP, SPP};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PortKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PortKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PortKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PortKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PortKind get(int value) {
        switch (value) {
            case 0: {
                return EXTERNAL;
            }
            case 1: {
                return INTERNAL;
            }
            case 2: {
                return RELAY;
            }
            case 3: {
                return SAP;
            }
            case 4: {
                return SPP;
            }
        }
        return null;
    }

    private PortKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

