/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.util;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrusrt.xtumlrt.common.Annotation;
import org.eclipse.papyrusrt.xtumlrt.common.AnnotationParameter;
import org.eclipse.papyrusrt.xtumlrt.common.Attribute;
import org.eclipse.papyrusrt.xtumlrt.common.BaseContainer;
import org.eclipse.papyrusrt.xtumlrt.common.Behaviour;
import org.eclipse.papyrusrt.xtumlrt.common.Capsule;
import org.eclipse.papyrusrt.xtumlrt.common.CapsulePart;
import org.eclipse.papyrusrt.xtumlrt.common.CommonElement;
import org.eclipse.papyrusrt.xtumlrt.common.CommonFactory;
import org.eclipse.papyrusrt.xtumlrt.common.Connector;
import org.eclipse.papyrusrt.xtumlrt.common.EnumerationLiteral;
import org.eclipse.papyrusrt.xtumlrt.common.Generalization;
import org.eclipse.papyrusrt.xtumlrt.common.LiteralBoolean;
import org.eclipse.papyrusrt.xtumlrt.common.LiteralInteger;
import org.eclipse.papyrusrt.xtumlrt.common.LiteralNatural;
import org.eclipse.papyrusrt.xtumlrt.common.LiteralNull;
import org.eclipse.papyrusrt.xtumlrt.common.LiteralReal;
import org.eclipse.papyrusrt.xtumlrt.common.LiteralString;
import org.eclipse.papyrusrt.xtumlrt.common.LiteralUnlimited;
import org.eclipse.papyrusrt.xtumlrt.common.Model;
import org.eclipse.papyrusrt.xtumlrt.common.MultiplicityElement;
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement;
import org.eclipse.papyrusrt.xtumlrt.common.OpaqueExpression;
import org.eclipse.papyrusrt.xtumlrt.common.Package;
import org.eclipse.papyrusrt.xtumlrt.common.Port;
import org.eclipse.papyrusrt.xtumlrt.common.Protocol;
import org.eclipse.papyrusrt.xtumlrt.common.ProtocolBehaviourFeature;
import org.eclipse.papyrusrt.xtumlrt.common.ProtocolBehaviourFeatureKind;
import org.eclipse.papyrusrt.xtumlrt.common.ProtocolContainer;
import org.eclipse.papyrusrt.xtumlrt.common.RedefinableElement;
import org.eclipse.papyrusrt.xtumlrt.common.Signal;
import org.eclipse.papyrusrt.xtumlrt.common.StructuredType;
import org.eclipse.papyrusrt.xtumlrt.common.ValueSpecification;
import org.eclipse.papyrusrt.xtumlrt.umlrt.PortKind;
import org.eclipse.papyrusrt.xtumlrt.umlrt.PortRegistration;
import org.eclipse.papyrusrt.xtumlrt.umlrt.RTPort;
import org.eclipse.papyrusrt.xtumlrt.util.GeneralUtil;
import org.eclipse.papyrusrt.xtumlrt.util.XTUMLRTAnnotations;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class XTUMLRTUtil {
    public static List<CommonElement> getContainerList(CommonElement element) {
        ArrayList _xblockexpression = null;
        ArrayList result = CollectionLiterals.newArrayList((Object[])new CommonElement[0]);
        CommonElement elem = element;
        while (elem != null) {
            result.add(0, elem);
            NamedElement _owner = XTUMLRTUtil.getOwner(elem);
            elem = _owner;
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static Behaviour getActualBehaviour(Capsule capsule) {
        Behaviour _xblockexpression = null;
        Behaviour behaviour = null;
        if (capsule != null) {
            boolean _tripleNotEquals;
            Behaviour _behaviour = capsule.getBehaviour();
            boolean bl = _tripleNotEquals = _behaviour != null;
            if (_tripleNotEquals) {
                Behaviour _behaviour_1;
                behaviour = _behaviour_1 = capsule.getBehaviour();
            } else if (capsule.getRedefines() != null && capsule.getRedefines() instanceof Capsule) {
                Behaviour _actualBehaviour;
                RedefinableElement _redefines = capsule.getRedefines();
                behaviour = _actualBehaviour = XTUMLRTUtil.getActualBehaviour((Capsule)_redefines);
            }
        }
        _xblockexpression = behaviour;
        return _xblockexpression;
    }

    public static Iterable<Attribute> getAllAttributes(final StructuredType struct) {
        LinkedHashSet<Attribute> _xblockexpression = null;
        LinkedHashSet<Attribute> allAttributes = new LinkedHashSet<Attribute>();
        if (struct != null) {
            Iterable<Attribute> _classAttributes = XTUMLRTUtil.getClassAttributes(struct);
            Iterables.addAll(allAttributes, _classAttributes);
            RedefinableElement parentElement = struct.getRedefines();
            if (parentElement != null && parentElement instanceof StructuredType) {
                StructuredType parent = (StructuredType)parentElement;
                Iterable<Attribute> _allAttributes = XTUMLRTUtil.getAllAttributes(parent);
                Functions.Function1<Attribute, Boolean> _function = new Functions.Function1<Attribute, Boolean>(){

                    public Boolean apply(Attribute it) {
                        boolean _redefines = XTUMLRTUtil.redefines((NamedElement)struct, (RedefinableElement)it);
                        return !_redefines;
                    }
                };
                Iterable _filter = IterableExtensions.filter(_allAttributes, (Functions.Function1)_function);
                Iterables.addAll(allAttributes, (Iterable)_filter);
            }
        }
        _xblockexpression = allAttributes;
        return _xblockexpression;
    }

    public static Iterable<Capsule> getAllCapsules(BaseContainer model) {
        LinkedHashSet<Capsule> _xblockexpression = null;
        LinkedHashSet<Capsule> set = new LinkedHashSet<Capsule>();
        EList _entities = model.getEntities();
        Iterable _filter = Iterables.filter((Iterable)_entities, Capsule.class);
        Iterables.addAll(set, (Iterable)_filter);
        EList _packages = model.getPackages();
        for (Package pkg : _packages) {
            Iterable<Capsule> _allCapsules = XTUMLRTUtil.getAllCapsules((BaseContainer)pkg);
            Iterables.addAll(set, _allCapsules);
        }
        _xblockexpression = set;
        return _xblockexpression;
    }

    protected static Iterable<Protocol> _getAllProtocols(Model model) {
        LinkedHashSet<Protocol> _xblockexpression = null;
        LinkedHashSet<Protocol> set = new LinkedHashSet<Protocol>();
        EList _protocols = model.getProtocols();
        set.addAll((Collection<Protocol>)_protocols);
        EList _packages = model.getPackages();
        for (Package pkg : _packages) {
            Iterable<Protocol> _allProtocols = XTUMLRTUtil.getAllProtocols((ProtocolContainer)pkg);
            Iterables.addAll(set, _allProtocols);
        }
        _xblockexpression = set;
        return _xblockexpression;
    }

    protected static Iterable<Protocol> _getAllProtocols(Package packge) {
        LinkedHashSet<Protocol> _xblockexpression = null;
        LinkedHashSet<Protocol> set = new LinkedHashSet<Protocol>();
        EList _protocols = packge.getProtocols();
        set.addAll((Collection<Protocol>)_protocols);
        EList _packages = packge.getPackages();
        for (Package pkg : _packages) {
            Iterable<Protocol> _allProtocols = XTUMLRTUtil.getAllProtocols((ProtocolContainer)pkg);
            Iterables.addAll(set, _allProtocols);
        }
        _xblockexpression = set;
        return _xblockexpression;
    }

    public static Iterable<CapsulePart> getAllCapsuleParts(final Capsule capsule) {
        LinkedHashSet<CapsulePart> _xblockexpression = null;
        LinkedHashSet<CapsulePart> allParts = new LinkedHashSet<CapsulePart>();
        if (capsule != null) {
            Iterable<CapsulePart> _capsuleParts = XTUMLRTUtil.getCapsuleParts(capsule);
            Iterables.addAll(allParts, _capsuleParts);
            RedefinableElement parentElement = capsule.getRedefines();
            if (parentElement != null && parentElement instanceof Capsule) {
                Capsule parent = (Capsule)parentElement;
                Iterable<CapsulePart> _allCapsuleParts = XTUMLRTUtil.getAllCapsuleParts(parent);
                Functions.Function1<CapsulePart, Boolean> _function = new Functions.Function1<CapsulePart, Boolean>(){

                    public Boolean apply(CapsulePart it) {
                        boolean _redefines = XTUMLRTUtil.redefines((NamedElement)capsule, (RedefinableElement)it);
                        return !_redefines;
                    }
                };
                Iterable _filter = IterableExtensions.filter(_allCapsuleParts, (Functions.Function1)_function);
                Iterables.addAll(allParts, (Iterable)_filter);
            }
        }
        _xblockexpression = allParts;
        return _xblockexpression;
    }

    public static Iterable<Connector> getAllConnectors(final Capsule capsule) {
        LinkedHashSet<Connector> _xblockexpression = null;
        LinkedHashSet<Connector> allConnectors = new LinkedHashSet<Connector>();
        if (capsule != null) {
            Iterable<Connector> _capsuleConnectors = XTUMLRTUtil.getCapsuleConnectors(capsule);
            Iterables.addAll(allConnectors, _capsuleConnectors);
            RedefinableElement parentElement = capsule.getRedefines();
            if (parentElement != null && parentElement instanceof Capsule) {
                Capsule parent = (Capsule)parentElement;
                Iterable<Connector> _allConnectors = XTUMLRTUtil.getAllConnectors(parent);
                Functions.Function1<Connector, Boolean> _function = new Functions.Function1<Connector, Boolean>(){

                    public Boolean apply(Connector it) {
                        boolean _redefines = XTUMLRTUtil.redefines((NamedElement)capsule, (RedefinableElement)it);
                        return !_redefines;
                    }
                };
                Iterable _filter = IterableExtensions.filter(_allConnectors, (Functions.Function1)_function);
                Iterables.addAll(allConnectors, (Iterable)_filter);
            }
        }
        _xblockexpression = allConnectors;
        return _xblockexpression;
    }

    public static Iterable<CommonElement> getAllContainers(CommonElement element) {
        ArrayList _xblockexpression = null;
        ArrayList list = CollectionLiterals.newArrayList((Object[])new CommonElement[0]);
        CommonElement elem = element;
        while (elem != null) {
            list.add(0, elem);
            NamedElement _owner = XTUMLRTUtil.getOwner(elem);
            elem = _owner;
        }
        _xblockexpression = list;
        return _xblockexpression;
    }

    public static Iterable<Port> getAllRTPorts(final Capsule capsule) {
        LinkedHashSet<Port> _xblockexpression = null;
        LinkedHashSet<Port> allPorts = new LinkedHashSet<Port>();
        if (capsule != null) {
            Iterable<Port> _rTPorts = XTUMLRTUtil.getRTPorts(capsule);
            Iterables.addAll(allPorts, _rTPorts);
            RedefinableElement parentElement = capsule.getRedefines();
            if (parentElement != null && parentElement instanceof Capsule) {
                Capsule parent = (Capsule)parentElement;
                Iterable<Port> _allRTPorts = XTUMLRTUtil.getAllRTPorts(parent);
                Functions.Function1<Port, Boolean> _function = new Functions.Function1<Port, Boolean>(){

                    public Boolean apply(Port it) {
                        boolean _redefines = XTUMLRTUtil.redefines((NamedElement)capsule, (RedefinableElement)it);
                        return !_redefines;
                    }
                };
                Iterable _filter = IterableExtensions.filter(_allRTPorts, (Functions.Function1)_function);
                Iterables.addAll(allPorts, (Iterable)_filter);
            }
        }
        _xblockexpression = allPorts;
        return _xblockexpression;
    }

    public static Iterable<Signal> getAllSignals(final Protocol protocol) {
        LinkedHashSet<Signal> _xblockexpression = null;
        LinkedHashSet<Signal> allSignals = new LinkedHashSet<Signal>();
        if (protocol != null) {
            Iterable<Signal> _signals = XTUMLRTUtil.getSignals(protocol);
            Iterables.addAll(allSignals, _signals);
            RedefinableElement parentElement = protocol.getRedefines();
            if (parentElement != null && parentElement instanceof Capsule) {
                Protocol parent = (Protocol)parentElement;
                Iterable<Signal> _allSignals = XTUMLRTUtil.getAllSignals(parent);
                Functions.Function1<Signal, Boolean> _function = new Functions.Function1<Signal, Boolean>(){

                    public Boolean apply(Signal it) {
                        boolean _redefines = XTUMLRTUtil.redefines((NamedElement)protocol, (RedefinableElement)it);
                        return !_redefines;
                    }
                };
                Iterable _filter = IterableExtensions.filter(_allSignals, (Functions.Function1)_function);
                Iterables.addAll(allSignals, (Iterable)_filter);
            }
        }
        _xblockexpression = allSignals;
        return _xblockexpression;
    }

    public static Iterable<Attribute> getClassAttributes(StructuredType struct) {
        LinkedHashSet<Attribute> _xblockexpression = null;
        LinkedHashSet<Attribute> attrs = new LinkedHashSet<Attribute>();
        EList _attributes = struct.getAttributes();
        Functions.Function1<Attribute, Boolean> _function = new Functions.Function1<Attribute, Boolean>(){

            public Boolean apply(Attribute it) {
                return it.getType() != null && !XTUMLRTUtil.isExcluded((CommonElement)it);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_attributes, (Functions.Function1)_function);
        Iterables.addAll(attrs, (Iterable)_filter);
        _xblockexpression = attrs;
        return _xblockexpression;
    }

    public static Iterable<CapsulePart> getCapsuleParts(Capsule capsule) {
        LinkedHashSet<CapsulePart> _xblockexpression = null;
        LinkedHashSet<CapsulePart> parts = new LinkedHashSet<CapsulePart>();
        EList _parts = capsule.getParts();
        Functions.Function1<CapsulePart, Boolean> _function = new Functions.Function1<CapsulePart, Boolean>(){

            public Boolean apply(CapsulePart it) {
                return it.getType() != null && !XTUMLRTUtil.isExcluded((CommonElement)it);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_parts, (Functions.Function1)_function);
        Iterables.addAll(parts, (Iterable)_filter);
        _xblockexpression = parts;
        return _xblockexpression;
    }

    public static Iterable<Port> getRTPorts(Capsule capsule) {
        LinkedHashSet<Port> _xblockexpression = null;
        LinkedHashSet<Port> ports = new LinkedHashSet<Port>();
        EList _ports = capsule.getPorts();
        Functions.Function1<Port, Boolean> _function = new Functions.Function1<Port, Boolean>(){

            public Boolean apply(Port it) {
                return it.getType() != null && !XTUMLRTUtil.isExcluded((CommonElement)it);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_ports, (Functions.Function1)_function);
        Iterables.addAll(ports, (Iterable)_filter);
        _xblockexpression = ports;
        return _xblockexpression;
    }

    public static Iterable<Connector> getCapsuleConnectors(Capsule capsule) {
        LinkedHashSet<Connector> _xblockexpression = null;
        LinkedHashSet<Connector> connectors = new LinkedHashSet<Connector>();
        EList _connectors = capsule.getConnectors();
        Functions.Function1<Connector, Boolean> _function = new Functions.Function1<Connector, Boolean>(){

            public Boolean apply(Connector it) {
                boolean _isExcluded = XTUMLRTUtil.isExcluded((CommonElement)it);
                return !_isExcluded;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_connectors, (Functions.Function1)_function);
        Iterables.addAll(connectors, (Iterable)_filter);
        _xblockexpression = connectors;
        return _xblockexpression;
    }

    public static NamedElement firstNamedContainer(EObject element) {
        NamedElement _xifexpression = null;
        if (element == null) {
            _xifexpression = null;
        } else {
            NamedElement _xifexpression_1 = null;
            if (element instanceof NamedElement) {
                _xifexpression_1 = (NamedElement)element;
            } else {
                EObject _eContainer = element.eContainer();
                NamedElement _firstNamedContainer = null;
                if (_eContainer != null) {
                    _firstNamedContainer = XTUMLRTUtil.firstNamedContainer(_eContainer);
                }
                _xifexpression_1 = _firstNamedContainer;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public static NamedElement firstNamespaceContainer(EObject element) {
        NamedElement _xifexpression = null;
        if (element == null) {
            _xifexpression = null;
        } else {
            NamedElement _xifexpression_1 = null;
            if (element instanceof NamedElement) {
                NamedElement _xifexpression_2 = null;
                boolean _isNamespace = XTUMLRTUtil.isNamespace((CommonElement)element);
                if (_isNamespace) {
                    _xifexpression_2 = (NamedElement)element;
                } else {
                    NamedElement _owner = XTUMLRTUtil.getOwner((CommonElement)element);
                    _xifexpression_2 = XTUMLRTUtil.firstNamespaceContainer((EObject)_owner);
                }
                _xifexpression_1 = _xifexpression_2;
            } else {
                EObject _eContainer = element.eContainer();
                NamedElement _firstNamespaceContainer = null;
                if (_eContainer != null) {
                    _firstNamespaceContainer = XTUMLRTUtil.firstNamespaceContainer(_eContainer);
                }
                _xifexpression_1 = _firstNamespaceContainer;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public static Iterable<Signal> getInSignals(Protocol protocol) {
        EList _protocolBehaviourFeatures = protocol.getProtocolBehaviourFeatures();
        Functions.Function1<ProtocolBehaviourFeature, Boolean> _function = new Functions.Function1<ProtocolBehaviourFeature, Boolean>(){

            public Boolean apply(ProtocolBehaviourFeature it) {
                return it instanceof Signal && Objects.equal((Object)it.getKind(), (Object)ProtocolBehaviourFeatureKind.IN);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_protocolBehaviourFeatures, (Functions.Function1)_function);
        Functions.Function1<ProtocolBehaviourFeature, Signal> _function_1 = new Functions.Function1<ProtocolBehaviourFeature, Signal>(){

            public Signal apply(ProtocolBehaviourFeature it) {
                return (Signal)it;
            }
        };
        return IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
    }

    public static Iterable<Signal> getInOutSignals(Protocol protocol) {
        EList _protocolBehaviourFeatures = protocol.getProtocolBehaviourFeatures();
        Functions.Function1<ProtocolBehaviourFeature, Boolean> _function = new Functions.Function1<ProtocolBehaviourFeature, Boolean>(){

            public Boolean apply(ProtocolBehaviourFeature it) {
                return it instanceof Signal && Objects.equal((Object)it.getKind(), (Object)ProtocolBehaviourFeatureKind.INOUT);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_protocolBehaviourFeatures, (Functions.Function1)_function);
        Functions.Function1<ProtocolBehaviourFeature, Signal> _function_1 = new Functions.Function1<ProtocolBehaviourFeature, Signal>(){

            public Signal apply(ProtocolBehaviourFeature it) {
                return (Signal)it;
            }
        };
        return IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
    }

    public static CommonElement getLowestCommonAncestor(CommonElement element1, CommonElement element2) {
        CommonElement _xblockexpression = null;
        Iterable<CommonElement> prefix = XTUMLRTUtil.getLowestCommonAncestorPrefix(element1, element2);
        _xblockexpression = (CommonElement)IterableExtensions.last(prefix);
        return _xblockexpression;
    }

    public static Iterable<CommonElement> getLowestCommonAncestorPrefix(CommonElement element1, CommonElement element2) {
        Iterable<CommonElement> _allContainers = XTUMLRTUtil.getAllContainers(element1);
        Iterable<CommonElement> _allContainers_1 = XTUMLRTUtil.getAllContainers(element2);
        return GeneralUtil.longestCommonPrefix(_allContainers, _allContainers_1);
    }

    public static Iterable<Signal> getOutSignals(Protocol protocol) {
        EList _protocolBehaviourFeatures = protocol.getProtocolBehaviourFeatures();
        Functions.Function1<ProtocolBehaviourFeature, Boolean> _function = new Functions.Function1<ProtocolBehaviourFeature, Boolean>(){

            public Boolean apply(ProtocolBehaviourFeature it) {
                return it instanceof Signal && Objects.equal((Object)it.getKind(), (Object)ProtocolBehaviourFeatureKind.OUT);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_protocolBehaviourFeatures, (Functions.Function1)_function);
        Functions.Function1<ProtocolBehaviourFeature, Signal> _function_1 = new Functions.Function1<ProtocolBehaviourFeature, Signal>(){

            public Signal apply(ProtocolBehaviourFeature it) {
                return (Signal)it;
            }
        };
        return IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
    }

    public static NamedElement getOwner(CommonElement element) {
        boolean _tripleEquals;
        NamedElement _xifexpression = null;
        EObject _eContainer = element.eContainer();
        boolean bl = _tripleEquals = _eContainer == null;
        if (_tripleEquals) {
            _xifexpression = null;
        } else {
            EObject _eContainer_1 = element.eContainer();
            _xifexpression = (NamedElement)_eContainer_1;
        }
        return _xifexpression;
    }

    public static BaseContainer getRoot(CommonElement element) {
        BaseContainer _xblockexpression = null;
        CommonElement elem = element;
        while (elem != null && XTUMLRTUtil.getOwner(elem) != null) {
            NamedElement _owner = XTUMLRTUtil.getOwner(elem);
            elem = _owner;
        }
        BaseContainer _xifexpression = null;
        _xifexpression = elem instanceof BaseContainer ? (BaseContainer)elem : null;
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static Iterable<Attribute> getAttributeRedefinitions(StructuredType struct) {
        EList _attributes = struct.getAttributes();
        Functions.Function1<Attribute, Boolean> _function = new Functions.Function1<Attribute, Boolean>(){

            public Boolean apply(Attribute it) {
                return it.getRedefines() != null && it.getRedefines() instanceof Attribute;
            }
        };
        return IterableExtensions.filter((Iterable)_attributes, (Functions.Function1)_function);
    }

    public static Iterable<CapsulePart> getPartRedefinitions(Capsule capsule) {
        EList _parts = capsule.getParts();
        Functions.Function1<CapsulePart, Boolean> _function = new Functions.Function1<CapsulePart, Boolean>(){

            public Boolean apply(CapsulePart it) {
                return it.getRedefines() != null && it.getRedefines() instanceof CapsulePart;
            }
        };
        return IterableExtensions.filter((Iterable)_parts, (Functions.Function1)_function);
    }

    public static Iterable<Port> getPortRedefinitions(Capsule capsule) {
        EList _ports = capsule.getPorts();
        Functions.Function1<Port, Boolean> _function = new Functions.Function1<Port, Boolean>(){

            public Boolean apply(Port it) {
                return it.getRedefines() != null && it.getRedefines() instanceof Port;
            }
        };
        return IterableExtensions.filter((Iterable)_ports, (Functions.Function1)_function);
    }

    public static Iterable<Connector> getConnectorRedefinitions(Capsule capsule) {
        EList _connectors = capsule.getConnectors();
        Functions.Function1<Connector, Boolean> _function = new Functions.Function1<Connector, Boolean>(){

            public Boolean apply(Connector it) {
                return it.getRedefines() != null && it.getRedefines() instanceof Connector;
            }
        };
        return IterableExtensions.filter((Iterable)_connectors, (Functions.Function1)_function);
    }

    public static Iterable<Signal> getSignalRedefinitions(Protocol protocol) {
        Iterable<Signal> _signals = XTUMLRTUtil.getSignals(protocol);
        Functions.Function1<Signal, Boolean> _function = new Functions.Function1<Signal, Boolean>(){

            public Boolean apply(Signal it) {
                return it.getRedefines() != null && it.getRedefines() instanceof Signal;
            }
        };
        return IterableExtensions.filter(_signals, (Functions.Function1)_function);
    }

    public static Iterable<Attribute> getRedefinedAttributes(StructuredType struct) {
        Iterable<Attribute> _attributeRedefinitions = XTUMLRTUtil.getAttributeRedefinitions(struct);
        Functions.Function1<Attribute, Attribute> _function = new Functions.Function1<Attribute, Attribute>(){

            public Attribute apply(Attribute it) {
                RedefinableElement _redefines = it.getRedefines();
                return (Attribute)_redefines;
            }
        };
        return IterableExtensions.map(_attributeRedefinitions, (Functions.Function1)_function);
    }

    public static Iterable<CapsulePart> getRedefinedParts(Capsule capsule) {
        Iterable<CapsulePart> _partRedefinitions = XTUMLRTUtil.getPartRedefinitions(capsule);
        Functions.Function1<CapsulePart, CapsulePart> _function = new Functions.Function1<CapsulePart, CapsulePart>(){

            public CapsulePart apply(CapsulePart it) {
                RedefinableElement _redefines = it.getRedefines();
                return (CapsulePart)_redefines;
            }
        };
        return IterableExtensions.map(_partRedefinitions, (Functions.Function1)_function);
    }

    public static Iterable<Port> getRedefinedPorts(Capsule capsule) {
        Iterable<Port> _portRedefinitions = XTUMLRTUtil.getPortRedefinitions(capsule);
        Functions.Function1<Port, Port> _function = new Functions.Function1<Port, Port>(){

            public Port apply(Port it) {
                RedefinableElement _redefines = it.getRedefines();
                return (Port)_redefines;
            }
        };
        return IterableExtensions.map(_portRedefinitions, (Functions.Function1)_function);
    }

    public static Iterable<Connector> getRedefinedConnectors(Capsule capsule) {
        Iterable<Connector> _connectorRedefinitions = XTUMLRTUtil.getConnectorRedefinitions(capsule);
        Functions.Function1<Connector, Connector> _function = new Functions.Function1<Connector, Connector>(){

            public Connector apply(Connector it) {
                RedefinableElement _redefines = it.getRedefines();
                return (Connector)_redefines;
            }
        };
        return IterableExtensions.map(_connectorRedefinitions, (Functions.Function1)_function);
    }

    public static Iterable<Signal> getRedefinedSignals(Protocol protocol) {
        Iterable<Signal> _signalRedefinitions = XTUMLRTUtil.getSignalRedefinitions(protocol);
        Functions.Function1<Signal, Signal> _function = new Functions.Function1<Signal, Signal>(){

            public Signal apply(Signal it) {
                RedefinableElement _redefines = it.getRedefines();
                return (Signal)_redefines;
            }
        };
        return IterableExtensions.map(_signalRedefinitions, (Functions.Function1)_function);
    }

    public static Iterable<StructuredType> getSupertypes(StructuredType type) {
        EList _generalizations = type.getGeneralizations();
        List _map = null;
        if (_generalizations != null) {
            Functions.Function1<Generalization, StructuredType> _function = new Functions.Function1<Generalization, StructuredType>(){

                public StructuredType apply(Generalization it) {
                    return it.getSuper();
                }
            };
            _map = ListExtensions.map((List)_generalizations, (Functions.Function1)_function);
        }
        return _map;
    }

    public static Iterable<Signal> getSignals(Protocol protocol) {
        EList _protocolBehaviourFeatures = protocol.getProtocolBehaviourFeatures();
        Functions.Function1<ProtocolBehaviourFeature, Boolean> _function = new Functions.Function1<ProtocolBehaviourFeature, Boolean>(){

            public Boolean apply(ProtocolBehaviourFeature it) {
                return it instanceof Signal && !XTUMLRTUtil.isExcluded((CommonElement)it);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_protocolBehaviourFeatures, (Functions.Function1)_function);
        Functions.Function1<ProtocolBehaviourFeature, Signal> _function_1 = new Functions.Function1<ProtocolBehaviourFeature, Signal>(){

            public Signal apply(ProtocolBehaviourFeature it) {
                return (Signal)it;
            }
        };
        return IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
    }

    public static boolean isExternalPort(Port port) {
        return port instanceof RTPort && Objects.equal((Object)((RTPort)port).getKind(), (Object)PortKind.EXTERNAL);
    }

    public static boolean isInternalPort(Port port) {
        return port instanceof RTPort && Objects.equal((Object)((RTPort)port).getKind(), (Object)PortKind.INTERNAL);
    }

    public static boolean isRelayPort(Port port) {
        return port instanceof RTPort && Objects.equal((Object)((RTPort)port).getKind(), (Object)PortKind.RELAY);
    }

    public static boolean isSAP(Port port) {
        return port instanceof RTPort && Objects.equal((Object)((RTPort)port).getKind(), (Object)PortKind.SAP);
    }

    public static boolean isSPP(Port port) {
        return port instanceof RTPort && Objects.equal((Object)((RTPort)port).getKind(), (Object)PortKind.SPP);
    }

    public static boolean isWired(Port port) {
        return port instanceof RTPort && ((RTPort)port).isWired();
    }

    public static boolean isAutomatic(Port port) {
        return port instanceof RTPort && Objects.equal((Object)((RTPort)port).getRegistration(), (Object)PortRegistration.AUTOMATIC);
    }

    public static boolean isAutomaticLocked(Port port) {
        return port instanceof RTPort && Objects.equal((Object)((RTPort)port).getRegistration(), (Object)PortRegistration.AUTOMATICLOCKED);
    }

    public static boolean isNamespace(CommonElement element) {
        return element instanceof StructuredType;
    }

    public static boolean isNotification(Port port) {
        return port instanceof RTPort && ((RTPort)port).isNotification();
    }

    public static boolean isPublish(Port port) {
        return port instanceof RTPort && ((RTPort)port).isPublish();
    }

    public static boolean isBorderPort(Port port) {
        return XTUMLRTUtil.isExternalPort(port) || XTUMLRTUtil.isRelayPort(port);
    }

    public static boolean isNonBorderPort(Port port) {
        boolean _isBorderPort = XTUMLRTUtil.isBorderPort(port);
        return !_isBorderPort;
    }

    public static String getRegistrationOverride(Port port) {
        String _xifexpression = null;
        _xifexpression = !(port instanceof RTPort) ? null : ((RTPort)port).getRegistrationOverride();
        return _xifexpression;
    }

    public static <T extends MultiplicityElement & NamedElement> boolean isReplicated(T element) {
        return !Objects.equal((Object)element.getLowerBound(), (Object)1) || !Objects.equal((Object)element.getUpperBound(), (Object)1);
    }

    protected static String _getStringValue(ValueSpecification valSpec) {
        return null;
    }

    protected static String _getStringValue(LiteralNull valSpec) {
        return String.valueOf(null);
    }

    protected static String _getStringValue(LiteralBoolean valSpec) {
        boolean _isValue = valSpec.isValue();
        return String.valueOf(_isValue);
    }

    protected static String _getStringValue(LiteralInteger valSpec) {
        int _value = valSpec.getValue();
        return String.valueOf(_value);
    }

    protected static String _getStringValue(LiteralReal valSpec) {
        double _value = valSpec.getValue();
        return String.valueOf(_value);
    }

    protected static String _getStringValue(LiteralString valSpec) {
        String _value = valSpec.getValue();
        String _valueOf = String.valueOf(_value);
        String _plus = "\"" + _valueOf;
        return String.valueOf(_plus) + "\"";
    }

    protected static String _getStringValue(LiteralNatural valSpec) {
        int _value = valSpec.getValue();
        return String.valueOf(_value);
    }

    protected static String _getStringValue(LiteralUnlimited valSpec) {
        return "*";
    }

    protected static String _getStringValue(OpaqueExpression valSpec) {
        String _elvis = null;
        String _body = null;
        if (valSpec != null) {
            _body = valSpec.getBody();
        }
        _elvis = _body != null ? _body : "0";
        return _elvis;
    }

    protected static String _getStringValue(EnumerationLiteral valSpec) {
        return valSpec.getName();
    }

    private static boolean _redefines(StructuredType struct, final Attribute attr) {
        Iterable<Attribute> _redefinedAttributes = XTUMLRTUtil.getRedefinedAttributes(struct);
        Functions.Function1<Attribute, Boolean> _function = new Functions.Function1<Attribute, Boolean>(){

            public Boolean apply(Attribute it) {
                return Objects.equal((Object)it, (Object)attr);
            }
        };
        return IterableExtensions.exists(_redefinedAttributes, (Functions.Function1)_function);
    }

    private static boolean _redefines(Capsule capsule, final Port port) {
        Iterable<Port> _redefinedPorts = XTUMLRTUtil.getRedefinedPorts(capsule);
        Functions.Function1<Port, Boolean> _function = new Functions.Function1<Port, Boolean>(){

            public Boolean apply(Port it) {
                return Objects.equal((Object)it, (Object)port);
            }
        };
        return IterableExtensions.exists(_redefinedPorts, (Functions.Function1)_function);
    }

    private static boolean _redefines(Capsule capsule, final CapsulePart part) {
        Iterable<CapsulePart> _redefinedParts = XTUMLRTUtil.getRedefinedParts(capsule);
        Functions.Function1<CapsulePart, Boolean> _function = new Functions.Function1<CapsulePart, Boolean>(){

            public Boolean apply(CapsulePart it) {
                return Objects.equal((Object)it, (Object)part);
            }
        };
        return IterableExtensions.exists(_redefinedParts, (Functions.Function1)_function);
    }

    private static boolean _redefines(Capsule capsule, final Connector conn) {
        Iterable<Connector> _redefinedConnectors = XTUMLRTUtil.getRedefinedConnectors(capsule);
        Functions.Function1<Connector, Boolean> _function = new Functions.Function1<Connector, Boolean>(){

            public Boolean apply(Connector it) {
                return Objects.equal((Object)it, (Object)conn);
            }
        };
        return IterableExtensions.exists(_redefinedConnectors, (Functions.Function1)_function);
    }

    private static boolean _redefines(Protocol protocol, final Signal signal) {
        Iterable<Signal> _redefinedSignals = XTUMLRTUtil.getRedefinedSignals(protocol);
        Functions.Function1<Signal, Boolean> _function = new Functions.Function1<Signal, Boolean>(){

            public Boolean apply(Signal it) {
                return Objects.equal((Object)it, (Object)signal);
            }
        };
        return IterableExtensions.exists(_redefinedSignals, (Functions.Function1)_function);
    }

    protected static ValueSpecification _getCopy(CommonElement element) {
        return null;
    }

    protected static ValueSpecification _getCopy(final LiteralInteger element) {
        LiteralInteger _createLiteralInteger = CommonFactory.eINSTANCE.createLiteralInteger();
        Procedures.Procedure1<LiteralInteger> _function = new Procedures.Procedure1<LiteralInteger>(){

            public void apply(LiteralInteger it) {
                int _value = element.getValue();
                it.setValue(_value);
            }
        };
        return (ValueSpecification)ObjectExtensions.operator_doubleArrow((Object)_createLiteralInteger, (Procedures.Procedure1)_function);
    }

    protected static ValueSpecification _getCopy(final LiteralNatural element) {
        LiteralNatural _createLiteralNatural = CommonFactory.eINSTANCE.createLiteralNatural();
        Procedures.Procedure1<LiteralNatural> _function = new Procedures.Procedure1<LiteralNatural>(){

            public void apply(LiteralNatural it) {
                int _value = element.getValue();
                it.setValue(_value);
            }
        };
        return (ValueSpecification)ObjectExtensions.operator_doubleArrow((Object)_createLiteralNatural, (Procedures.Procedure1)_function);
    }

    protected static ValueSpecification _getCopy(final OpaqueExpression element) {
        OpaqueExpression _createOpaqueExpression = CommonFactory.eINSTANCE.createOpaqueExpression();
        Procedures.Procedure1<OpaqueExpression> _function = new Procedures.Procedure1<OpaqueExpression>(){

            public void apply(OpaqueExpression it) {
                String _body = element.getBody();
                it.setBody(_body);
            }
        };
        return (ValueSpecification)ObjectExtensions.operator_doubleArrow((Object)_createOpaqueExpression, (Procedures.Procedure1)_function);
    }

    public static boolean isExcluded(CommonElement element) {
        Object rootFragment;
        EObject redefinedElementStereotype = XTUMLRTAnnotations.getAnnotation(element, "RTRedefinedElement");
        return redefinedElementStereotype != null && (rootFragment = XTUMLRTAnnotations.getAnnotationProperty(redefinedElementStereotype, "rootFragment")) == null;
    }

    public static Iterable<CommonElement> excludedElements(NamedElement container) {
        Iterable elements = CollectionLiterals.newArrayList((Object[])new CommonElement[0]);
        EObject ann = XTUMLRTAnnotations.getAnnotation((CommonElement)container, "Excluded");
        if (ann instanceof Annotation) {
            EList _parameters = ((Annotation)ann).getParameters();
            Functions.Function1<AnnotationParameter, Boolean> _function = new Functions.Function1<AnnotationParameter, Boolean>(){

                public Boolean apply(AnnotationParameter it) {
                    String _name = it.getName();
                    return Objects.equal((Object)_name, (Object)"excluded");
                }
            };
            AnnotationParameter param = (AnnotationParameter)IterableExtensions.findFirst((Iterable)_parameters, (Functions.Function1)_function);
            Object _value = param.getValue();
            elements = (Iterable)_value;
        }
        return elements;
    }

    public static boolean excludes(NamedElement container, final CommonElement element) {
        Iterable<CommonElement> _excludedElements = XTUMLRTUtil.excludedElements(container);
        Functions.Function1<CommonElement, Boolean> _function = new Functions.Function1<CommonElement, Boolean>(){

            public Boolean apply(CommonElement it) {
                return Objects.equal((Object)it, (Object)element);
            }
        };
        return IterableExtensions.exists(_excludedElements, (Functions.Function1)_function);
    }

    public static Iterable<Protocol> getAllProtocols(ProtocolContainer model) {
        if (model instanceof Model) {
            return XTUMLRTUtil._getAllProtocols((Model)model);
        }
        if (model instanceof Package) {
            return XTUMLRTUtil._getAllProtocols((Package)model);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(model).toString());
    }

    public static String getStringValue(ValueSpecification valSpec) {
        if (valSpec instanceof LiteralNatural) {
            return XTUMLRTUtil._getStringValue((LiteralNatural)valSpec);
        }
        if (valSpec instanceof LiteralUnlimited) {
            return XTUMLRTUtil._getStringValue((LiteralUnlimited)valSpec);
        }
        if (valSpec instanceof LiteralBoolean) {
            return XTUMLRTUtil._getStringValue((LiteralBoolean)valSpec);
        }
        if (valSpec instanceof LiteralInteger) {
            return XTUMLRTUtil._getStringValue((LiteralInteger)valSpec);
        }
        if (valSpec instanceof LiteralNull) {
            return XTUMLRTUtil._getStringValue((LiteralNull)valSpec);
        }
        if (valSpec instanceof LiteralReal) {
            return XTUMLRTUtil._getStringValue((LiteralReal)valSpec);
        }
        if (valSpec instanceof LiteralString) {
            return XTUMLRTUtil._getStringValue((LiteralString)valSpec);
        }
        if (valSpec instanceof OpaqueExpression) {
            return XTUMLRTUtil._getStringValue((OpaqueExpression)valSpec);
        }
        if (valSpec instanceof EnumerationLiteral) {
            return XTUMLRTUtil._getStringValue((EnumerationLiteral)valSpec);
        }
        if (valSpec != null) {
            return XTUMLRTUtil._getStringValue(valSpec);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(valSpec).toString());
    }

    private static boolean redefines(NamedElement capsule, RedefinableElement part) {
        if (capsule instanceof Capsule && part instanceof CapsulePart) {
            return XTUMLRTUtil._redefines((Capsule)capsule, (CapsulePart)part);
        }
        if (capsule instanceof Capsule && part instanceof Connector) {
            return XTUMLRTUtil._redefines((Capsule)capsule, (Connector)part);
        }
        if (capsule instanceof Capsule && part instanceof Port) {
            return XTUMLRTUtil._redefines((Capsule)capsule, (Port)part);
        }
        if (capsule instanceof StructuredType && part instanceof Attribute) {
            return XTUMLRTUtil._redefines((StructuredType)capsule, (Attribute)part);
        }
        if (capsule instanceof Protocol && part instanceof Signal) {
            return XTUMLRTUtil._redefines((Protocol)capsule, (Signal)part);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(capsule, part).toString());
    }

    public static ValueSpecification getCopy(CommonElement element) {
        if (element instanceof LiteralNatural) {
            return XTUMLRTUtil._getCopy((LiteralNatural)element);
        }
        if (element instanceof LiteralInteger) {
            return XTUMLRTUtil._getCopy((LiteralInteger)element);
        }
        if (element instanceof OpaqueExpression) {
            return XTUMLRTUtil._getCopy((OpaqueExpression)element);
        }
        if (element != null) {
            return XTUMLRTUtil._getCopy(element);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(element).toString());
    }

    public static class NameComparator
    implements Comparator<NamedElement> {
        @Override
        public int compare(NamedElement o1, NamedElement o2) {
            if (o1 == null) {
                int _xifexpression = 0;
                _xifexpression = o2 == null ? 0 : -1;
                return _xifexpression;
            }
            if (o2 == null) {
                return 1;
            }
            String name1 = o1.getName();
            String name2 = o2.getName();
            if (name1 == null) {
                int _xifexpression_1 = 0;
                _xifexpression_1 = name2 == null ? 0 : -1;
                return _xifexpression_1;
            }
            if (name2 == null) {
                return 1;
            }
            return name1.compareTo(name2);
        }
    }
}

