/*******************************************************************************
 * Copyright (c) 2015 Zeligsoft (2009) Limited and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package org.eclipse.papyrusrt.xtumlrt.util

import java.util.List
import org.eclipse.emf.ecore.ENamedElement
import java.util.function.Function

/**
 * @author eposse
 */
class GeneralUtil
{

	static def <T> void addIfNotNull(List<T> list, T obj)
	{
		if (list !== null && obj !== null)
		{
			list.add(obj)
		}
	}

	static def <T> void addIfNotPresent(List<T> list, T obj)
	{
		if (list !== null && obj !== null && !list.contains(obj))
		{
			list.add(obj)
		}
	}

	static def <T> addAllNonPresent(List<T> targetList,
		List<? extends T> sourceList)
	{
		sourceList.forEach[targetList.addIfNotPresent(it)]
	}

	static def <P, R, T extends R> transformList(List<? extends P> sourceList,
		Function<? super P, ? extends R> transform, Class<T> type)
	{
		sourceList.map[transform].filter(type).toList
	}

	static dispatch def String getName(ENamedElement eobj)
	{
		eobj.name
	}

	static dispatch def String getName(org.eclipse.uml2.uml.NamedElement eobj)
	{
		eobj.name
	}

	static dispatch def String getName(
		org.eclipse.papyrusrt.xtumlrt.common.NamedElement eobj)
	{
		eobj.name
	}

	static def <T> Iterable<T> longestCommonPrefix(Iterable<T> l1,
		Iterable<T> l2)
	{
		val prefix = newArrayList
		var i = 0
		while (l1.get(i) == l2.get(i))
		{
			prefix.add(l1.get(i))
			i++
		}
		prefix
	}

	static def longestCommonPrefix(String s1, String s2)
	{
		val prefix = new StringBuilder
		var i = 0
		while (s1.charAt(i) == s2.charAt(i))
		{
			prefix.append(s1.charAt(i))
			i++
		}
		prefix.toString
	}

}
