/*
 * generated by Xtext
 */
package org.eclipse.papyrusrt.xtumlrt.xtext.ui.labeling

import com.google.inject.Inject
import org.eclipse.papyrusrt.xtumlrt.statemach.StateMachine
import org.eclipse.papyrusrt.xtumlrt.common.Capsule
import org.eclipse.papyrusrt.xtumlrt.common.CapsulePart
import org.eclipse.papyrusrt.xtumlrt.umlrt.RTPort
import org.eclipse.papyrusrt.xtumlrt.common.Connector
import org.eclipse.papyrusrt.xtumlrt.common.Protocol
import org.eclipse.papyrusrt.xtumlrt.common.Signal
import org.eclipse.papyrusrt.xtumlrt.umlrt.RTModel
import org.eclipse.papyrusrt.xtumlrt.statemach.State
import org.eclipse.papyrusrt.xtumlrt.statemach.InitialPoint
import org.eclipse.papyrusrt.xtumlrt.statemach.Transition
import org.eclipse.papyrusrt.xtumlrt.statemach.DeepHistory
import org.eclipse.papyrusrt.xtumlrt.statemach.ChoicePoint
import org.eclipse.papyrusrt.xtumlrt.statemach.JunctionPoint
import org.eclipse.papyrusrt.xtumlrt.statemach.EntryPoint
import org.eclipse.papyrusrt.xtumlrt.statemach.ExitPoint
import org.eclipse.papyrusrt.xtumlrt.statemach.TerminatePoint
import org.eclipse.papyrusrt.xtumlrt.statemach.Pseudostate
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement
import org.eclipse.papyrusrt.xtumlrt.common.Entity
import org.eclipse.papyrusrt.xtumlrt.common.StructuredType
import org.eclipse.papyrusrt.xtumlrt.common.Attribute
import org.eclipse.papyrusrt.xtumlrt.common.Enumeration
import org.eclipse.papyrusrt.xtumlrt.common.EnumerationLiteral
import org.eclipse.papyrusrt.xtumlrt.common.Operation
import org.eclipse.papyrusrt.xtumlrt.common.Parameter
import org.eclipse.papyrusrt.xtumlrt.umlrt.Import
import org.eclipse.papyrusrt.xtumlrt.umlrt.AnyEvent
import org.eclipse.papyrusrt.xtumlrt.common.Artifact
import org.eclipse.papyrusrt.xtumlrt.interactions.Interaction
import org.eclipse.papyrusrt.xtumlrt.interactions.Lifeline
import org.eclipse.papyrusrt.xtumlrt.interactions.Message
import org.eclipse.papyrusrt.xtumlrt.interactions.MessageOccurrenceSpecification
import org.eclipse.papyrusrt.xtumlrt.interactions.ExecutionOccurrenceSpecification
import org.eclipse.papyrusrt.xtumlrt.interactions.Gate
import org.eclipse.papyrusrt.xtumlrt.interactions.ActionExecutionSpecification
import org.eclipse.papyrusrt.xtumlrt.interactions.BehaviourExecutionSpecification
import org.eclipse.papyrusrt.xtumlrt.interactions.InteractionFragment
import org.eclipse.papyrusrt.xtumlrt.common.TypedMultiplicityElement
import static extension org.eclipse.papyrusrt.xtumlrt.util.XTUMLRTUtil.*
import org.eclipse.papyrusrt.xtumlrt.common.MultiplicityElement
import org.eclipse.papyrusrt.xtumlrt.common.Port
import org.eclipse.papyrusrt.xtumlrt.common.ConnectorEnd

/**
 * Provides labels for EObjects.
 * 
 * See https://www.eclipse.org/Xtext/documentation/304_ide_concepts.html#label-provider
 */
class UmlrtLabelProvider extends org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider
{

	@Inject
	new(org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider delegate)
	{
		super(delegate);
	}

	def dispatch String text(NamedElement element) {
		textNamedElement(element)
	}

	def dispatch String text(TypedMultiplicityElement element) {
		var prefix = ""
		if (element.isReturnType) {
			prefix += 'RETURN'
		} else if (element instanceof NamedElement) {
			prefix += textNamedElement(element)
		} else {
			prefix += element.eClass.name
		}
		val type = element.type
		if (type !== null)
			prefix + ' : ' + text(element.type)
		else
			prefix
	}
	
	def dispatch String text(Parameter element) {
		val prefix = 
			if (element.isReturnType) {
				'RETURN'
			} else {
				element.direction.toString + ' ' + element.name
			}
		val type = element.type
		if (type !== null)
			prefix + ' : ' + text(element.type)
		else
			prefix
	}
	
	def dispatch String text(Port element) {
		val type = element.type
		if (type !== null)
			element.name + ' : ' + text(element.type)
		else
			element.name
	}
	
	def dispatch String text(CapsulePart element) {
		val type = element.type
		if (type !== null)
			element.name + ' : ' + text(element.type)
		else
			element.name
	}
	
	def dispatch String text(ConnectorEnd element) {
		val partWithPort = element.partWithPort
		val partWithPortText = if (partWithPort !== null) partWithPort.name + ":" else ''
		partWithPortText + element.role.name
	}
	
	private def textNamedElement(NamedElement element) {
		val metaclassName = element.eClass.name 
		if (element.name !== null && !element.name.empty) metaclassName + ' ' + element.name
		else metaclassName
	}
	
	private def isReturnType(TypedMultiplicityElement element) {
		val owner = element.owner
		owner instanceof Operation && (owner as Operation).returnType === element
	}
	
	def image(RTModel element) {
		'rt_model.gif'
	}
	
	def image(Capsule element) {
		'capsule.png'
	}
	
	def image(CapsulePart element) {
		'capsule_part.png'
	}
	
	def image(RTPort element) {
		'rt_port.gif'
	}
	
	def image(Connector element) {
		'rt_connector.gif'
	}
	
	def image(ConnectorEnd element) {
		'ConnectorEnd.gif'
	}
	
	def image(Protocol element) {
		'protocol.png'
	}
	
	def image(Signal element) {
		switch (element.kind) {
			case IN: 'protocolmessage_in.gif'
			case OUT: 'protocolmessage_out.gif'
			case INOUT: 'protocolmessage_inout.gif'
			default: 'protocolmessage_undefined.gif'
		}
	}
	
	def image(StateMachine element) {
		'rt_statemachine.gif'
	}
	
	def image(State element) {
		'rt_state.gif'
	}
	
	def image(Pseudostate element) {
		'rt_pseudostate.gif'
	}
	
	def image(InitialPoint element) {
		'rt_pseudostate_initial.gif'
	}
	
	def image(DeepHistory element) {
		'rt_pseudostate_deepHistory.gif'
	}
	
	def image(ChoicePoint element) {
		'rt_pseudostate_choice.gif'
	}
	
	def image(JunctionPoint element) {
		'rt_pseudostate_junction.gif'
	}
	
	def image(EntryPoint element) {
		'rt_pseudostate_entryPoint.gif'
	}
	
	def image(ExitPoint element) {
		'rt_pseudostate_exitPoint.gif'
	}
	
	def image(TerminatePoint element) {
		'rt_pseudostate_terminate.gif'
	}
	
	def image(Transition element) {
		'rt_transition.gif'
	}
	
	def image(Entity element) {
		'Class.gif'
	}

	def image(StructuredType element) {
		'DataType.gif'
	}

	def image(Attribute element) {
		'Property.gif'
	}

	def image(Operation element) {
		'Operation.gif'
	}

	def image(Parameter element) {
		switch (element.direction) {
			case IN: 'Parameter_in.gif'
			case OUT: 'Parameter_out.gif'
			case IN_OUT: 'Parameter_inout.gif'
			default: 'Parameter.gif'
		}
	}

	def image(Enumeration element) {
		'Enumeration.gif'
	}

	def image(EnumerationLiteral element) {
		'EnumerationLiteral.gif'
	}

	def image(Package element) {
		'Package.gif'
	}

	def image(Import element) {
		'PackageImport.gif'
	}

	def image(Artifact element) {
		'Artifact.gif'
	}

	def image(AnyEvent element) {
		'AnyReceiveEvent.gif'
	}

	def image(Interaction element) {
		'Interaction.gif'
	}

	def image(Lifeline element) {
		'Lifeline.gif'
	}

	def image(Message element) {
		switch (element.messageSort) {
			case ASYNCH_SIGNAL:  'Message_asynchSignal.gif'
			case ASYNCH_CALL:    'Message_asynchCall.gif'
			case SYNCH_CALL:     'Message_synchCall.gif'
			case REPLY:          'Message_reply.gif'
			case CREATE_MESSAGE: 'Message_createMessage.gif'
			case DELETE_MESSAGE: 'Message_deleteMessage.gif'
			default: 'Message.gif'
		}
	}

	def image(Gate element) {
		'Gate.gif'
	}

	def image(MessageOccurrenceSpecification element) {
		'MessageOccurrenceSpecification.gif'
	}

	def image(ExecutionOccurrenceSpecification element) {
		'MessageOccurrenceSpecification.gif'
	}

	def image(ActionExecutionSpecification element) {
		'ActionExecutionSpecification.gif'
	}

	def image(BehaviourExecutionSpecification element) {
		'BehaviorExecutionSpecification.gif'
	}

	def image(InteractionFragment element) {
		'CombinedFragment.gif'
	}

}
