/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.xtext.extras;

import java.util.List;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ActionCodeConverterImpl
implements IValueConverter<String> {
    private static final String CODE_START = "{|#";
    private static final String CODE_END = "#|}";
    private static final String NEW_LINE = "\n";
    private static final String DEFAULT_PREFIX = ActionCodeConverterImpl.prefix("\t", 5);

    public static String prefix(String s, int level) {
        String _xblockexpression = null;
        StringBuilder prefix = new StringBuilder();
        int i = 0;
        while (i < level) {
            prefix.append(s);
            ++i;
        }
        _xblockexpression = prefix.toString();
        return _xblockexpression;
    }

    public static String removeTrailingSpaces(String s) {
        String _xblockexpression = null;
        int i = s.length();
        while (i > 0 && Character.isWhitespace(s.charAt(i - 1))) {
            --i;
        }
        _xblockexpression = s.substring(0, i);
        return _xblockexpression;
    }

    public static int firstNonSpace(String s) {
        int _xblockexpression = 0;
        int i = 0;
        while (i < s.length() && Character.isWhitespace(s.charAt(i))) {
            ++i;
        }
        _xblockexpression = i;
        return _xblockexpression;
    }

    public static int longestLeadingSpace(String text) {
        int _xblockexpression = 0;
        int i = 0;
        int longest_length = 0;
        String[] lines = text.split(NEW_LINE);
        while (i < lines.length) {
            String line = lines[i];
            int lineLeadingSpace = ActionCodeConverterImpl.firstNonSpace(line);
            if (lineLeadingSpace > 0 && lineLeadingSpace > longest_length) {
                longest_length = lineLeadingSpace;
            }
            ++i;
        }
        _xblockexpression = longest_length;
        return _xblockexpression;
    }

    public static String removeLeadingSpaces(String text) {
        String newText;
        String _xblockexpression = null;
        final int n = ActionCodeConverterImpl.longestLeadingSpace(text);
        String[] lines = text.split(NEW_LINE);
        Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

            public String apply(String it) {
                return ActionCodeConverterImpl.stringFrom(it, n);
            }
        };
        List _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)lines)), (Functions.Function1)_function);
        _xblockexpression = newText = IterableExtensions.join((Iterable)_map, (CharSequence)NEW_LINE);
        return _xblockexpression;
    }

    public static String stringFrom(String s, int n) {
        String _xifexpression = null;
        if (s == null) {
            _xifexpression = "";
        } else {
            String _xifexpression_1 = null;
            int _length = s.length();
            boolean _lessThan = _length < n;
            _xifexpression_1 = _lessThan ? s : s.substring(n);
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public String toString(String value) throws ValueConverterException {
        String _xblockexpression = null;
        String _elvis = null;
        _elvis = value != null ? value : "";
        String rawString = ActionCodeConverterImpl.removeTrailingSpaces(_elvis);
        String _xifexpression = null;
        boolean _contains = rawString.contains(NEW_LINE);
        if (_contains) {
            String _xblockexpression_1 = null;
            String[] _split = rawString.split(NEW_LINE);
            List lines = IterableExtensions.toList((Iterable)((Iterable)Conversions.doWrapArray((Object)_split)));
            final String prefix = DEFAULT_PREFIX;
            Functions.Function1<String, CharSequence> _function = new Functions.Function1<String, CharSequence>(){

                public CharSequence apply(String it) {
                    return String.valueOf(prefix) + it;
                }
            };
            _xifexpression = _xblockexpression_1 = IterableExtensions.join((Iterable)lines, (CharSequence)"{|#\n", (CharSequence)NEW_LINE, (CharSequence)(NEW_LINE + DEFAULT_PREFIX + CODE_END), (Functions.Function1)_function);
        } else {
            String _trim = rawString.trim();
            String _plus = "{|# " + _trim;
            String _plus_1 = String.valueOf(_plus) + " ";
            _xifexpression = String.valueOf(_plus_1) + CODE_END;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String toValue(String string, INode node) throws ValueConverterException {
        String _xifexpression = null;
        if (string != null) {
            boolean _endsWith;
            String _xblockexpression = null;
            int startIndex = 0;
            int endIndex = string.length();
            boolean _startsWith = string.startsWith(CODE_START);
            if (_startsWith) {
                int _length;
                startIndex = _length = CODE_START.length();
            }
            if (_endsWith = string.endsWith(CODE_END)) {
                int _minus;
                int _length_1 = string.length();
                int _length_2 = CODE_END.length();
                endIndex = _minus = _length_1 - _length_2;
            }
            String _substring = string.substring(startIndex, endIndex);
            _xifexpression = _xblockexpression = ActionCodeConverterImpl.removeLeadingSpaces(_substring);
        } else {
            _xifexpression = "";
        }
        return _xifexpression;
    }
}

