/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import org.eclipse.passage.lbc.internal.base.ServerAuthentication;
import org.eclipse.passage.lbc.internal.base.ServerAuthenticationInstructions;
import org.eclipse.passage.lbc.internal.base.api.FloatingState;
import org.eclipse.passage.lbc.internal.base.api.RawRequest;
import org.eclipse.passage.lic.api.EvaluationInstructions;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.base.io.FileNameFromLicensedProduct;
import org.eclipse.passage.lic.base.io.PassageFileExtension;
import org.eclipse.passage.lic.base.io.PathFromLicensedProduct;
import org.eclipse.passage.lic.internal.net.api.handle.NetRequest;
import org.eclipse.passage.lic.internal.net.api.handle.NetResponse;
import org.eclipse.passage.lic.internal.net.handle.ChoreDraft;
import org.eclipse.passage.lic.internal.net.handle.Failure;
import org.eclipse.passage.lic.internal.net.handle.ProductUserRequest;

abstract class AuthentifiedChoreDraft
extends ChoreDraft<RawRequest> {
    protected AuthentifiedChoreDraft(RawRequest request) {
        super((NetRequest)request);
    }

    protected Optional<NetResponse> rawInvalid() {
        return this.serverIsNotAuthenticated();
    }

    protected Optional<NetResponse> productUserInvalid(ProductUserRequest<RawRequest> refined) {
        return this.productUnknown(refined);
    }

    private Optional<NetResponse> serverIsNotAuthenticated() {
        Object instructions = new ServerAuthenticationInstructions(this.data).get();
        if (!((Optional)instructions).isPresent()) {
            return Optional.of(new Failure.BadRequestInvalidServerAuthInstructions());
        }
        try {
            new ServerAuthentication((EvaluationInstructions)((Optional)instructions).get()).evaluate();
        }
        catch (Exception e) {
            this.log.error((Object)"Failed on server authentication attempt: ", (Throwable)e);
            return Optional.of(new Failure.ForeignServer(e.getMessage()));
        }
        return Optional.empty();
    }

    private Optional<NetResponse> productUnknown(ProductUserRequest<RawRequest> refined) {
        LicensedProduct product = (LicensedProduct)refined.product().get();
        Path key = new PathFromLicensedProduct(((FloatingState)((RawRequest)this.data).state())::source, product).get().resolve(new FileNameFromLicensedProduct(product, (PassageFileExtension)new PassageFileExtension.PublicKey()).get());
        if (!Files.exists(key, new LinkOption[0])) {
            this.log.error((Object)String.format("Key file [%s] is not found", product));
            return Optional.of(new Failure.BadRequestUnkonwnProduct(product));
        }
        return Optional.empty();
    }
}

