/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base.acquire;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.passage.lbc.internal.base.DecodedRequest;
import org.eclipse.passage.lbc.internal.base.EncodedResponse;
import org.eclipse.passage.lbc.internal.base.acquire.NoGrantsAvailable;
import org.eclipse.passage.lbc.internal.base.acquire.NotReleased;
import org.eclipse.passage.lbc.internal.base.api.FloatingState;
import org.eclipse.passage.lbc.internal.base.api.Grants;
import org.eclipse.passage.lbc.internal.base.api.RawRequest;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.api.PassageAction;
import org.eclipse.passage.lic.base.FeatureIdentifier;
import org.eclipse.passage.lic.internal.net.api.handle.NetResponse;
import org.eclipse.passage.lic.internal.net.handle.Failure;
import org.eclipse.passage.lic.internal.net.handle.PlainSuceess;
import org.eclipse.passage.lic.internal.net.handle.ProductUserRequest;
import org.eclipse.passage.lic.licenses.model.api.GrantAcqisition;

public final class Acquisition {
    private final ProductUserRequest<RawRequest> data;
    private final Logger log = LogManager.getLogger(this.getClass());

    public Acquisition(ProductUserRequest<RawRequest> data) {
        Objects.requireNonNull(data, "Acquisition::data");
        this.data = data;
    }

    public NetResponse get() {
        Optional<GrantAcqisition> acquisition;
        Optional feature = new FeatureIdentifier(key -> ((RawRequest)this.data.raw()).parameter((String)key)).get();
        if (!feature.isPresent()) {
            return new Failure.BadRequestNoFeature();
        }
        try {
            acquisition = this.acquisition((String)feature.get());
        }
        catch (LicensingException e) {
            this.log.error((Object)"failed: ", (Throwable)e);
            return new Failure.OperationFailed(new PassageAction.Acquire().name(), e.getMessage());
        }
        if (!acquisition.isPresent()) {
            return this.noGrants((String)feature.get());
        }
        return this.encodedPack(acquisition.get());
    }

    private NetResponse encodedPack(GrantAcqisition acqisition) {
        return new EncodedResponse<GrantAcqisition>(acqisition, this.data).get();
    }

    public NetResponse returnBack() throws LicensingException {
        GrantAcqisition acquisition;
        try {
            acquisition = this.acquisition();
        }
        catch (IOException e) {
            throw new LicensingException((Throwable)e);
        }
        boolean released = this.grants().release((LicensedProduct)this.data.product().get(), acquisition);
        if (!released) {
            return new NotReleased((LicensedProduct)this.data.product().get(), acquisition);
        }
        return new PlainSuceess();
    }

    private Optional<GrantAcqisition> acquisition(String feature) throws LicensingException {
        return this.grants().acquire((LicensedProduct)this.data.product().get(), (String)this.data.user().get(), feature);
    }

    private GrantAcqisition acquisition() throws LicensingException, IOException {
        return (GrantAcqisition)new DecodedRequest.GrantAck((RawRequest)this.data.raw()).get();
    }

    private Grants grants() {
        return ((FloatingState)((RawRequest)this.data.raw()).state()).grants();
    }

    private Failure noGrants(String feature) {
        return new NoGrantsAvailable((LicensedProduct)this.data.product().get(), feature);
    }
}

