/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base.acquire;

import org.eclipse.passage.lbc.internal.base.acquire.DefaultGrantsStorage;
import org.eclipse.passage.lbc.internal.base.acquire.ProtectedGrantCapacity;
import org.eclipse.passage.lic.equinox.EquinoxPassage;
import org.eclipse.passage.lic.licenses.model.api.FeatureGrant;

final class FlsGrantsStorage
extends DefaultGrantsStorage {
    private final String feature = "org.eclipse.passage.lbc.acquire.concurrent";

    FlsGrantsStorage() {
    }

    @Override
    protected int capacity(FeatureGrant grant) {
        return new ProtectedGrantCapacity(grant).get();
    }

    @Override
    protected boolean beforeAcquire() {
        this.checkFlsLicense();
        return true;
    }

    @Override
    protected boolean afterAcquire() {
        return true;
    }

    @Override
    protected void beforeRelease() {
    }

    @Override
    protected void afterRelease() {
    }

    private boolean checkFlsLicense() {
        boolean canUse = new EquinoxPassage().canUse("org.eclipse.passage.lbc.acquire.concurrent");
        if (!canUse) {
            this.log.error((Object)String.format("FLS feature %s is not covered by a license", "org.eclipse.passage.lbc.acquire.concurrent"));
        }
        return canUse;
    }
}

