/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jface.dialogs.licensing;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.passage.lic.api.Framework;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.agreements.AgreementAcceptanceService;
import org.eclipse.passage.lic.api.agreements.AgreementToAccept;
import org.eclipse.passage.lic.equinox.SuppliedFrameworkAware;
import org.eclipse.passage.lic.internal.base.access.Libraries;
import org.eclipse.passage.lic.internal.equinox.access.AgreementAcceptanceDelegate;
import org.eclipse.passage.lic.internal.equinox.access.RegisteredLibraries;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.AgreementPage;
import org.eclipse.passage.lic.internal.jface.i18n.AgreementsDialogMessages;
import org.eclipse.swt.widgets.Shell;

final class AgreementsWizard
extends Wizard {
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final Collection<AgreementToAccept> agreements;
    private final Libraries libraries;

    AgreementsWizard(Collection<AgreementToAccept> agreements) {
        this.agreements = agreements;
        this.libraries = new Libraries((Supplier)new RegisteredLibraries(), this.product()::get);
        this.setWindowTitle(AgreementsDialogMessages.AgreementsWizard_description);
    }

    public void addPages() {
        this.agreements.stream().map(AgreementPage::new).forEach(arg_0 -> ((AgreementsWizard)this).addPage(arg_0));
    }

    public boolean performFinish() {
        Optional<AgreementAcceptanceService> acceptance = this.productAcceptanceService();
        if (!acceptance.isPresent()) {
            this.reportInsufficientConfiguration();
            return true;
        }
        boolean success = this.performAcceptance(acceptance.get());
        if (!success) {
            this.reportFailure();
        }
        return true;
    }

    private boolean performAcceptance(AgreementAcceptanceService root) {
        AgreementAcceptanceDelegate service = new AgreementAcceptanceDelegate(root, this.libraries);
        boolean success = true;
        for (AgreementToAccept agreement : this.agreements) {
            try {
                service.accept(agreement);
            }
            catch (Exception e) {
                success = false;
                e.printStackTrace();
                this.log.error((Object)e);
            }
        }
        return success;
    }

    private void reportInsufficientConfiguration() {
        MessageDialog.openError((Shell)this.getShell(), (String)AgreementsDialogMessages.AgreementsWizard_error, (String)AgreementsDialogMessages.AgreementsWizard_error_description);
    }

    private void reportFailure() {
        MessageDialog.openError((Shell)this.getShell(), (String)AgreementsDialogMessages.AgreementsWizard_failure, (String)AgreementsDialogMessages.AgreementsWizard_failure_description);
    }

    private Optional<AgreementAcceptanceService> productAcceptanceService() {
        return new SuppliedFrameworkAware().withFramework(framework -> framework.accessCycleConfiguration().acceptance());
    }

    private Optional<LicensedProduct> product() {
        return new SuppliedFrameworkAware().withFramework(Framework::product);
    }
}

