/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.operator.seal;

import java.io.InputStream;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.passage.lic.api.AccessCycleConfiguration;
import org.eclipse.passage.lic.api.Framework;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.base.BaseFramework;
import org.eclipse.passage.lic.base.InvalidLicensedProduct;
import org.eclipse.passage.lic.equinox.LicensedApplication;
import org.eclipse.passage.lic.equinox.io.FileFromBundle;
import org.eclipse.passage.lic.execute.FocusedAccessCycleConfiguration;
import org.eclipse.passage.lic.internal.execute.Logging;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

final class OperatorFramework
extends BaseFramework {
    static final Framework instance = new OperatorFramework();
    private final Logger log;
    private final AccessCycleConfiguration configuration;

    private OperatorFramework() {
        this.configureLogging();
        this.log = LogManager.getLogger(((Object)((Object)this)).getClass());
        this.logConfiguration();
        this.configuration = new FocusedAccessCycleConfiguration.Personal(() -> ((OperatorFramework)this).product(), () -> FrameworkUtil.getBundle(OperatorFramework.class));
    }

    public AccessCycleConfiguration accessCycleConfiguration() {
        return this.configuration;
    }

    protected final LicensedProduct productRead() {
        LicensedProduct prod;
        try {
            prod = new LicensedApplication().product();
        }
        catch (LicensingException e) {
            prod = new InvalidLicensedProduct();
        }
        return prod;
    }

    private void configureLogging() {
        new Logging(this::logConfig).configure();
    }

    private InputStream logConfig() throws Exception {
        Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        return new FileFromBundle(bundle, "config/log4j2.xml").get();
    }

    private void logConfiguration() {
        this.log.debug((Object)String.format("%s runs for %s", ((Object)((Object)this)).getClass().getName(), this.product()));
    }
}

