/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.core;

import java.io.IOException;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.passage.lic.licenses.model.api.FloatingLicensePack;
import org.eclipse.passage.lic.licenses.model.api.LicensePlan;
import org.eclipse.passage.lic.licenses.model.api.PersonalLicensePack;
import org.eclipse.passage.lic.licenses.model.meta.LicensesPackage;
import org.eclipse.passage.loc.internal.licenses.LicenseRegistry;

final class UpdateLicensePlan {
    private final LicenseRegistry licenses;
    private final Optional<IEditingDomainProvider> domain;

    UpdateLicensePlan(LicenseRegistry licenses) {
        this.licenses = licenses;
        this.domain = licenses instanceof IEditingDomainProvider ? Optional.of((IEditingDomainProvider)licenses) : Optional.empty();
    }

    void withPersonal(PersonalLicensePack license) throws IOException {
        this.updatePlan(license, lic -> lic.getLicense().getPlan(), (EStructuralFeature)LicensesPackage.eINSTANCE.getLicensePlan_Personal());
    }

    void withFloating(FloatingLicensePack license) throws IOException {
        this.updatePlan(license, lic -> lic.getLicense().getPlan(), (EStructuralFeature)LicensesPackage.eINSTANCE.getLicensePlan_Floating());
    }

    private <T extends EObject> void updatePlan(T license, Function<T, String> id, EStructuralFeature ref) throws IOException {
        LicensePlan plan = this.plan(license, id);
        if (this.domain.isPresent()) {
            this.augmentUndoable(license, ref, plan);
        } else {
            this.augmentPlain(license, ref, plan);
        }
        this.savePlanResource(plan);
    }

    private <T extends EObject> LicensePlan plan(T license, Function<T, String> id) {
        return (LicensePlan)this.licenses.getLicensePlan(id.apply(license));
    }

    private <T extends EObject> void augmentPlain(T license, EStructuralFeature ref, LicensePlan plan) {
        ((EList)plan.eGet(ref)).add(license);
    }

    private <T extends EObject> void augmentUndoable(T license, EStructuralFeature ref, LicensePlan plan) {
        EditingDomain edit = this.domain.get().getEditingDomain();
        edit.getCommandStack().execute(AddCommand.create((EditingDomain)edit, (Object)plan, (Object)ref, license));
    }

    private void savePlanResource(LicensePlan plan) throws IOException {
        plan.eResource().save(null);
    }
}

