/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.apache.bzip2;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.bouncycastle.apache.bzip2.BZip2Constants;
import org.bouncycastle.apache.bzip2.CRC;

public class CBZip2OutputStream
extends OutputStream
implements BZip2Constants {
    protected static final int SETMASK = 0x200000;
    protected static final int CLEARMASK = -2097153;
    protected static final int GREATER_ICOST = 15;
    protected static final int LESSER_ICOST = 0;
    protected static final int SMALL_THRESH = 20;
    protected static final int DEPTH_THRESH = 10;
    private boolean finished;
    int count;
    int origPtr;
    int blockSize100k;
    boolean blockRandomised;
    int bsBuff;
    int bsLive;
    CRC mCrc = new CRC();
    private boolean[] inUse = new boolean[256];
    private int nInUse;
    private char[] seqToUnseq = new char[256];
    private char[] unseqToSeq = new char[256];
    private char[] selector = new char[18002];
    private char[] selectorMtf = new char[18002];
    private byte[] blockBytes = null;
    private short[] quadrantShorts = null;
    private int[] zptr = null;
    private int[] szptr;
    private int[] ftab = null;
    private int nMTF;
    private int[] mtfFreq = new int[258];
    private int workFactor;
    private int workDone;
    private int workLimit;
    private boolean firstAttempt;
    private int currentByte = -1;
    private int runLength = 0;
    boolean closed = false;
    private int blockCRC;
    private int combinedCRC;
    private final int allowableBlockSize;
    private OutputStream bsStream;
    private int[] incs = new int[]{1, 4, 13, 40, 121, 364, 1093, 3280, 9841, 29524, 88573, 265720, 797161, 2391484};

    private static void panic() {
        throw new IllegalStateException();
    }

    private void makeMaps() {
        this.nInUse = 0;
        for (int i = 0; i < 256; ++i) {
            if (!this.inUse[i]) continue;
            this.seqToUnseq[this.nInUse] = (char)i;
            this.unseqToSeq[i] = (char)this.nInUse;
            ++this.nInUse;
        }
    }

    protected static void hbMakeCodeLengths(byte[] byArray, int[] nArray, int n, int n2) {
        int n3;
        int[] nArray2 = new int[260];
        int[] nArray3 = new int[516];
        int[] nArray4 = new int[516];
        for (n3 = 0; n3 < n; ++n3) {
            nArray3[n3 + 1] = (nArray[n3] == 0 ? 1 : nArray[n3]) << 8;
        }
        block1: while (true) {
            int n4;
            int n5;
            int n6;
            int n7 = n;
            int n8 = 0;
            nArray2[0] = 0;
            nArray3[0] = 0;
            nArray4[0] = -2;
            for (n3 = 1; n3 <= n; ++n3) {
                nArray4[n3] = -1;
                nArray2[++n8] = n3;
                n6 = n8;
                n5 = nArray2[n6];
                while (nArray3[n5] < nArray3[nArray2[n6 >> 1]]) {
                    nArray2[n6] = nArray2[n6 >> 1];
                    n6 >>= 1;
                }
                nArray2[n6] = n5;
            }
            if (n8 >= 260) {
                CBZip2OutputStream.panic();
            }
            while (n8 > 1) {
                int n9 = nArray2[1];
                nArray2[1] = nArray2[n8];
                --n8;
                n6 = 0;
                n5 = 0;
                int n10 = 0;
                n6 = 1;
                n10 = nArray2[n6];
                while ((n5 = n6 << 1) <= n8) {
                    if (n5 < n8 && nArray3[nArray2[n5 + 1]] < nArray3[nArray2[n5]]) {
                        ++n5;
                    }
                    if (nArray3[n10] < nArray3[nArray2[n5]]) break;
                    nArray2[n6] = nArray2[n5];
                    n6 = n5;
                }
                nArray2[n6] = n10;
                int n11 = nArray2[1];
                nArray2[1] = nArray2[n8];
                --n8;
                n6 = 0;
                n5 = 0;
                n10 = 0;
                n6 = 1;
                n10 = nArray2[n6];
                while ((n5 = n6 << 1) <= n8) {
                    if (n5 < n8 && nArray3[nArray2[n5 + 1]] < nArray3[nArray2[n5]]) {
                        ++n5;
                    }
                    if (nArray3[n10] < nArray3[nArray2[n5]]) break;
                    nArray2[n6] = nArray2[n5];
                    n6 = n5;
                }
                nArray2[n6] = n10;
                nArray4[n9] = nArray4[n11] = ++n7;
                nArray3[n7] = (nArray3[n9] & 0xFFFFFF00) + (nArray3[n11] & 0xFFFFFF00) | 1 + ((nArray3[n9] & 0xFF) > (nArray3[n11] & 0xFF) ? nArray3[n9] & 0xFF : nArray3[n11] & 0xFF);
                nArray4[n7] = -1;
                nArray2[++n8] = n7;
                n6 = 0;
                n5 = 0;
                n6 = n8;
                n5 = nArray2[n6];
                while (nArray3[n5] < nArray3[nArray2[n6 >> 1]]) {
                    nArray2[n6] = nArray2[n6 >> 1];
                    n6 >>= 1;
                }
                nArray2[n6] = n5;
            }
            if (n7 >= 516) {
                CBZip2OutputStream.panic();
            }
            boolean bl = false;
            for (n3 = 1; n3 <= n; ++n3) {
                n4 = 0;
                int n12 = n3;
                while (nArray4[n12] >= 0) {
                    n12 = nArray4[n12];
                    ++n4;
                }
                byArray[n3 - 1] = (byte)n4;
                if (n4 <= n2) continue;
                bl = true;
            }
            if (!bl) break;
            n3 = 1;
            while (true) {
                if (n3 >= n) continue block1;
                n4 = nArray3[n3] >> 8;
                n4 = 1 + n4 / 2;
                nArray3[n3] = n4 << 8;
                ++n3;
            }
            break;
        }
    }

    public CBZip2OutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, 9);
    }

    public CBZip2OutputStream(OutputStream outputStream, int n) throws IOException {
        outputStream.write(66);
        outputStream.write(90);
        this.bsSetStream(outputStream);
        this.workFactor = 50;
        if (n > 9) {
            n = 9;
        }
        if (n < 1) {
            n = 1;
        }
        this.blockSize100k = n;
        this.allowableBlockSize = 100000 * this.blockSize100k - 20;
        this.allocateCompressStructures();
        this.initialize();
        this.initBlock();
    }

    public void write(int n) throws IOException {
        int n2 = n & 0xFF;
        if (this.currentByte == n2) {
            ++this.runLength;
            if (this.runLength > 254) {
                this.writeRun();
                this.currentByte = -1;
                this.runLength = 0;
            }
        } else if (this.currentByte == -1) {
            this.currentByte = n2;
            ++this.runLength;
        } else {
            this.writeRun();
            this.runLength = 1;
            this.currentByte = n2;
        }
    }

    private void writeRun() throws IOException {
        if (this.count > this.allowableBlockSize) {
            this.endBlock();
            this.initBlock();
        }
        this.inUse[this.currentByte] = true;
        for (int i = 0; i < this.runLength; ++i) {
            this.mCrc.updateCRC(this.currentByte);
        }
        switch (this.runLength) {
            case 1: {
                this.blockBytes[++this.count] = (byte)this.currentByte;
                break;
            }
            case 2: {
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)this.currentByte;
                break;
            }
            case 3: {
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)this.currentByte;
                break;
            }
            default: {
                this.inUse[this.runLength - 4] = true;
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)(this.runLength - 4);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.finish();
        this.closed = true;
        super.close();
        this.bsStream.close();
    }

    public void finish() throws IOException {
        if (this.finished) {
            return;
        }
        if (this.runLength > 0) {
            this.writeRun();
        }
        this.currentByte = -1;
        if (this.count > 0) {
            this.endBlock();
        }
        this.endCompression();
        this.finished = true;
        this.flush();
    }

    public void flush() throws IOException {
        super.flush();
        this.bsStream.flush();
    }

    private void initialize() throws IOException {
        this.bsPutUChar(104);
        this.bsPutUChar(48 + this.blockSize100k);
        this.combinedCRC = 0;
    }

    private void initBlock() {
        this.mCrc.initialiseCRC();
        this.count = 0;
        for (int i = 0; i < 256; ++i) {
            this.inUse[i] = false;
        }
    }

    private void endBlock() throws IOException {
        this.blockCRC = this.mCrc.getFinalCRC();
        this.combinedCRC = this.combinedCRC << 1 | this.combinedCRC >>> 31;
        this.combinedCRC ^= this.blockCRC;
        this.doReversibleTransformation();
        this.bsPutUChar(49);
        this.bsPutUChar(65);
        this.bsPutUChar(89);
        this.bsPutUChar(38);
        this.bsPutUChar(83);
        this.bsPutUChar(89);
        this.bsPutint(this.blockCRC);
        this.bsW(1, this.blockRandomised ? 1 : 0);
        this.moveToFrontCodeAndSend();
    }

    private void endCompression() throws IOException {
        this.bsPutUChar(23);
        this.bsPutUChar(114);
        this.bsPutUChar(69);
        this.bsPutUChar(56);
        this.bsPutUChar(80);
        this.bsPutUChar(144);
        this.bsPutint(this.combinedCRC);
        this.bsFinishedWithStream();
    }

    private void hbAssignCodes(int[] nArray, byte[] byArray, int n, int n2, int n3) {
        int n4 = 0;
        for (int i = n; i <= n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                if ((byArray[j] & 0xFF) != i) continue;
                nArray[j] = n4++;
            }
            n4 <<= 1;
        }
    }

    private void bsSetStream(OutputStream outputStream) {
        this.bsStream = outputStream;
        this.bsLive = 0;
        this.bsBuff = 0;
    }

    private void bsFinishedWithStream() throws IOException {
        while (this.bsLive > 0) {
            this.bsStream.write(this.bsBuff >> 24);
            this.bsBuff <<= 8;
            this.bsLive -= 8;
        }
    }

    private void bsW(int n, int n2) throws IOException {
        while (this.bsLive >= 8) {
            this.bsStream.write(this.bsBuff >> 24);
            this.bsBuff <<= 8;
            this.bsLive -= 8;
        }
        this.bsBuff |= n2 << 32 - this.bsLive - n;
        this.bsLive += n;
    }

    private void bsPutUChar(int n) throws IOException {
        this.bsW(8, n);
    }

    private void bsPutint(int n) throws IOException {
        this.bsW(8, n >> 24 & 0xFF);
        this.bsW(8, n >> 16 & 0xFF);
        this.bsW(8, n >> 8 & 0xFF);
        this.bsW(8, n & 0xFF);
    }

    private void bsPutIntVS(int n, int n2) throws IOException {
        this.bsW(n, n2);
    }

    private void sendMTFValues() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        short s;
        Object object;
        byte[] byArray;
        int n6;
        int n7;
        int n8;
        byte[][] byArray2 = new byte[6][258];
        int n9 = 0;
        int n10 = this.nInUse + 2;
        for (n8 = 0; n8 < 6; ++n8) {
            byte[] byArray3 = byArray2[n8];
            for (n7 = 0; n7 < n10; ++n7) {
                byArray3[n7] = 15;
            }
        }
        if (this.nMTF <= 0) {
            CBZip2OutputStream.panic();
        }
        int n11 = this.nMTF < 200 ? 2 : (this.nMTF < 600 ? 3 : (this.nMTF < 1200 ? 4 : (this.nMTF < 2400 ? 5 : 6)));
        int n12 = n11;
        int n13 = this.nMTF;
        int n14 = 0;
        while (n12 > 0) {
            int n15;
            int n16 = n13 / n12;
            n6 = n14 - 1;
            for (n15 = 0; n15 < n16 && n6 < n10 - 1; n15 += this.mtfFreq[++n6]) {
            }
            if (n6 > n14 && n12 != n11 && n12 != 1 && (n11 - n12) % 2 == 1) {
                n15 -= this.mtfFreq[n6];
                --n6;
            }
            byArray = byArray2[n12 - 1];
            for (n7 = 0; n7 < n10; ++n7) {
                byArray[n7] = n7 >= n14 && n7 <= n6 ? 0 : 15;
            }
            --n12;
            n14 = n6 + 1;
            n13 -= n15;
        }
        int[][] nArray = new int[6][258];
        int[] nArray2 = new int[6];
        short[] sArray = new short[6];
        byte[] byArray4 = byArray2[0];
        byArray = byArray2[1];
        byte[] byArray5 = byArray2[2];
        byte[] byArray6 = byArray2[3];
        byte[] byArray7 = byArray2[4];
        byte[] byArray8 = byArray2[5];
        for (int i = 0; i < 4; ++i) {
            for (n8 = 0; n8 < n11; ++n8) {
                nArray2[n8] = 0;
                object = nArray[n8];
                for (n7 = 0; n7 < n10; ++n7) {
                    object[n7] = 0;
                }
            }
            n9 = 0;
            n14 = 0;
            while (n14 < this.nMTF) {
                n6 = Math.min(n14 + 50 - 1, this.nMTF - 1);
                if (n11 == 6) {
                    short s2 = 0;
                    s = 0;
                    n5 = 0;
                    n4 = 0;
                    n3 = 0;
                    short s3 = 0;
                    for (n2 = n14; n2 <= n6; ++n2) {
                        int n17 = this.szptr[n2];
                        s2 = (short)(s2 + (byArray4[n17] & 0xFF));
                        s = (short)(s + (byArray[n17] & 0xFF));
                        n5 = (short)(n5 + (byArray5[n17] & 0xFF));
                        n4 = (short)(n4 + (byArray6[n17] & 0xFF));
                        n3 = (short)(n3 + (byArray7[n17] & 0xFF));
                        s3 = (short)(s3 + (byArray8[n17] & 0xFF));
                    }
                    sArray[0] = s2;
                    sArray[1] = s;
                    sArray[2] = n5;
                    sArray[3] = n4;
                    sArray[4] = n3;
                    sArray[5] = s3;
                } else {
                    for (n8 = 0; n8 < n11; ++n8) {
                        sArray[n8] = 0;
                    }
                    for (n2 = n14; n2 <= n6; ++n2) {
                        int n18 = this.szptr[n2];
                        for (n8 = 0; n8 < n11; ++n8) {
                            int n15 = n8;
                            sArray[n15] = (short)(sArray[n15] + (byArray2[n8][n18] & 0xFF));
                        }
                    }
                }
                short s4 = 999999999;
                int n20 = -1;
                for (n8 = 0; n8 < n11; ++n8) {
                    if (sArray[n8] >= s4) continue;
                    s4 = sArray[n8];
                    n20 = n8;
                }
                int n16 = n20;
                nArray2[n16] = nArray2[n16] + 1;
                this.selector[n9] = (char)n20;
                ++n9;
                object = nArray[n20];
                for (n2 = n14; n2 <= n6; ++n2) {
                    int n17 = this.szptr[n2];
                    object[n17] = object[n17] + 1;
                }
                n14 = n6 + 1;
            }
            for (n8 = 0; n8 < n11; ++n8) {
                CBZip2OutputStream.hbMakeCodeLengths(byArray2[n8], nArray[n8], n10, 20);
            }
        }
        nArray = null;
        nArray2 = null;
        sArray = null;
        if (n11 >= 8) {
            CBZip2OutputStream.panic();
        }
        if (n9 >= 32768 || n9 > 18002) {
            CBZip2OutputStream.panic();
        }
        object = new char[6];
        for (n2 = 0; n2 < n11; ++n2) {
            object[n2] = (char)n2;
        }
        for (n2 = 0; n2 < n9; ++n2) {
            s = this.selector[n2];
            n = 0;
            n4 = object[n];
            while (s != n4) {
                n5 = n4;
                n4 = object[++n];
                object[n] = n5;
            }
            object[0] = n4;
            this.selectorMtf[n2] = (char)n;
        }
        object = new int[6][258];
        for (n8 = 0; n8 < n11; ++n8) {
            int n23 = 32;
            int n24 = 0;
            byte[] byArray9 = byArray2[n8];
            for (n2 = 0; n2 < n10; ++n2) {
                n5 = byArray9[n2] & 0xFF;
                if (n5 > n24) {
                    n24 = n5;
                }
                if (n5 >= n23) continue;
                n23 = n5;
            }
            if (n24 > 20) {
                CBZip2OutputStream.panic();
            }
            if (n23 < 1) {
                CBZip2OutputStream.panic();
            }
            this.hbAssignCodes((int[])object[n8], byArray2[n8], n23, n24, n10);
        }
        boolean[] blArray = new boolean[16];
        block21: for (n2 = 0; n2 < 16; ++n2) {
            blArray[n2] = false;
            n5 = n2 * 16;
            for (n = 0; n < 16; ++n) {
                if (!this.inUse[n5 + n]) continue;
                blArray[n2] = true;
                continue block21;
            }
        }
        for (n2 = 0; n2 < 16; ++n2) {
            this.bsW(1, blArray[n2] ? 1 : 0);
        }
        for (n2 = 0; n2 < 16; ++n2) {
            if (!blArray[n2]) continue;
            n5 = n2 * 16;
            for (n = 0; n < 16; ++n) {
                this.bsW(1, this.inUse[n5 + n] ? 1 : 0);
            }
        }
        this.bsW(3, n11);
        this.bsW(15, n9);
        for (n2 = 0; n2 < n9; ++n2) {
            int n25;
            for (n25 = this.selectorMtf[n2]; n25 >= 24; n25 -= 24) {
                this.bsW(24, 0xFFFFFF);
            }
            this.bsW(n25 + '\u0001', (1 << n25 + 1) - 2);
        }
        for (n8 = 0; n8 < n11; ++n8) {
            byte[] byArray10 = byArray2[n8];
            n5 = byArray10[0] & 0xFF;
            this.bsW(5, n5);
            for (n2 = 0; n2 < n10; ++n2) {
                n4 = byArray10[n2] & 0xFF;
                while (n5 < n4) {
                    this.bsW(2, 2);
                    ++n5;
                }
                while (n5 > n4) {
                    this.bsW(2, 3);
                    --n5;
                }
                this.bsW(1, 0);
            }
        }
        int n26 = 0;
        n14 = 0;
        while (n14 < this.nMTF) {
            n6 = Math.min(n14 + 50 - 1, this.nMTF - 1);
            char c = this.selector[n26];
            byte[] byArray11 = byArray2[c];
            int n27 = object[c];
            for (n2 = n14; n2 <= n6; ++n2) {
                n3 = this.szptr[n2];
                this.bsW(byArray11[n3] & 0xFF, (int)n27[n3]);
            }
            n14 = n6 + 1;
            ++n26;
        }
        if (n26 != n9) {
            CBZip2OutputStream.panic();
        }
    }

    private void moveToFrontCodeAndSend() throws IOException {
        this.bsPutIntVS(24, this.origPtr);
        this.generateMTFValues();
        this.sendMTFValues();
    }

    private void simpleSort(int n, int n2, int n3) {
        int n4 = n2 - n + 1;
        if (n4 < 2) {
            return;
        }
        int n5 = 0;
        while (this.incs[n5] < n4) {
            ++n5;
        }
        --n5;
        while (n5 >= 0) {
            int n6 = this.incs[n5];
            for (int i = n + n6; i <= n2; ++i) {
                int n7 = this.zptr[i];
                int n8 = i;
                while (this.fullGtU(this.zptr[n8 - n6] + n3, n7 + n3)) {
                    this.zptr[n8] = this.zptr[n8 - n6];
                    if ((n8 -= n6) > n + n6 - 1) continue;
                }
                this.zptr[n8] = n7;
                if (++i > n2) break;
                n7 = this.zptr[i];
                n8 = i;
                while (this.fullGtU(this.zptr[n8 - n6] + n3, n7 + n3)) {
                    this.zptr[n8] = this.zptr[n8 - n6];
                    if ((n8 -= n6) > n + n6 - 1) continue;
                }
                this.zptr[n8] = n7;
                if (++i > n2) break;
                n7 = this.zptr[i];
                n8 = i;
                while (this.fullGtU(this.zptr[n8 - n6] + n3, n7 + n3)) {
                    this.zptr[n8] = this.zptr[n8 - n6];
                    if ((n8 -= n6) > n + n6 - 1) continue;
                }
                this.zptr[n8] = n7;
                if (this.workDone <= this.workLimit || !this.firstAttempt) continue;
                return;
            }
            --n5;
        }
    }

    private void vswap(int n, int n2, int n3) {
        while (--n3 >= 0) {
            int n4 = this.zptr[n];
            int n5 = this.zptr[n2];
            this.zptr[n++] = n5;
            this.zptr[n2++] = n4;
        }
    }

    private int med3(int n, int n2, int n3) {
        return n > n2 ? (n3 < n2 ? n2 : (n3 > n ? n : n3)) : (n3 < n ? n : (n3 > n2 ? n2 : n3));
    }

    private static void pushStackElem(Vector vector, int n, int n2, int n3, int n4) {
        StackElem stackElem;
        if (n < vector.size()) {
            stackElem = (StackElem)vector.elementAt(n);
        } else {
            stackElem = new StackElem();
            vector.addElement(stackElem);
        }
        stackElem.ll = n2;
        stackElem.hh = n3;
        stackElem.dd = n4;
    }

    private void qSort3(int n, int n2, int n3) {
        Vector vector = new Vector();
        int n4 = 0;
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        while (true) {
            int n8;
            int n9;
            int n10;
            if (n6 - n5 < 20 || n7 > 10) {
                this.simpleSort(n5, n6, n7);
                if (n4 < 1 || this.workDone > this.workLimit && this.firstAttempt) {
                    return;
                }
                StackElem stackElem = (StackElem)vector.elementAt(--n4);
                n5 = stackElem.ll;
                n6 = stackElem.hh;
                n7 = stackElem.dd;
                continue;
            }
            int n11 = n7 + 1;
            int n12 = this.med3(this.blockBytes[this.zptr[n5] + n11] & 0xFF, this.blockBytes[this.zptr[n6] + n11] & 0xFF, this.blockBytes[this.zptr[n5 + n6 >>> 1] + n11] & 0xFF);
            int n13 = n10 = n5;
            int n14 = n9 = n6;
            while (true) {
                int n15;
                if (n13 <= n14 && (n8 = (this.blockBytes[(n15 = this.zptr[n13]) + n11] & 0xFF) - n12) <= 0) {
                    if (n8 == 0) {
                        this.zptr[n13] = this.zptr[n10];
                        this.zptr[n10++] = n15;
                    }
                    ++n13;
                    continue;
                }
                while (n13 <= n14 && (n8 = (this.blockBytes[(n15 = this.zptr[n14]) + n11] & 0xFF) - n12) >= 0) {
                    if (n8 == 0) {
                        this.zptr[n14] = this.zptr[n9];
                        this.zptr[n9--] = n15;
                    }
                    --n14;
                }
                if (n13 > n14) break;
                n15 = this.zptr[n13];
                this.zptr[n13++] = this.zptr[n14];
                this.zptr[n14--] = n15;
            }
            if (n9 < n10) {
                n7 = n11;
                continue;
            }
            n8 = Math.min(n10 - n5, n13 - n10);
            this.vswap(n5, n13 - n8, n8);
            int n16 = Math.min(n6 - n9, n9 - n14);
            this.vswap(n13, n6 - n16 + 1, n16);
            n8 = n5 + (n13 - n10);
            n16 = n6 - (n9 - n14);
            CBZip2OutputStream.pushStackElem(vector, n4++, n5, n8 - 1, n7);
            CBZip2OutputStream.pushStackElem(vector, n4++, n8, n16, n11);
            n5 = n16 + 1;
        }
    }

    private void mainSort() {
        int n;
        int[] nArray = new int[256];
        int[] nArray2 = new int[256];
        boolean[] blArray = new boolean[256];
        for (n = 0; n < 20; ++n) {
            this.blockBytes[this.count + n + 1] = this.blockBytes[n % this.count + 1];
        }
        for (n = 0; n <= this.count + 20; ++n) {
            this.quadrantShorts[n] = 0;
        }
        this.blockBytes[0] = this.blockBytes[this.count];
        if (this.count <= 4000) {
            for (n = 0; n < this.count; ++n) {
                this.zptr[n] = n;
            }
            this.firstAttempt = false;
            this.workLimit = 0;
            this.workDone = 0;
            this.simpleSort(0, this.count - 1, 0);
        } else {
            int n2;
            int n3;
            int n4;
            for (n = 0; n <= 255; ++n) {
                blArray[n] = false;
            }
            for (n = 0; n <= 65536; ++n) {
                this.ftab[n] = 0;
            }
            int n5 = this.blockBytes[0] & 0xFF;
            for (n = 0; n < this.count; ++n) {
                n4 = this.blockBytes[n + 1] & 0xFF;
                int n6 = (n5 << 8) + n4;
                this.ftab[n6] = this.ftab[n6] + 1;
                n5 = n4;
            }
            for (n = 1; n <= 65536; ++n) {
                int n7 = n;
                this.ftab[n7] = this.ftab[n7] + this.ftab[n - 1];
            }
            n5 = this.blockBytes[1] & 0xFF;
            n = 0;
            while (n < this.count - 1) {
                n4 = this.blockBytes[n + 2] & 0xFF;
                n3 = (n5 << 8) + n4;
                n5 = n4;
                int n8 = n3;
                this.ftab[n8] = this.ftab[n8] - 1;
                this.zptr[this.ftab[n3]] = n++;
            }
            int n9 = n3 = ((this.blockBytes[this.count] & 0xFF) << 8) + (this.blockBytes[1] & 0xFF);
            this.ftab[n9] = this.ftab[n9] - 1;
            this.zptr[this.ftab[n3]] = this.count - 1;
            for (n = 0; n <= 255; ++n) {
                nArray[n] = n;
            }
            int n10 = 1;
            while ((n10 = 3 * n10 + 1) <= 256) {
            }
            do {
                for (n = n10 /= 3; n <= 255; ++n) {
                    n2 = nArray[n];
                    n3 = n;
                    while (this.ftab[nArray[n3 - n10] + 1 << 8] - this.ftab[nArray[n3 - n10] << 8] > this.ftab[n2 + 1 << 8] - this.ftab[n2 << 8]) {
                        nArray[n3] = nArray[n3 - n10];
                        if ((n3 -= n10) > n10 - 1) continue;
                    }
                    nArray[n3] = n2;
                }
            } while (n10 != 1);
            for (n = 0; n <= 255; ++n) {
                int n11 = nArray[n];
                for (n3 = 0; n3 <= 255; ++n3) {
                    int n12 = (n11 << 8) + n3;
                    if ((this.ftab[n12] & 0x200000) == 0x200000) continue;
                    n10 = (this.ftab[n12 + 1] & 0xFFDFFFFF) - 1;
                    n2 = this.ftab[n12] & 0xFFDFFFFF;
                    if (n10 > n2) {
                        this.qSort3(n2, n10, 2);
                        if (this.workDone > this.workLimit && this.firstAttempt) {
                            return;
                        }
                    }
                    int n13 = n12;
                    this.ftab[n13] = this.ftab[n13] | 0x200000;
                }
                blArray[n11] = true;
                if (n < 255) {
                    n2 = this.ftab[n11 << 8] & 0xFFDFFFFF;
                    n10 = (this.ftab[n11 + 1 << 8] & 0xFFDFFFFF) - n2;
                    int n14 = 0;
                    while (n10 >> n14 > 65534) {
                        ++n14;
                    }
                    for (n3 = 0; n3 < n10; ++n3) {
                        short s;
                        int n15 = this.zptr[n2 + n3] + 1;
                        this.quadrantShorts[n15] = s = (short)(n3 >> n14);
                        if (n15 > 20) continue;
                        this.quadrantShorts[n15 + this.count] = s;
                    }
                    if (n10 - 1 >> n14 > 65535) {
                        CBZip2OutputStream.panic();
                    }
                }
                for (n3 = 0; n3 <= 255; ++n3) {
                    nArray2[n3] = this.ftab[(n3 << 8) + n11] & 0xFFDFFFFF;
                }
                for (n3 = this.ftab[n11 << 8] & 0xFFDFFFFF; n3 < (this.ftab[n11 + 1 << 8] & 0xFFDFFFFF); ++n3) {
                    n5 = this.blockBytes[this.zptr[n3]] & 0xFF;
                    if (blArray[n5]) continue;
                    this.zptr[nArray2[n5]] = (this.zptr[n3] == 0 ? this.count : this.zptr[n3]) - 1;
                    int n16 = n5;
                    nArray2[n16] = nArray2[n16] + 1;
                }
                for (n3 = 0; n3 <= 255; ++n3) {
                    int n17 = (n3 << 8) + n11;
                    this.ftab[n17] = this.ftab[n17] | 0x200000;
                }
            }
        }
    }

    private void randomiseBlock() {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < 256; ++n) {
            this.inUse[n] = false;
        }
        for (n = 0; n < this.count; ++n) {
            if (n2 == 0) {
                n2 = (char)rNums[n3];
                if (++n3 == 512) {
                    n3 = 0;
                }
            }
            int n4 = n + 1;
            this.blockBytes[n4] = (byte)(this.blockBytes[n4] ^ (--n2 == 1 ? (byte)1 : 0));
            this.inUse[this.blockBytes[n + 1] & 0xFF] = true;
        }
    }

    private void doReversibleTransformation() {
        this.workLimit = this.workFactor * (this.count - 1);
        this.workDone = 0;
        this.blockRandomised = false;
        this.firstAttempt = true;
        this.mainSort();
        if (this.workDone > this.workLimit && this.firstAttempt) {
            this.randomiseBlock();
            this.workDone = 0;
            this.workLimit = 0;
            this.blockRandomised = true;
            this.firstAttempt = false;
            this.mainSort();
        }
        this.origPtr = -1;
        for (int i = 0; i < this.count; ++i) {
            if (this.zptr[i] != 0) continue;
            this.origPtr = i;
            break;
        }
        if (this.origPtr == -1) {
            CBZip2OutputStream.panic();
        }
    }

    private boolean fullGtU(int n, int n2) {
        int n3;
        int n4;
        if ((n4 = this.blockBytes[++n] & 0xFF) != (n3 = this.blockBytes[++n2] & 0xFF)) {
            return n4 > n3;
        }
        if ((n4 = this.blockBytes[++n] & 0xFF) != (n3 = this.blockBytes[++n2] & 0xFF)) {
            return n4 > n3;
        }
        if ((n4 = this.blockBytes[++n] & 0xFF) != (n3 = this.blockBytes[++n2] & 0xFF)) {
            return n4 > n3;
        }
        if ((n4 = this.blockBytes[++n] & 0xFF) != (n3 = this.blockBytes[++n2] & 0xFF)) {
            return n4 > n3;
        }
        if ((n4 = this.blockBytes[++n] & 0xFF) != (n3 = this.blockBytes[++n2] & 0xFF)) {
            return n4 > n3;
        }
        if ((n4 = this.blockBytes[++n] & 0xFF) != (n3 = this.blockBytes[++n2] & 0xFF)) {
            return n4 > n3;
        }
        int n5 = this.count;
        do {
            if ((n4 = this.blockBytes[++n] & 0xFF) != (n3 = this.blockBytes[++n2] & 0xFF)) {
                return n4 > n3;
            }
            int n6 = this.quadrantShorts[n] & 0xFFFF;
            int n7 = this.quadrantShorts[n2] & 0xFFFF;
            if (n6 != n7) {
                return n6 > n7;
            }
            if ((n4 = this.blockBytes[++n] & 0xFF) != (n3 = this.blockBytes[++n2] & 0xFF)) {
                return n4 > n3;
            }
            n6 = this.quadrantShorts[n] & 0xFFFF;
            n7 = this.quadrantShorts[n2] & 0xFFFF;
            if (n6 != n7) {
                return n6 > n7;
            }
            if ((n4 = this.blockBytes[++n] & 0xFF) != (n3 = this.blockBytes[++n2] & 0xFF)) {
                return n4 > n3;
            }
            n6 = this.quadrantShorts[n] & 0xFFFF;
            n7 = this.quadrantShorts[n2] & 0xFFFF;
            if (n6 != n7) {
                return n6 > n7;
            }
            if ((n4 = this.blockBytes[++n] & 0xFF) != (n3 = this.blockBytes[++n2] & 0xFF)) {
                return n4 > n3;
            }
            n6 = this.quadrantShorts[n] & 0xFFFF;
            n7 = this.quadrantShorts[n2] & 0xFFFF;
            if (n6 != n7) {
                return n6 > n7;
            }
            if (n >= this.count) {
                n -= this.count;
            }
            if (n2 >= this.count) {
                n2 -= this.count;
            }
            ++this.workDone;
        } while ((n5 -= 4) >= 0);
        return false;
    }

    private void allocateCompressStructures() {
        int n = 100000 * this.blockSize100k;
        this.blockBytes = new byte[n + 1 + 20];
        this.quadrantShorts = new short[n + 1 + 20];
        this.zptr = new int[n];
        this.ftab = new int[65537];
        this.szptr = this.zptr;
    }

    private void generateMTFValues() {
        int n;
        char[] cArray = new char[256];
        this.makeMaps();
        int n2 = this.nInUse + 1;
        for (n = 0; n <= n2; ++n) {
            this.mtfFreq[n] = 0;
        }
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < this.nInUse; ++n) {
            cArray[n] = (char)n;
        }
        for (n = 0; n < this.count; ++n) {
            char c = this.unseqToSeq[this.blockBytes[this.zptr[n]] & 0xFF];
            int n5 = 0;
            char c2 = cArray[n5];
            while (c != c2) {
                char c3 = c2;
                c2 = cArray[++n5];
                cArray[n5] = c3;
            }
            cArray[0] = c2;
            if (n5 == 0) {
                ++n4;
                continue;
            }
            if (n4 > 0) {
                --n4;
                while (true) {
                    switch (n4 % 2) {
                        case 0: {
                            this.szptr[n3++] = 0;
                            this.mtfFreq[0] = this.mtfFreq[0] + 1;
                            break;
                        }
                        case 1: {
                            this.szptr[n3++] = 1;
                            this.mtfFreq[1] = this.mtfFreq[1] + 1;
                        }
                    }
                    if (n4 < 2) break;
                    n4 = (n4 - 2) / 2;
                }
                n4 = 0;
            }
            this.szptr[n3++] = n5 + 1;
            int n6 = n5 + 1;
            this.mtfFreq[n6] = this.mtfFreq[n6] + 1;
        }
        if (n4 > 0) {
            --n4;
            while (true) {
                switch (n4 % 2) {
                    case 0: {
                        this.szptr[n3++] = 0;
                        this.mtfFreq[0] = this.mtfFreq[0] + 1;
                        break;
                    }
                    case 1: {
                        this.szptr[n3++] = 1;
                        this.mtfFreq[1] = this.mtfFreq[1] + 1;
                    }
                }
                if (n4 < 2) break;
                n4 = (n4 - 2) / 2;
            }
        }
        this.szptr[n3++] = n2;
        int n7 = n2;
        this.mtfFreq[n7] = this.mtfFreq[n7] + 1;
        this.nMTF = n3;
    }

    private static class StackElem {
        int ll;
        int hh;
        int dd;

        private StackElem() {
        }
    }
}

