/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.requirements;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.registry.StringServiceId;
import org.eclipse.passage.lic.api.requirements.Requirement;
import org.eclipse.passage.lic.api.requirements.ResolvedRequirements;
import org.eclipse.passage.lic.base.BaseServiceInvocationResult;

public final class FilteredRequirements
implements ResolvedRequirements {
    private final ResolvedRequirements delegate;
    private final Predicate<Requirement> condition;

    public FilteredRequirements(ResolvedRequirements delegate, Predicate<Requirement> condition) {
        Objects.requireNonNull(delegate, "FilteredRequirements::delegate");
        Objects.requireNonNull(condition, "FilteredRequirements::condition");
        this.delegate = delegate;
        this.condition = condition;
    }

    public StringServiceId id() {
        return new StringServiceId("filtered-" + ((StringServiceId)this.delegate.id()).toString());
    }

    public ServiceInvocationResult<Collection<Requirement>> all() {
        ServiceInvocationResult all = this.delegate.all();
        Optional<Collection> some = all.data().map(this::filtered);
        return new BaseServiceInvocationResult<Collection<Requirement>>(all.diagnostic(), some);
    }

    private Collection<Requirement> filtered(Collection<Requirement> all) {
        return all.stream().filter(this.condition).collect(Collectors.toList());
    }
}

