/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.io;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.base.io.PassageFileExtension;
import org.eclipse.passage.lic.internal.base.i18n.BaseMessages;

public final class FileCollection {
    private final Supplier<Path> base;
    private final PassageFileExtension extensions;

    public FileCollection(Supplier<Path> base, PassageFileExtension extension) {
        Objects.requireNonNull(base, "FileCollection::base path");
        Objects.requireNonNull(extension, "FileCollection::extension");
        this.base = base;
        this.extensions = extension;
    }

    public Collection<Path> get() throws LicensingException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Stream<Path> all = this.filesIn(this.base.get());){
                return this.filtered(all);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new LicensingException(BaseMessages.getString("FileCollection.failure"), (Throwable)e);
        }
    }

    private Stream<Path> filesIn(Path path2) throws IOException {
        return Files.walk(path2, new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0]));
    }

    private List<Path> filtered(Stream<Path> files) {
        return files.filter(this.extensions::ends).collect(Collectors.toList());
    }
}

