/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.base.io.PassageFileExtension;
import org.eclipse.passage.lic.internal.base.i18n.BaseMessages;

public final class Settings {
    private final Supplier<Path> base;
    private final Predicate<Map<String, Object>> enough;

    public Settings(Supplier<Path> base, Predicate<Map<String, Object>> enough) {
        this.base = base;
        this.enough = enough;
    }

    public Settings(Supplier<Path> base) {
        this(base, map -> false);
    }

    public Map<String, Object> get() throws LicensingException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Stream<Path> files = this.settingFilesIn(this.base.get());){
                return this.properties(files);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new LicensingException(String.format(BaseMessages.getString("Settings.error_on_reading_settings"), this.base.get()), (Throwable)e);
        }
    }

    private Stream<Path> settingFilesIn(Path path2) throws IOException {
        return Files.walk(path2, new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(new PassageFileExtension.Settings()::ends);
    }

    private Map<String, Object> properties(Stream<Path> files) throws IOException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (Path file : files::iterator) {
            this.loadAndAdd(properties, file);
            if (!this.enough.test(properties)) continue;
            return properties;
        }
        return properties;
    }

    private void loadAndAdd(Map<String, Object> properties, Path file) throws IOException {
        Properties heap = new Properties();
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
            heap.load(stream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        heap.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            Object object = properties.put(k.toString(), v);
        }));
    }
}

