/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.equinox.requirements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.passage.lic.api.requirements.Requirement;
import org.eclipse.passage.lic.base.NamedData;
import org.eclipse.passage.lic.base.StringNamedData;
import org.eclipse.passage.lic.equinox.requirements.CapabilityLicFeatureAgreements;
import org.eclipse.passage.lic.equinox.requirements.CapabilityLicFeatureId;
import org.eclipse.passage.lic.equinox.requirements.CapabilityLicFeatureLevel;
import org.eclipse.passage.lic.equinox.requirements.CapabilityLicFeatureName;
import org.eclipse.passage.lic.equinox.requirements.CapabilityLicFeatureProvider;
import org.eclipse.passage.lic.equinox.requirements.CapabilityLicFeatureVersion;
import org.eclipse.passage.lic.equinox.requirements.LicCapabilityNamespace;

public final class RequirementToCapability
implements NamedData<Requirement> {
    private final Requirement requirement;

    public RequirementToCapability(Requirement requirement) {
        Objects.requireNonNull(requirement);
        this.requirement = requirement;
    }

    public Optional<Requirement> get() {
        return Optional.of(this.requirement);
    }

    public String key() {
        return new LicCapabilityNamespace().get();
    }

    public String printed(Requirement value) {
        StringBuilder out = new StringBuilder();
        this.attributes().stream().map(NamedData.Writable::new).forEach(w -> w.write(out));
        return out.toString();
    }

    public String keyValueSeparator() {
        return ";";
    }

    public String entrySeparator() {
        return ",";
    }

    private List<StringNamedData> attributes() {
        List<StringNamedData> mandatory = Arrays.asList(new StringNamedData[]{new CapabilityLicFeatureId(this.requirement), new CapabilityLicFeatureName(this.requirement), new CapabilityLicFeatureVersion(this.requirement), new CapabilityLicFeatureProvider(this.requirement), new CapabilityLicFeatureLevel(this.requirement)});
        if (this.requirement.agreements().isEmpty()) {
            return mandatory;
        }
        ArrayList<StringNamedData> full = new ArrayList<StringNamedData>(mandatory);
        full.add(new CapabilityLicFeatureAgreements(this.requirement));
        return full;
    }
}

