/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.api.conditions;

import java.util.Objects;
import org.eclipse.passage.lic.api.registry.ServiceId;

public abstract class ConditionMiningTarget
implements ServiceId {
    private final String target;

    public ConditionMiningTarget(String target) {
        Objects.requireNonNull(target, "ConditionMiningTarget::target");
        this.target = target;
    }

    public boolean equals(Object object) {
        if (!this.getClass().isInstance(object)) {
            return false;
        }
        return this.target.equals(((ConditionMiningTarget)object).target());
    }

    public String target() {
        return this.target;
    }

    public int hashCode() {
        return this.target.hashCode();
    }

    public String toString() {
        return this.target;
    }

    public ConditionMiningTarget child(String subtarget) {
        Objects.requireNonNull(subtarget, "ConditionMiningTarget::child");
        return new Of(String.format("%s/%s", this.target, subtarget));
    }

    public static final class Local
    extends ConditionMiningTarget {
        public Local() {
            super("local-file-system");
        }
    }

    public static final class Of
    extends ConditionMiningTarget {
        public Of(String target) {
            super(target.toLowerCase());
        }
    }

    public static final class Remote
    extends ConditionMiningTarget {
        public Remote() {
            super("remote");
        }
    }
}

