/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.core.issue;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.passage.lic.api.conditions.ValidityPeriodClosed;
import org.eclipse.passage.lic.base.conditions.BaseValidityPeriodClosed;
import org.eclipse.passage.lic.equinox.EquinoxPassage;
import org.eclipse.passage.lic.licenses.model.api.FeatureGrant;
import org.eclipse.passage.lic.licenses.model.api.FloatingLicensePack;
import org.eclipse.passage.lic.licenses.model.api.ValidityPeriod;
import org.eclipse.passage.lic.licenses.model.meta.LicensesFactory;
import org.eclipse.passage.loc.internal.licenses.core.issue.ClosedValidityPeriodReduction;
import org.eclipse.passage.loc.internal.licenses.core.issue.FeatureGrantCapacityReduction;
import org.eclipse.passage.loc.internal.licenses.core.issue.Reduction;
import org.eclipse.passage.loc.internal.licenses.core.issue.UserGrantsAmountReduction;

public final class FloatingLicenseIssuingProtection
implements Consumer<FloatingLicensePack> {
    private final String feature = "org.eclipse.passage.loc.operator.issue.floating.full";
    private final List<Reduction<FeatureGrant>> featureReductions = Arrays.asList(new ClosedValidityPeriodReduction<FeatureGrant>(this::validGet, this::validSet), new FeatureGrantCapacityReduction());
    private final List<Reduction<FloatingLicensePack>> licReductions = Arrays.asList(new ClosedValidityPeriodReduction<FloatingLicensePack>(this::validGet, this::validSet), new UserGrantsAmountReduction());

    @Override
    public void accept(FloatingLicensePack license) {
        if (new EquinoxPassage().canUse("org.eclipse.passage.loc.operator.issue.floating.full")) {
            return;
        }
        this.diminish(license);
    }

    private void diminish(FloatingLicensePack license) {
        this.diminishFeatureGrants(license);
        this.diminishLicense(license);
    }

    private void diminishFeatureGrants(FloatingLicensePack license) {
        license.getFeatures().forEach(this::diminishGrant);
    }

    private void diminishLicense(FloatingLicensePack lic) {
        this.licReductions.forEach(r -> r.accept(lic));
    }

    private void diminishGrant(FeatureGrant grant) {
        this.featureReductions.forEach(r -> r.accept(grant));
    }

    private Optional<ValidityPeriodClosed> validGet(FloatingLicensePack lic) {
        return this.validGet(lic.getLicense().getValid());
    }

    private Optional<ValidityPeriodClosed> validGet(FeatureGrant grant) {
        return this.validGet(grant.getValid());
    }

    private Optional<ValidityPeriodClosed> validGet(ValidityPeriod period) {
        if (!(period instanceof org.eclipse.passage.lic.licenses.model.api.ValidityPeriodClosed)) {
            return Optional.empty();
        }
        org.eclipse.passage.lic.licenses.model.api.ValidityPeriodClosed closed = (org.eclipse.passage.lic.licenses.model.api.ValidityPeriodClosed)period;
        return Optional.of(new BaseValidityPeriodClosed(this.date(closed.getFrom()), this.date(closed.getUntil())));
    }

    private void validSet(FloatingLicensePack lic, ValidityPeriodClosed period) {
        lic.getLicense().setValid((ValidityPeriod)this.convert(period));
    }

    private void validSet(FeatureGrant grant, ValidityPeriodClosed period) {
        grant.setValid((ValidityPeriod)this.convert(period));
    }

    private org.eclipse.passage.lic.licenses.model.api.ValidityPeriodClosed convert(ValidityPeriodClosed period) {
        org.eclipse.passage.lic.licenses.model.api.ValidityPeriodClosed valid = LicensesFactory.eINSTANCE.createValidityPeriodClosed();
        valid.setFrom(Date.from(period.from().toInstant()));
        valid.setUntil(Date.from(period.to().toInstant()));
        return valid;
    }

    private ZonedDateTime date(Date date) {
        return ZonedDateTime.from(date.toInstant().atZone(ZoneId.systemDefault()));
    }
}

