/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.io;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.base.Cached;

public final class ExistingFolder
implements Supplier<Path> {
    private final Cached<Supplier<Path>, Path> folder;

    public ExistingFolder(Supplier<Path> folder) {
        this.folder = new Cached<Supplier, Path>(folder, this::existing);
    }

    @Override
    public Path get() {
        return this.folder.get();
    }

    private Path existing(Supplier<Path> origin) {
        Path path = origin.get();
        if (!Files.exists(path, new LinkOption[0])) {
            path.toFile().mkdirs();
        }
        return path;
    }
}

