/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.hc.remote.impl.acquire;

import java.nio.file.Path;
import java.util.function.Supplier;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.api.acquire.GrantAcquisition;
import org.eclipse.passage.lic.api.io.HashesRegistry;
import org.eclipse.passage.lic.hc.remote.Client;
import org.eclipse.passage.lic.hc.remote.Configuration;
import org.eclipse.passage.lic.hc.remote.Connection;
import org.eclipse.passage.lic.hc.remote.RequestContext;
import org.eclipse.passage.lic.hc.remote.ResponseHandler;
import org.eclipse.passage.lic.hc.remote.impl.BaseConfiguration;
import org.eclipse.passage.lic.hc.remote.impl.EObjectFromXmiResponse;
import org.eclipse.passage.lic.hc.remote.impl.Equipment;
import org.eclipse.passage.lic.hc.remote.impl.RemoteRequest;
import org.eclipse.passage.lic.hc.remote.impl.RemoteServiceData;
import org.eclipse.passage.lic.hc.remote.impl.RequestParameters;
import org.eclipse.passage.lic.hc.remote.impl.ResultsTransfered;
import org.eclipse.passage.lic.hc.remote.impl.ServiceAny;
import org.eclipse.passage.lic.hc.remote.impl.acquire.AcquireRequestParameters;
import org.eclipse.passage.lic.internal.licenses.convert.PGrantAcquisition;
import org.eclipse.passage.lic.licenses.model.api.FloatingLicenseAccess;
import org.eclipse.passage.lic.licenses.model.api.GrantAcqisition;

final class RemoteAcquire<C extends Connection>
extends ServiceAny<C, GrantAcquisition, RemoteServiceData.OfFeature> {
    RemoteAcquire(Equipment equipment, Supplier<Client<C, GrantAcquisition>> client, Supplier<Path> source) {
        super(equipment, client, source);
    }

    @Override
    protected RemoteRequest<C> request(RemoteServiceData.OfFeature params, FloatingLicenseAccess access) {
        return new Request(params, access, this.equipment.hashes());
    }

    @Override
    protected ResponseHandler<GrantAcquisition> handler(FloatingLicenseAccess access) {
        return new Response(new EObjectFromXmiResponse<GrantAcqisition>(GrantAcqisition.class, this.equipment));
    }

    private final class Request
    extends RemoteRequest<C> {
        private final RemoteServiceData.OfFeature data;

        Request(RemoteServiceData.OfFeature data, FloatingLicenseAccess access, HashesRegistry hashes) {
            super(data.product(), access, hashes);
            this.data = data;
        }

        @Override
        public RequestParameters parameters() {
            return new AcquireRequestParameters(this.data.product(), this.data.feature(), this.access, this.hash);
        }

        @Override
        public Configuration<C> config() {
            return new BaseConfiguration.Get();
        }
    }

    private static final class Response
    implements ResponseHandler<GrantAcquisition> {
        private final ResponseHandler<GrantAcqisition> delegate;

        private Response(ResponseHandler<GrantAcqisition> delegate) {
            this.delegate = delegate;
        }

        @Override
        public GrantAcquisition read(ResultsTransfered results, RequestContext context) throws LicensingException {
            return this.apiGrant(this.delegate.read(results, context));
        }

        private GrantAcquisition apiGrant(GrantAcqisition source) {
            return new PGrantAcquisition(source).get();
        }
    }
}

