/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base.mine;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.passage.lbc.internal.base.i18n.BaseMessages;
import org.eclipse.passage.lbc.internal.base.mine.AssembledConditions;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.conditions.Condition;
import org.eclipse.passage.lic.api.conditions.ConditionMiningTarget;
import org.eclipse.passage.lic.api.conditions.ConditionOrigin;
import org.eclipse.passage.lic.api.conditions.ConditionPack;
import org.eclipse.passage.lic.api.conditions.mining.ConditionTransport;
import org.eclipse.passage.lic.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.api.diagnostic.Trouble;
import org.eclipse.passage.lic.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.api.io.KeyKeeper;
import org.eclipse.passage.lic.api.io.StreamCodec;
import org.eclipse.passage.lic.base.BaseLicensedProduct;
import org.eclipse.passage.lic.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.base.conditions.BaseConditionOrigin;
import org.eclipse.passage.lic.base.conditions.BaseConditionPack;
import org.eclipse.passage.lic.base.conditions.mining.ArmedMiningTool;
import org.eclipse.passage.lic.base.diagnostic.BaseDiagnostic;
import org.eclipse.passage.lic.base.diagnostic.code.ServiceFailedOnMorsel;
import org.eclipse.passage.lic.internal.emf.EObjectFromBytes;
import org.eclipse.passage.lic.internal.licenses.convert.PAgreements;
import org.eclipse.passage.lic.licenses.model.api.FloatingLicensePack;
import org.eclipse.passage.lic.licenses.model.api.ProductRef;
import org.eclipse.passage.lic.licenses.model.meta.LicensesPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ReassemblingMiningTool
extends ArmedMiningTool {
    private final String user;
    private final LicensedProduct product;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    ReassemblingMiningTool(KeyKeeper key, StreamCodec codec, ConditionTransport transport, LicensedProduct product, String user, ConditionMiningTarget miner) {
        super(key, codec, transport, miner);
        this.product = product;
        this.user = user;
    }

    public ServiceInvocationResult<Collection<ConditionPack>> mine(Collection<Path> sources) {
        ArrayList<ConditionPack> packs = new ArrayList<ConditionPack>();
        ArrayList<Trouble> failures = new ArrayList<Trouble>();
        for (Path license : sources) {
            try {
                packs.add(this.conditions(license));
            }
            catch (LicensingException e) {
                this.log.error("failed: ", (Throwable)e);
                failures.add(new Trouble((TroubleCode)new ServiceFailedOnMorsel(), String.format(BaseMessages.ReassemblingMiningTool_path_failed, license.toAbsolutePath().toString()), (Exception)((Object)e)));
            }
        }
        return new BaseServiceInvocationResult((Diagnostic)new BaseDiagnostic(Collections.emptyList(), failures), packs);
    }

    private ConditionPack conditions(Path license) throws LicensingException {
        FloatingLicensePack pack = this.pack(license);
        if (!this.productFits(pack.getLicense().getProduct())) {
            return this.noConditions(license);
        }
        Collection<Condition> conditions = new AssembledConditions(pack).forUser(this.user);
        return new BaseConditionPack((ConditionOrigin)this.origin(license), conditions, new PAgreements((Collection)pack.getLicense().getAgreements()).get());
    }

    private boolean productFits(ProductRef ref) {
        return new BaseLicensedProduct(ref.getIdentifier(), ref.getVersion()).equals((Object)this.product);
    }

    private FloatingLicensePack pack(Path source) throws LicensingException {
        return (FloatingLicensePack)new EObjectFromBytes(this.decoded(source), LicensesPackage.eINSTANCE.getFloatingLicensePack()).get(Collections.singletonMap("http://www.eclipse.org/passage/lic/licenses/2.0.0", LicensesPackage.eINSTANCE));
    }

    private BaseConditionPack noConditions(Path license) {
        return new BaseConditionPack((ConditionOrigin)this.origin(license), Collections.emptyList(), Collections.emptyList());
    }

    private BaseConditionOrigin origin(Path license) {
        return new BaseConditionOrigin(this.miner, license.toAbsolutePath().toString());
    }
}

