/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.access;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.passage.lic.api.LicensingConfiguration;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.api.LicensingReporter;
import org.eclipse.passage.lic.api.LicensingResult;
import org.eclipse.passage.lic.api.access.AccessManager;
import org.eclipse.passage.lic.api.access.FeaturePermission;
import org.eclipse.passage.lic.api.access.PermissionEmitter;
import org.eclipse.passage.lic.api.access.PermissionExaminer;
import org.eclipse.passage.lic.api.conditions.ConditionMiner;
import org.eclipse.passage.lic.api.conditions.ConditionMinerRegistry;
import org.eclipse.passage.lic.api.conditions.LicensingCondition;
import org.eclipse.passage.lic.api.requirements.LicensingRequirement;
import org.eclipse.passage.lic.api.requirements.RequirementResolver;
import org.eclipse.passage.lic.api.restrictions.RestrictionExecutor;
import org.eclipse.passage.lic.api.restrictions.RestrictionVerdict;
import org.eclipse.passage.lic.base.LicensingResults;
import org.eclipse.passage.lic.base.SystemReporter;
import org.eclipse.passage.lic.base.conditions.BaseConditionMinerRegistry;
import org.eclipse.passage.lic.base.conditions.LicensingConditions;
import org.eclipse.passage.lic.base.requirements.LicensingRequirements;
import org.eclipse.passage.lic.base.restrictions.RestrictionVerdicts;
import org.eclipse.passage.lic.internal.base.i18n.BaseMessages;

public class BaseAccessManager
implements AccessManager {
    private LicensingReporter licensingReporter = SystemReporter.INSTANCE;
    private final List<RequirementResolver> requirementResolvers = new ArrayList<RequirementResolver>();
    private ConditionMinerRegistry conditionMinerRegistry = new BaseConditionMinerRegistry();
    private final Map<String, PermissionEmitter> permissionEmitters = new HashMap<String, PermissionEmitter>();
    private final List<RestrictionExecutor> restrictionExecutors = new ArrayList<RestrictionExecutor>();
    private PermissionExaminer examiner;

    public void bindLicensingReporter(LicensingReporter reporter) {
        this.licensingReporter = reporter;
    }

    public void unbindLicensingReporter(LicensingReporter reporter) {
        if (this.licensingReporter == reporter) {
            this.licensingReporter = SystemReporter.INSTANCE;
        }
    }

    public LicensingReporter getLicensingReporter() {
        return this.licensingReporter;
    }

    public void bindRequirementResolver(RequirementResolver requirementResolver) {
        this.requirementResolvers.add(requirementResolver);
    }

    public void unbindRequirementResolver(RequirementResolver configurationResolver) {
        this.requirementResolvers.remove(configurationResolver);
    }

    public void bindConditionMinerRegistry(ConditionMinerRegistry registry) {
        this.conditionMinerRegistry = registry;
    }

    public void unbindConditionMinerRegistry(ConditionMinerRegistry registry) {
        if (this.conditionMinerRegistry == registry) {
            this.conditionMinerRegistry = null;
        }
    }

    public void bindPermissionEmitter(PermissionEmitter permissionEmitter, Map<String, Object> properties) {
        Object conditionType = properties.get("licensing.condition.type.id");
        String type = String.valueOf(conditionType);
        this.permissionEmitters.put(type, permissionEmitter);
    }

    public void unbindPermissionEmitter(PermissionEmitter permissionEmitter, Map<String, Object> properties) {
        Object conditionType = properties.get("licensing.condition.type.id");
        String type = String.valueOf(conditionType);
        this.permissionEmitters.remove(type, permissionEmitter);
    }

    public void bindPermissionExaminer(PermissionExaminer permissionExaminer) {
        this.examiner = permissionExaminer;
    }

    public void unbindPermissionExaminer(PermissionExaminer permissionExaminer) {
        this.examiner = permissionExaminer == this.examiner ? null : null;
    }

    public void bindRestrictionExecutor(RestrictionExecutor restrictionExecutor) {
        this.restrictionExecutors.add(restrictionExecutor);
    }

    public void unbindRestrictionExecutor(RestrictionExecutor restrictionExecutor) {
        this.restrictionExecutors.remove(restrictionExecutor);
    }

    public LicensingResult executeAccessRestrictions(LicensingConfiguration configuration) {
        Iterable<LicensingRequirement> requirements = this.resolveRequirements(configuration);
        Iterable<LicensingCondition> conditions = this.extractConditions(configuration);
        Iterable<FeaturePermission> permissions = this.evaluateConditions(configuration, conditions);
        Iterable<RestrictionVerdict> verdicts = this.examinePermissions(configuration, requirements, permissions);
        return this.executeRestrictions(configuration, verdicts);
    }

    public Iterable<LicensingRequirement> resolveRequirements(LicensingConfiguration configuration) {
        String featureId;
        ArrayList<LicensingRequirement> result = new ArrayList<LicensingRequirement>();
        String source = this.getClass().getName();
        if (configuration == null) {
            featureId = "org.eclipse.passage.lic.api.configuration.invalid";
            result.add(LicensingRequirements.createConfigurationError(featureId, source));
        } else if (this.requirementResolvers.isEmpty()) {
            featureId = configuration.getProductIdentifier();
            result.add(LicensingRequirements.createConfigurationError(featureId, source));
        } else {
            for (RequirementResolver configurationResolver : this.requirementResolvers) {
                Iterable requirements = configurationResolver.resolveLicensingRequirements(configuration);
                for (LicensingRequirement requirement : requirements) {
                    result.add(requirement);
                }
            }
        }
        List<LicensingRequirement> unmodifiable = Collections.unmodifiableList(result);
        this.licensingReporter.postResult(LicensingResults.createEvent("org/eclipse/passage/lic/api/RequirementEvents/requirementsResolved", unmodifiable));
        return unmodifiable;
    }

    public Iterable<LicensingCondition> extractConditions(LicensingConfiguration configuration) {
        if (this.conditionMinerRegistry == null) {
            return Collections.emptyList();
        }
        ArrayList<LicensingCondition> mined = new ArrayList<LicensingCondition>();
        Iterable conditionMiners = this.conditionMinerRegistry.getConditionMiners();
        ArrayList<LicensingResult> errors = new ArrayList<LicensingResult>();
        for (ConditionMiner conditionMiner : conditionMiners) {
            Iterable conditions = conditionMiner.extractLicensingConditions(configuration);
            if (conditions == null) {
                String source = conditionMiner.getClass().getName();
                String message = BaseMessages.getString("BaseAccessManager_invalid_condition_miner");
                LicensingResult error = LicensingResults.createError(message, source, (Throwable)new NullPointerException());
                errors.add(error);
                continue;
            }
            for (LicensingCondition condition : conditions) {
                mined.add(condition);
            }
        }
        List<LicensingCondition> unmodifiable = Collections.unmodifiableList(mined);
        this.licensingReporter.postResult(LicensingResults.createEvent("org/eclipse/passage/lic/api/AccessEvents/conditionsExtracted", unmodifiable));
        return unmodifiable;
    }

    public Iterable<FeaturePermission> evaluateConditions(LicensingConfiguration configuration, Iterable<LicensingCondition> conditions) {
        ArrayList<FeaturePermission> result = new ArrayList<FeaturePermission>();
        String source = this.getClass().getName();
        if (conditions == null) {
            String message = BaseMessages.getString("BaseAccessManager_evaluation_error_invalid_condition");
            LicensingResult error = LicensingResults.createError(message, source, (Throwable)new IllegalArgumentException());
            this.licensingReporter.logResult(error);
            List<FeaturePermission> empty = Collections.emptyList();
            this.licensingReporter.postResult(LicensingResults.createEvent("org/eclipse/passage/lic/api/AccessEvents/conditionsEvaluated", empty, error));
            return empty;
        }
        ArrayList<LicensingCondition> invalid = new ArrayList<LicensingCondition>();
        for (LicensingCondition condition : conditions) {
            if (condition == null) {
                String message = BaseMessages.getString("BaseAccessManager_evaluation_error_invalid_condition");
                LicensingResult error = LicensingResults.createError(message, source, (Throwable)new NullPointerException());
                this.licensingReporter.logResult(error);
                continue;
            }
            LicensingResult validate = LicensingConditions.validate(condition, source);
            if (validate.getSeverity() == 0) {
                String type = condition.getConditionType();
                PermissionEmitter emitter = this.permissionEmitters.get(type);
                if (emitter == null) {
                    String message = String.format(BaseMessages.getString("BaseAccessManager__evaluation_error_no_emitter"), type);
                    LicensingResult error = LicensingResults.createError(message, source, (Throwable)new NullPointerException());
                    this.licensingReporter.logResult(error);
                    continue;
                }
                List<LicensingCondition> mappedConditions = Collections.singletonList(condition);
                try {
                    Iterable permissions = emitter.emitPermissions(configuration, mappedConditions);
                    for (FeaturePermission permission : permissions) {
                        result.add(permission);
                    }
                }
                catch (LicensingException e) {
                    LicensingResult error = e.getResult();
                    this.licensingReporter.logResult(error);
                    this.licensingReporter.postResult(LicensingResults.createEvent("org/eclipse/passage/lic/api/ConditionEvents/conditionsNotValid", mappedConditions, error));
                }
                continue;
            }
            this.licensingReporter.logResult(validate);
            invalid.add(condition);
        }
        List<FeaturePermission> unmodifiable = Collections.unmodifiableList(result);
        this.licensingReporter.postResult(LicensingResults.createEvent("org/eclipse/passage/lic/api/AccessEvents/conditionsEvaluated", unmodifiable));
        return unmodifiable;
    }

    public Iterable<RestrictionVerdict> examinePermissions(LicensingConfiguration configuration, Iterable<LicensingRequirement> requirements, Iterable<FeaturePermission> permissions) {
        String source = this.getClass().getName();
        if (configuration == null) {
            String message = BaseMessages.getString("BaseAccessManager_permission_examine_error_invalida_configuration");
            LicensingResult error = LicensingResults.createError(message, source, (Throwable)new NullPointerException());
            this.licensingReporter.logResult(error);
            List<RestrictionVerdict> examined = Collections.emptyList();
            this.licensingReporter.postResult(LicensingResults.createEvent("org/eclipse/passage/lic/api/AccessEvents/permissionsExamined", examined));
            return examined;
        }
        if (requirements == null) {
            String message = BaseMessages.getString("BaseAccessManager_permission_examine_error_invalid_configuration_requirements");
            LicensingResult error = LicensingResults.createError(message, source, (Throwable)new NullPointerException());
            this.licensingReporter.logResult(error);
            List<RestrictionVerdict> examined = Collections.emptyList();
            this.licensingReporter.postResult(LicensingResults.createEvent("org/eclipse/passage/lic/api/AccessEvents/permissionsExamined", examined));
            return examined;
        }
        if (this.examiner == null) {
            String message = String.format(BaseMessages.getString("BaseAccessManager_permission_examine_error_no_examiner"), requirements);
            LicensingResult error = LicensingResults.createError(message, source, (Throwable)new NullPointerException());
            this.licensingReporter.logResult(error);
            ArrayList<RestrictionVerdict> verdicts = new ArrayList<RestrictionVerdict>();
            for (LicensingRequirement requirement : requirements) {
                if (requirement == null) {
                    String message2 = BaseMessages.getString("BaseAccessManager_permission_examine_error_invalid_config_req_ingnored");
                    LicensingResult error2 = LicensingResults.createError(message2, source, (Throwable)new NullPointerException());
                    this.licensingReporter.logResult(error2);
                    continue;
                }
                RestrictionVerdict verdict = RestrictionVerdicts.createError(configuration, requirement, 500);
                verdicts.add(verdict);
            }
            this.licensingReporter.postResult(LicensingResults.createEvent("org/eclipse/passage/lic/api/AccessEvents/permissionsExamined", Collections.unmodifiableList(verdicts)));
            return verdicts;
        }
        Iterable examined = this.examiner.examine(configuration, requirements, permissions);
        this.licensingReporter.postResult(LicensingResults.createEvent("org/eclipse/passage/lic/api/AccessEvents/permissionsExamined", examined));
        return examined;
    }

    public Iterable<RestrictionVerdict> examinePermissons(LicensingConfiguration configuration, Iterable<LicensingRequirement> requirements, Iterable<FeaturePermission> permissions) {
        return this.examinePermissions(configuration, requirements, permissions);
    }

    public LicensingResult executeRestrictions(LicensingConfiguration configuration, Iterable<RestrictionVerdict> restrictions) {
        String source = this.getClass().getName();
        String task = BaseMessages.getString("BaseAccessManager_execute_restriction_task_name");
        ArrayList<LicensingResult> errors = new ArrayList<LicensingResult>();
        for (RestrictionExecutor executor : this.restrictionExecutors) {
            try {
                executor.execute(restrictions);
            }
            catch (Exception e) {
                String message = String.format(BaseMessages.getString("BaseAccessManager_execute_restriction_execution_error"), executor, restrictions);
                LicensingResult error = LicensingResults.createError(message, source, (Throwable)e);
                errors.add(error);
            }
        }
        this.licensingReporter.postResult(LicensingResults.createEvent("org/eclipse/passage/lic/api/AccessEvents/restrictionsExecuted", restrictions));
        if (errors.isEmpty()) {
            return LicensingResults.createOK(task, source);
        }
        return LicensingResults.createError(task, source, errors);
    }
}

