/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.oshi;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.passage.lic.api.LicensingReporter;
import org.eclipse.passage.lic.api.LicensingResult;
import org.eclipse.passage.lic.api.inspector.HardwareInspector;
import org.eclipse.passage.lic.base.LicensingResults;
import org.eclipse.passage.lic.base.SystemReporter;
import org.eclipse.passage.lic.internal.oshi.i18n.OshiMessages;
import org.eclipse.passage.lic.oshi.OshiHal;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import oshi.SystemInfo;
import oshi.hardware.Baseboard;
import oshi.hardware.CentralProcessor;
import oshi.hardware.ComputerSystem;
import oshi.hardware.Firmware;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.software.os.OperatingSystem;
import oshi.software.os.OperatingSystemVersion;

@Component
public class OshiHardwareInspector
implements HardwareInspector {
    private final Map<String, String> hardwareProperties = new LinkedHashMap<String, String>();
    private LicensingReporter licensingReporter = SystemReporter.INSTANCE;

    @Activate
    public void activate() {
        this.initHardwareProperties();
    }

    private void initHardwareProperties() {
        try {
            HWDiskStore[] diskStores;
            SystemInfo systemInfo = new SystemInfo();
            OperatingSystem os = systemInfo.getOperatingSystem();
            this.hardwareProperties.put("os.manufacturer", os.getManufacturer());
            this.hardwareProperties.put("os.family", os.getFamily());
            OperatingSystemVersion version = os.getVersion();
            this.hardwareProperties.put("os.version", version.getVersion());
            this.hardwareProperties.put("os.buildnumber", version.getBuildNumber());
            HardwareAbstractionLayer hal = systemInfo.getHardware();
            ComputerSystem computerSystem = hal.getComputerSystem();
            this.hardwareProperties.put("system.manufacturer", computerSystem.getManufacturer());
            this.hardwareProperties.put("system.model", computerSystem.getModel());
            this.hardwareProperties.put("system.serialnumber", computerSystem.getSerialNumber());
            Baseboard baseboard = computerSystem.getBaseboard();
            this.hardwareProperties.put("baseboard.manufacturer", baseboard.getManufacturer());
            this.hardwareProperties.put("baseboard.model", baseboard.getModel());
            this.hardwareProperties.put("baseboard.version", baseboard.getVersion());
            this.hardwareProperties.put("baseboard.serialnumber", baseboard.getSerialNumber());
            Firmware firmware = computerSystem.getFirmware();
            this.hardwareProperties.put("firmware.manufacturer", firmware.getManufacturer());
            this.hardwareProperties.put("firmware.version", firmware.getVersion());
            this.hardwareProperties.put("firmware.releasedate", firmware.getReleaseDate());
            this.hardwareProperties.put("firmware.name", firmware.getName());
            this.hardwareProperties.put("firmware.description", firmware.getDescription());
            CentralProcessor processor = hal.getProcessor();
            this.hardwareProperties.put("cpu.vendor", processor.getVendor());
            this.hardwareProperties.put("cpu.family", processor.getFamily());
            this.hardwareProperties.put("cpu.model", processor.getModel());
            this.hardwareProperties.put("cpu.name", processor.getName());
            this.hardwareProperties.put("cpu.identifier", processor.getIdentifier());
            this.hardwareProperties.put("cpu.processorid", processor.getProcessorID());
            HWDiskStore[] hWDiskStoreArray = diskStores = hal.getDiskStores();
            if (diskStores.length != 0) {
                HWDiskStore hwDiskStore = hWDiskStoreArray[0];
                this.hardwareProperties.put("hwdisk.model", hwDiskStore.getModel());
                this.hardwareProperties.put("hwdisk.name", hwDiskStore.getName());
                this.hardwareProperties.put("hwdisk.serial", hwDiskStore.getSerial());
            }
        }
        catch (Exception | NoClassDefFoundError | UnsatisfiedLinkError e) {
            String source = this.getClass().getName();
            LicensingResult result = LicensingResults.createError((String)OshiMessages.OshiHardwareInspector_e_reading_hw, (String)source, (Throwable)e);
            this.licensingReporter.logResult(result);
        }
    }

    @Reference
    public void bindLicensingReporter(LicensingReporter reporter) {
        this.licensingReporter = reporter;
    }

    public void unbindLicensingReporter(LicensingReporter reporter) {
        if (this.licensingReporter == reporter) {
            this.licensingReporter = SystemReporter.INSTANCE;
        }
    }

    public void dumpHardwareInfo(OutputStream output) throws IOException {
        OshiHal.dumpHardwareInfo(output, this.hardwareProperties);
    }

    public String inspectProperty(String name) {
        return this.hardwareProperties.get(name);
    }

    public Iterable<String> getKnownProperties() {
        return this.hardwareProperties.keySet();
    }
}

