/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.equinox.conditions;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lbc.api.BackendActionExecutor;
import org.eclipse.passage.lbc.internal.equinox.i18n.EquinoxMessages;
import org.eclipse.passage.lic.api.LicensingConfiguration;
import org.eclipse.passage.lic.api.LicensingResult;
import org.eclipse.passage.lic.api.conditions.ConditionMiner;
import org.eclipse.passage.lic.api.conditions.ConditionTransport;
import org.eclipse.passage.lic.base.LicensingConfigurations;
import org.eclipse.passage.lic.base.LicensingResults;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"action=acquire"})
public class AcquireConditionActionExecutor
implements BackendActionExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(AcquireConditionActionExecutor.class);
    private List<ConditionMiner> licenseConditionMiners = new ArrayList<ConditionMiner>();
    private Map<String, ConditionTransport> mapCondition2Transport = new HashMap<String, ConditionTransport>();

    public LicensingResult executeAction(HttpServletRequest request, HttpServletResponse response) {
        String source = this.getClass().getName();
        LOG.info(NLS.bind((String)EquinoxMessages.AcquireConditionActionExecutor_i_execute_action, (Object)source));
        if (this.licenseConditionMiners.isEmpty()) {
            String error = EquinoxMessages.AcquireConditionActionExecutor_e_no_miners;
            LOG.error(error);
            return LicensingResults.createError((String)error, (String)source);
        }
        try {
            String productId = request.getParameter("licensing.product.identifier");
            String productVersion = request.getParameter("licensing.product.version");
            LicensingConfiguration configuration = LicensingConfigurations.create((String)productId, (String)productVersion);
            ArrayList resultConditions = new ArrayList();
            for (ConditionMiner miner : this.licenseConditionMiners) {
                Iterable descriptors = miner.extractLicensingConditions(configuration);
                resultConditions.addAll((Collection)descriptors);
            }
            String contentType = request.getParameter("licensing.content.type");
            ConditionTransport transport = this.mapCondition2Transport.get(contentType);
            if (transport == null) {
                String error = NLS.bind((String)EquinoxMessages.AcquireConditionActionExecutor_e_transport_not_defined, (Object)contentType);
                LOG.error(error);
                return LicensingResults.createError((String)error, (String)source);
            }
            transport.writeConditions(resultConditions, (OutputStream)response.getOutputStream());
            response.setContentType(request.getContentType());
            return LicensingResults.createOK((String)EquinoxMessages.AcquireConditionActionExecutor_k_mined, (String)source);
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            String error = EquinoxMessages.AcquireConditionActionExecutor_e_mining_failed;
            return LicensingResults.createError((String)error, (String)source, (Throwable)e);
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindConditionMiner(ConditionMiner conditionMiner) {
        this.licenseConditionMiners.add(conditionMiner);
    }

    public void unbindConditionMiner(ConditionMiner conditionMiner) {
        this.licenseConditionMiners.remove(conditionMiner);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindConditionTransport(ConditionTransport transport, Map<String, String> context) {
        String conditionType = context.get("licensing.content.type");
        this.mapCondition2Transport.put(conditionType, transport);
    }

    public void unbindConditionTransport(ConditionTransport transport, Map<String, String> context) {
        String conditionType = context.get("licensing.content.type");
        this.mapCondition2Transport.remove(conditionType, transport);
    }
}

