/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.workbench.emfforms.renderers;

import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.di.EMFFormsDIRendererService;

public class StructuredFeatureRendererService
implements EMFFormsDIRendererService<VControl> {
    private final Class<? extends AbstractSWTRenderer<VControl>> renderer;
    private final EStructuralFeature feature;
    private double priority = 10.0;
    private EMFFormsDatabinding databindingService;
    private ReportService reportService;

    protected StructuredFeatureRendererService(Class<? extends AbstractSWTRenderer<VControl>> renderer, EStructuralFeature feature) {
        this.renderer = renderer;
        this.feature = feature;
    }

    public double isApplicable(VElement vElement, ViewModelContext viewModelContext) {
        EStructuralFeature structuralFeature;
        IValueProperty valueProperty;
        if (!VControl.class.isInstance(vElement)) {
            return Double.NaN;
        }
        VControl control = (VControl)vElement;
        if (control.getDomainModelReference() == null) {
            return Double.NaN;
        }
        try {
            valueProperty = this.databindingService.getValueProperty(control.getDomainModelReference(), viewModelContext.getDomainModel());
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return Double.NaN;
        }
        Object valueType = valueProperty.getValueType();
        if (valueType instanceof EStructuralFeature && (structuralFeature = (EStructuralFeature)valueType).equals(this.feature)) {
            return this.priority;
        }
        return Double.NaN;
    }

    public Class<? extends AbstractSWTRenderer<VControl>> getRendererClass() {
        return this.renderer;
    }

    protected void bindEMFFormsDatabinding(EMFFormsDatabinding databindingService) {
        this.databindingService = databindingService;
    }

    protected void unbindEMFFormsDatabinding(EMFFormsDatabinding databindingService) {
        this.databindingService = null;
    }

    protected void bindReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    protected void unbindReportService(ReportService reportService) {
        this.reportService = null;
    }
}

