/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.wizards;

import java.io.File;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.passage.lic.api.LicensingResult;
import org.eclipse.passage.loc.internal.dashboard.ui.i18n.IssueLicensePageMessages;
import org.eclipse.passage.loc.internal.licenses.core.LicenseMailSupport;
import org.eclipse.swt.program.Program;

public class IssueLicenseMailJob
extends Job {
    private LicensingResult licensinResult;
    private boolean createEml;
    private boolean createMail;
    private LicenseMailSupport mailSupport;
    private Optional<File> optEmlFile;

    public IssueLicenseMailJob(String jobName, LicensingResult licensinResult, LicenseMailSupport mailSupport, boolean createMail, boolean createEml) {
        super(jobName);
        this.licensinResult = licensinResult;
        this.createEml = createEml;
        this.createMail = createMail;
        this.mailSupport = mailSupport;
        this.optEmlFile = Optional.empty();
    }

    protected IStatus run(IProgressMonitor monitor) {
        String licenseOut;
        monitor.beginTask(IssueLicensePageMessages.IssueLicensingMailJob_task_text, -1);
        if (this.createMail) {
            this.processingToMailClient();
        }
        if (this.createEml && (licenseOut = (String)this.licensinResult.getAttachment("licenses_out")) != null && !licenseOut.isEmpty()) {
            this.optEmlFile = this.processingToMailEml(new File(licenseOut));
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    public void processingToMailClient() {
        Program.launch((String)this.mailSupport.getMailToString());
    }

    public Optional<File> processingToMailEml(File attachement) {
        return this.mailSupport.createEmlFile(attachement);
    }

    public Optional<File> getEmlFile() {
        return this.optEmlFile;
    }
}

