/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.core;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.api.LicensingReporter;
import org.eclipse.passage.lic.base.LicensingResults;
import org.eclipse.passage.lic.emf.ecore.DomainContentAdapter;
import org.eclipse.passage.lic.emf.ecore.EditingDomainRegistry;
import org.eclipse.passage.lic.emf.edit.BaseDomainRegistry;
import org.eclipse.passage.lic.emf.edit.ComposedAdapterFactoryProvider;
import org.eclipse.passage.lic.equinox.io.EquinoxPaths;
import org.eclipse.passage.lic.licenses.LicensePlanDescriptor;
import org.eclipse.passage.lic.licenses.model.meta.LicensesPackage;
import org.eclipse.passage.lic.licenses.registry.LicenseRegistry;
import org.eclipse.passage.loc.internal.licenses.core.LicensesDomainRegistryTracker;
import org.eclipse.passage.loc.internal.licenses.core.i18n.LicensesCoreMessages;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"org.eclipse.passage.lic.emf.edit.domain.name=licenses", "org.eclipse.passage.lic.emf.edit.file.extension=licenses_xmi"})
public class LicenseDomainRegistry
extends BaseDomainRegistry<LicensePlanDescriptor>
implements LicenseRegistry,
EditingDomainRegistry<LicensePlanDescriptor> {
    private final Map<String, LicensePlanDescriptor> licensePlanIndex = new HashMap<String, LicensePlanDescriptor>();

    @Reference
    public void bindLicensingReporter(LicensingReporter admin) {
        super.bindLicensingReporter(admin);
    }

    public void unbindLicensingReporter(LicensingReporter admin) {
        super.unbindLicensingReporter(admin);
    }

    @Reference
    public void bindFactoryProvider(ComposedAdapterFactoryProvider factoryProvider) {
        super.bindFactoryProvider(factoryProvider);
    }

    public void unbindFactoryProvider(ComposedAdapterFactoryProvider factoryProvider) {
        super.unbindFactoryProvider(factoryProvider);
    }

    @Activate
    public void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    @Deactivate
    public void deactivate(Map<String, Object> properties) {
        this.licensePlanIndex.clear();
        super.deactivate(properties);
    }

    public String getFileExtension() {
        return "licenses_xmi";
    }

    public Class<LicensePlanDescriptor> getContentClass() {
        return LicensePlanDescriptor.class;
    }

    public String resolveIdentifier(LicensePlanDescriptor content) {
        return content.getIdentifier();
    }

    public Iterable<LicensePlanDescriptor> getLicensePlans() {
        return new ArrayList<LicensePlanDescriptor>(this.licensePlanIndex.values());
    }

    public LicensePlanDescriptor getLicensePlan(String identifier) {
        return this.licensePlanIndex.get(identifier);
    }

    public void registerLicensePlan(LicensePlanDescriptor licensePlan) {
        String identifier = licensePlan.getIdentifier();
        LicensePlanDescriptor existing = this.licensePlanIndex.put(identifier, licensePlan);
        if (existing != null) {
            String msg = NLS.bind((String)LicensesCoreMessages.LicenseDomain_instance_duplication_message, (Object)existing, (Object)licensePlan);
            this.licensingReporter.logResult(LicensingResults.createWarning((String)msg, ((Object)((Object)this)).getClass(), null));
        }
        this.licensingReporter.postResult(LicensingResults.createEvent((String)"org/eclipse/passage/lic/licenses/registry/LicensePlan/create", (Object)licensePlan));
    }

    public void unregisterLicensePlan(String identifier) {
        LicensePlanDescriptor removed = this.licensePlanIndex.remove(identifier);
        if (removed != null) {
            this.licensingReporter.postResult(LicensingResults.createEvent((String)"org/eclipse/passage/lic/licenses/registry/LicensePlan/delete", (Object)removed));
        }
    }

    protected DomainContentAdapter<LicensePlanDescriptor, LicenseDomainRegistry> createContentAdapter() {
        return new LicensesDomainRegistryTracker(this);
    }

    public EClass getContentClassifier() {
        return LicensesPackage.eINSTANCE.getLicensePlan();
    }

    public EStructuralFeature getContentIdentifierAttribute() {
        return LicensesPackage.eINSTANCE.getLicensePlan_Identifier();
    }

    public EStructuralFeature getContentNameAttribute() {
        return LicensesPackage.eINSTANCE.getLicensePlan_Name();
    }

    public void registerContent(LicensePlanDescriptor content) {
        this.registerLicensePlan(content);
    }

    public void unregisterContent(String identifier) {
        this.unregisterLicensePlan(identifier);
    }

    protected Path getResourceSetPath() throws Exception {
        Path passagePath = EquinoxPaths.resolveInstallBasePath();
        Files.createDirectories(passagePath, new FileAttribute[0]);
        return passagePath.resolve(this.domainName);
    }
}

