/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.oshi;

import org.eclipse.passage.lic.api.LicensingReporter;
import org.eclipse.passage.lic.api.access.PermissionEmitter;
import org.eclipse.passage.lic.api.inspector.HardwareInspector;
import org.eclipse.passage.lic.base.SystemReporter;
import org.eclipse.passage.lic.base.access.BasePermissionEmitter;
import org.eclipse.passage.lic.base.conditions.LicensingConditions;
import org.eclipse.passage.lic.internal.oshi.OshiHardwareInspector;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"licensing.condition.type.id=hardware", "licensing.condition.type.name=Hardware", "licensing.condition.type.description=Evaluates node-locked conditions using runtime hardware information"})
public class OshiPermissionEmitter
extends BasePermissionEmitter
implements PermissionEmitter {
    private OshiHardwareInspector hardwareInspector;
    private LicensingReporter licensingReporter = new SystemReporter();

    @Reference
    public void bindLicensingReporter(LicensingReporter reporter) {
        this.licensingReporter = reporter;
    }

    public void unbindLicensingReporter(LicensingReporter reporter) {
        if (this.licensingReporter == reporter) {
            this.licensingReporter = new SystemReporter();
        }
    }

    @Reference
    public void bindHardwareInspector(HardwareInspector inspector) {
        this.hardwareInspector = (OshiHardwareInspector)inspector;
    }

    public void unbindHardwareInspector(HardwareInspector inspector) {
        if (this.hardwareInspector == inspector) {
            this.hardwareInspector = null;
        }
    }

    protected boolean evaluateSegment(String key, String expected) {
        if (key.equals("hwdisk.serial")) {
            return this.hardwareInspector.disks().stream().anyMatch(disk -> LicensingConditions.evaluateSegmentValue((String)expected, (String)disk.getSerial()));
        }
        String actual = this.hardwareInspector.inspectProperty(key);
        return LicensingConditions.evaluateSegmentValue((String)expected, (String)actual);
    }
}

