/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.edit.ui.handlers;

import javax.inject.Named;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.passage.lic.emf.edit.BaseDomainRegistry;
import org.eclipse.passage.lic.emf.edit.EditingDomainRegistryAccess;
import org.eclipse.passage.loc.internal.edit.ui.i18n.EditUiMessages;
import org.eclipse.passage.loc.internal.workbench.LocDomainRegistryAccess;
import org.eclipse.swt.widgets.Shell;

public class DomainRegistryRemoveHandler {
    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") @Optional Resource resource) {
        return resource != null;
    }

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") Resource resource, IEclipseContext context) {
        URI uri = resource.getURI();
        if (uri != null) {
            LocDomainRegistryAccess access = (LocDomainRegistryAccess)context.get(EditingDomainRegistryAccess.class);
            access.domainRegistryForExtension(uri.fileExtension()).filter(BaseDomainRegistry.class::isInstance).map(BaseDomainRegistry.class::cast).ifPresent(r -> this.unregister((BaseDomainRegistry<?>)r, uri, (Shell)context.get(Shell.class)));
        }
    }

    private void unregister(BaseDomainRegistry<?> registry, URI uri, Shell shell) {
        String title = EditUiMessages.DomainRegistryRemoveHandler_title;
        String message = String.format(EditUiMessages.DomainRegistryRemoveHandler_mesage, uri.toFileString());
        if (MessageDialog.openConfirm((Shell)shell, (String)title, (String)message)) {
            registry.unregisterSource(uri.toFileString());
        }
    }
}

