/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.report.internal.ui.jface;

import java.nio.file.Path;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.passage.lic.products.registry.ProductRegistry;
import org.eclipse.passage.loc.report.internal.core.CustomerStorage;
import org.eclipse.passage.loc.report.internal.core.ExportService;
import org.eclipse.passage.loc.report.internal.ui.i18n.ExportCustomersWizardMessages;
import org.eclipse.passage.loc.report.internal.ui.jface.DataForExport;
import org.eclipse.passage.loc.report.internal.ui.jface.FileForExport;
import org.eclipse.passage.loc.report.internal.ui.jface.MonitoredExportOperation;
import org.eclipse.passage.loc.report.internal.ui.jface.PreviewPage;
import org.eclipse.passage.loc.report.internal.ui.jface.Products;
import org.eclipse.passage.loc.report.internal.ui.jface.ScopePage;
import org.eclipse.passage.loc.report.internal.ui.jface.TargetPage;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

final class ExportCustomersWizard
extends Wizard {
    private final ExportService export;
    private final DataForExport data;
    private final PreviewPage preview;
    private final ScopePage scope;
    private final TargetPage target;

    public ExportCustomersWizard(ProductRegistry products, CustomerStorage customers, ExportService export) {
        this.export = export;
        this.data = new DataForExport(this::identifiers, this::path, this::open);
        this.preview = new PreviewPage(customers, this.data);
        this.scope = new ScopePage(new Products(products, customers), this.preview);
        this.target = new TargetPage(this.preview);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.scope);
        this.addPage((IWizardPage)this.target);
        this.addPage((IWizardPage)this.preview);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.scope.installInitial();
        this.target.installInitial();
    }

    private Set<String> identifiers() {
        return this.scope.identifiers();
    }

    private Path path() {
        return this.target.path();
    }

    private boolean open() {
        return this.target.open();
    }

    public boolean performFinish() {
        Path file = new FileForExport(this.data.target()).get();
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)new MonitoredExportOperation(this.export, this.data.products(), file));
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)ExportCustomersWizardMessages.ExportCustomersWizard_errorTitle, (String)e.getLocalizedMessage());
            return false;
        }
        if (this.data.open()) {
            Program.launch((String)file.toAbsolutePath().toString());
        }
        return true;
    }

    public boolean canFinish() {
        return this.data.complete();
    }
}

