/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.net;

import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.base.StringNamedData;
import org.eclipse.passage.lic.internal.base.io.Settings;
import org.eclipse.passage.lic.internal.net.LicensingServerHost;
import org.eclipse.passage.lic.internal.net.LicensingServerPort;
import org.eclipse.passage.lic.internal.net.i18n.NetMessages;

public final class LicensingServerCoordinates {
    private final Supplier<Path> settings;

    public LicensingServerCoordinates(Supplier<Path> residence) {
        this.settings = residence;
    }

    public HostPort get() throws LicensingException {
        Map properties = new Settings(this.settings, this::necessaryPropertiesExist).get();
        return new HostPort(this.value(new LicensingServerHost(properties)), this.value(new LicensingServerPort(properties)));
    }

    private String value(StringNamedData data) throws LicensingException {
        Optional value = data.get();
        if (!value.isPresent()) {
            throw new LicensingException(String.format(NetMessages.LicensingServerCoordinates_settings_not_found, data.key()));
        }
        if (((String)value.get()).trim().isEmpty()) {
            throw new LicensingException(String.format(NetMessages.LicensingServerCoordinates_settings_are_blank, data.key()));
        }
        return (String)value.get();
    }

    private boolean necessaryPropertiesExist(Map<String, Object> properties) {
        return new LicensingServerHost(properties).get().isPresent() && new LicensingServerPort(properties).get().isPresent();
    }

    public static final class HostPort {
        private final String host;
        private final String port;

        public HostPort(String host, String port) {
            this.host = host;
            this.port = port;
        }

        public String host() {
            return this.host;
        }

        public String port() {
            return this.port;
        }
    }
}

