/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.wizards.floating;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.licenses.model.api.EvaluationInstructions;
import org.eclipse.passage.lic.licenses.model.api.FloatingLicenseAccess;
import org.eclipse.passage.lic.licenses.model.api.FloatingLicensePack;
import org.eclipse.passage.lic.licenses.model.api.FloatingServerConnection;
import org.eclipse.passage.lic.licenses.model.api.UserGrant;
import org.eclipse.passage.lic.licenses.model.meta.LicensesFactory;
import org.eclipse.passage.loc.dashboard.ui.wizards.floating.ServerConfigsRequest;
import org.eclipse.passage.loc.internal.api.IssuedFloatingLicense;
import org.eclipse.passage.loc.internal.api.OperatorLicenseService;

final class IssueCommand {
    private final IEclipseContext context;
    private final FloatingLicensePack pack;
    private final ServerConfigsRequest config;

    IssueCommand(IEclipseContext context, FloatingLicensePack pack, ServerConfigsRequest config) {
        this.context = context;
        this.pack = pack;
        this.config = config;
    }

    ServiceInvocationResult<IssuedFloatingLicense> issue() {
        List<FloatingLicenseAccess> personals = this.personalAccessConfigs();
        return ((OperatorLicenseService)this.context.get(OperatorLicenseService.class)).issueFloatingLicensePack(this.pack, personals);
    }

    private List<FloatingLicenseAccess> personalAccessConfigs() {
        if (!this.config.generate()) {
            return Collections.emptyList();
        }
        return this.pack.getUsers().stream().map(UserGrant::getUser).map(this::personalAccess).collect(Collectors.toList());
    }

    private FloatingLicenseAccess personalAccess(String user) {
        FloatingLicenseAccess access = LicensesFactory.eINSTANCE.createFloatingLicenseAccess();
        access.setUser(user);
        access.setOriginLicensePack(this.pack.getLicense().getIdentifier());
        access.setServer(this.server());
        return access;
    }

    private FloatingServerConnection server() {
        FloatingServerConnection connection = LicensesFactory.eINSTANCE.createFloatingServerConnection();
        connection.setIp(this.config.ip());
        connection.setPort(this.config.port());
        connection.setAuthentication((EvaluationInstructions)EcoreUtil.copy((EObject)this.pack.getHost().getAuthentication()));
        return connection;
    }
}

