/*******************************************************************************
 * Copyright (c) 2006, 2016 Soyatec (http://www.soyatec.com) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Soyatec - initial API and implementation
 *******************************************************************************/
package org.eclipse.pmf.pim.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.pmf.pim.util.PMFAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc --> <!--
 * end-user-doc -->
 * @generated
 */
public class PMFItemProviderAdapterFactory extends PMFAdapterFactory implements
		ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement
	 * {@link org.eclipse.emf.edit.provider.IChangeNotifier}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @generated
	 */
	public PMFItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ElementalDataForm} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ElementalDataFormItemProvider elementalDataFormItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ElementalDataForm}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createElementalDataFormAdapter() {
		if (elementalDataFormItemProvider == null) {
			elementalDataFormItemProvider = new ElementalDataFormItemProvider(
					this);
		}

		return elementalDataFormItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.DataFormSelector} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataFormSelectorItemProvider dataFormSelectorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.DataFormSelector}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataFormSelectorAdapter() {
		if (dataFormSelectorItemProvider == null) {
			dataFormSelectorItemProvider = new DataFormSelectorItemProvider(
					this);
		}

		return dataFormSelectorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.DataField} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataFieldItemProvider dataFieldItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.DataField}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createDataFieldAdapter() {
		if (dataFieldItemProvider == null) {
			dataFieldItemProvider = new DataFieldItemProvider(this);
		}

		return dataFieldItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.DataCollection} instances.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	protected DataCollectionItemProvider dataCollectionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.DataCollection}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataCollectionAdapter() {
		if (dataCollectionItemProvider == null) {
			dataCollectionItemProvider = new DataCollectionItemProvider(this);
		}

		return dataCollectionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.Application} instances.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ApplicationItemProvider applicationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.Application}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createApplicationAdapter() {
		if (applicationItemProvider == null) {
			applicationItemProvider = new ApplicationItemProvider(this);
		}

		return applicationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.DataGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataGroupItemProvider dataGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.DataGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataGroupAdapter() {
		if (dataGroupItemProvider == null) {
			dataGroupItemProvider = new DataGroupItemProvider(this);
		}

		return dataGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.Command} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CommandItemProvider commandItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.Command}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createCommandAdapter() {
		if (commandItemProvider == null) {
			commandItemProvider = new CommandItemProvider(this);
		}

		return commandItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.Action} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ActionItemProvider actionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.Action}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createActionAdapter() {
		if (actionItemProvider == null) {
			actionItemProvider = new ActionItemProvider(this);
		}

		return actionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.SystemAction} instances.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	protected SystemActionItemProvider systemActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.SystemAction}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSystemActionAdapter() {
		if (systemActionItemProvider == null) {
			systemActionItemProvider = new SystemActionItemProvider(this);
		}

		return systemActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.pmf.pim.ApplicationAction} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ApplicationActionItemProvider applicationActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ApplicationAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createApplicationActionAdapter() {
		if (applicationActionItemProvider == null) {
			applicationActionItemProvider = new ApplicationActionItemProvider(
					this);
		}

		return applicationActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.DataFormFolder} instances.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	protected DataFormFolderItemProvider dataFormFolderItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.DataFormFolder}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataFormFolderAdapter() {
		if (dataFormFolderItemProvider == null) {
			dataFormFolderItemProvider = new DataFormFolderItemProvider(this);
		}

		return dataFormFolderItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link java.util.Map.Entry} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected TypeToDataFormFolderEntryMapItemProvider typeToDataFormFolderEntryMapItemProvider;

	/**
	 * This creates an adapter for a {@link java.util.Map.Entry}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createTypeToDataFormFolderEntryMapAdapter() {
		if (typeToDataFormFolderEntryMapItemProvider == null) {
			typeToDataFormFolderEntryMapItemProvider = new TypeToDataFormFolderEntryMapItemProvider(
					this);
		}

		return typeToDataFormFolderEntryMapItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.PMF} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected PMFItemProvider pmfItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.PMF}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createPMFAdapter() {
		if (pmfItemProvider == null) {
			pmfItemProvider = new PMFItemProvider(this);
		}

		return pmfItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.DataConverter} instances.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	protected DataConverterItemProvider dataConverterItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.DataConverter}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataConverterAdapter() {
		if (dataConverterItemProvider == null) {
			dataConverterItemProvider = new DataConverterItemProvider(this);
		}

		return dataConverterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.Validator} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ValidatorItemProvider validatorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.Validator}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createValidatorAdapter() {
		if (validatorItemProvider == null) {
			validatorItemProvider = new ValidatorItemProvider(this);
		}

		return validatorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.ViewProfile} instances.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ViewProfileItemProvider viewProfileItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.ViewProfile}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createViewProfileAdapter() {
		if (viewProfileItemProvider == null) {
			viewProfileItemProvider = new ViewProfileItemProvider(this);
		}

		return viewProfileItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.PMFObject} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PMFObjectItemProvider pmfObjectItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.PMFObject}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createPMFObjectAdapter() {
		if (pmfObjectItemProvider == null) {
			pmfObjectItemProvider = new PMFObjectItemProvider(this);
		}

		return pmfObjectItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.Sorter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SorterItemProvider sorterItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.Sorter}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createSorterAdapter() {
		if (sorterItemProvider == null) {
			sorterItemProvider = new SorterItemProvider(this);
		}

		return sorterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.pmf.pim.DataInheritance} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected DataInheritanceItemProvider dataInheritanceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.DataInheritance}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataInheritanceAdapter() {
		if (dataInheritanceItemProvider == null) {
			dataInheritanceItemProvider = new DataInheritanceItemProvider(this);
		}

		return dataInheritanceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.pmf.pim.DataAssocication} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected DataAssocicationItemProvider dataAssocicationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.DataAssocication}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataAssocicationAdapter() {
		if (dataAssocicationItemProvider == null) {
			dataAssocicationItemProvider = new DataAssocicationItemProvider(
					this);
		}

		return dataAssocicationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.Library} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LibraryItemProvider libraryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.Library}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createLibraryAdapter() {
		if (libraryItemProvider == null) {
			libraryItemProvider = new LibraryItemProvider(this);
		}

		return libraryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.RegexValidator} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RegexValidatorItemProvider regexValidatorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.RegexValidator}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRegexValidatorAdapter() {
		if (regexValidatorItemProvider == null) {
			regexValidatorItemProvider = new RegexValidatorItemProvider(this);
		}

		return regexValidatorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link java.util.Map.Entry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClassToEventEntryMapItemProvider eClassToEventEntryMapItemProvider;

	/**
	 * This creates an adapter for a {@link java.util.Map.Entry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEClassToEventEntryMapAdapter() {
		if (eClassToEventEntryMapItemProvider == null) {
			eClassToEventEntryMapItemProvider = new EClassToEventEntryMapItemProvider(
					this);
		}

		return eClassToEventEntryMapItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.Authentication} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AuthenticationItemProvider authenticationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.Authentication}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAuthenticationAdapter() {
		if (authenticationItemProvider == null) {
			authenticationItemProvider = new AuthenticationItemProvider(this);
		}

		return authenticationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.Wizard} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected WizardItemProvider wizardItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.Wizard}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createWizardAdapter() {
		if (wizardItemProvider == null) {
			wizardItemProvider = new WizardItemProvider(this);
		}

		return wizardItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory
				.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setParentAdapterFactory(
			ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>)
					|| (((Class<?>) type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to
	 * {@link #parentAdapterFactory}. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void dispose() {
		if (elementalDataFormItemProvider != null)
			elementalDataFormItemProvider.dispose();
		if (dataFormSelectorItemProvider != null)
			dataFormSelectorItemProvider.dispose();
		if (dataFieldItemProvider != null)
			dataFieldItemProvider.dispose();
		if (dataCollectionItemProvider != null)
			dataCollectionItemProvider.dispose();
		if (applicationItemProvider != null)
			applicationItemProvider.dispose();
		if (dataGroupItemProvider != null)
			dataGroupItemProvider.dispose();
		if (commandItemProvider != null)
			commandItemProvider.dispose();
		if (actionItemProvider != null)
			actionItemProvider.dispose();
		if (systemActionItemProvider != null)
			systemActionItemProvider.dispose();
		if (applicationActionItemProvider != null)
			applicationActionItemProvider.dispose();
		if (dataFormFolderItemProvider != null)
			dataFormFolderItemProvider.dispose();
		if (typeToDataFormFolderEntryMapItemProvider != null)
			typeToDataFormFolderEntryMapItemProvider.dispose();
		if (pmfItemProvider != null)
			pmfItemProvider.dispose();
		if (dataConverterItemProvider != null)
			dataConverterItemProvider.dispose();
		if (validatorItemProvider != null)
			validatorItemProvider.dispose();
		if (viewProfileItemProvider != null)
			viewProfileItemProvider.dispose();
		if (pmfObjectItemProvider != null)
			pmfObjectItemProvider.dispose();
		if (sorterItemProvider != null)
			sorterItemProvider.dispose();
		if (dataInheritanceItemProvider != null)
			dataInheritanceItemProvider.dispose();
		if (dataAssocicationItemProvider != null)
			dataAssocicationItemProvider.dispose();
		if (libraryItemProvider != null)
			libraryItemProvider.dispose();
		if (regexValidatorItemProvider != null)
			regexValidatorItemProvider.dispose();
		if (eClassToEventEntryMapItemProvider != null)
			eClassToEventEntryMapItemProvider.dispose();
		if (authenticationItemProvider != null)
			authenticationItemProvider.dispose();
		if (wizardItemProvider != null)
			wizardItemProvider.dispose();
	}

}
