/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.compilation.utils.popup.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.pop.ssme.compilation.utils.jobs.CompilingMethods;
import org.eclipse.swt.SWT; 
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import org.eclipse.pop.ssme.polychrony.GraphValue;
import org.eclipse.pop.ssme.polychrony.PKOptionManager;
import org.eclipse.pop.ssme.polychrony.utils.PolychronyConsole;

/**
 * This class describes the general compilation feature
 */
public class BatchCompiling {
	 
	Shell shell;
	Text text;
	Button  compileButton, quitButton, SelectDirButton ;
	DirectoryDialog dirDialog;
 
	static String selectedDir=null;
	
	public BatchCompiling(final CompilingMethods compilingMethods, final long finalTree, final IFile sourceFile,
			final GraphValue graphValue, final CompilationUtils compilationUtils, final IPath fileDirectory ) 
	{
		final PKOptionManager optionManager = new PKOptionManager();
		 
		Display display = Display.getCurrent();
	    shell = new Shell(display);
		shell.setLayout(new GridLayout(2, false));		
		shell.setSize(2000, 3000);
		
		shell.setText("Enter or modify the compiling options");
		Composite compositeButtons = new Composite(shell, SWT.BORDER);
		compositeButtons.setLayout(new GridLayout());

		text = new Text(shell, SWT.MULTI | SWT.LEFT | SWT.H_SCROLL);
		text.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true)) ;
		text.append("                                                                   \n");
		text.append("-tra -poly \n");
		if (selectedDir != null) text.append(selectedDir + "\n");
		// Buttons: Compile, Quit, Selecting a directory.
		compileButton = new Button(compositeButtons, SWT.PUSH);
		compileButton.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		compileButton.setText("Compile");
		compileButton.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				if (e.type == SWT.Selection) {			 
					PolychronyConsole.clear();
					optionManager.compile(finalTree, graphValue.getGraph(), getBatchCompilerOptions(), fileDirectory.removeLastSegments(1).toString());
					shell.dispose();
					}
					compilationUtils.refreshContent();
				}
		});
		
		quitButton = new Button(compositeButtons, SWT.PUSH);
		quitButton.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		quitButton.setText("Quit");
		quitButton.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				if (e.type == SWT.Selection) dispose();				 
			}
		});	
		
		SelectDirButton = new Button(compositeButtons, SWT.PUSH);
		SelectDirButton.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		SelectDirButton.setText("Select output directory");
		SelectDirButton.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				if (e.type == SWT.Selection) {
					selectedDir = dirDialog.open();
					if (selectedDir != null){	
						selectedDir = "-D= " + selectedDir;
						text.append(selectedDir + "\n");
					}
				}
			}
		});	
		
	    dirDialog = new DirectoryDialog(shell, SWT.NONE);
		
		shell.pack();
		shell.open();		
		
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) display.sleep();
			 
		}
		dispose(); 
	}
	 private void dispose()
	 {
		 shell.dispose();
	 }

	/**
    @return the options as a string (one line) and "signal" as first element (batch compiler command analysis).
	 */
	public String getBatchCompilerOptions() 
	{
		String vstr;
		vstr = text.getText();
		vstr= vstr.replaceAll("\n", " ");
		vstr= vstr.replaceAll("\t", " ");
		vstr= vstr.replaceAll("\f", " ");
		vstr= vstr.replaceAll("\r", " ");
		vstr= vstr.replaceAll("  ", " ");
		vstr= "signal " + vstr;
		return vstr;
	}
	
}
