/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.compilation.utils.popup.actions; 
 
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;

import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.PKOptionManager;
/**
 * This class describes the general compilation feature
 */
public class miscOptions implements IObjectActionDelegate {
	public miscOptions() {
		super();
	}
	
	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {}
	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		
	}
	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		final PKOptionManager optionManager = new PKOptionManager();
		PkPlugin.getServices();  // Don't remove this line, it loads the (lib)SignalJavaC_API(.so) library.

		Display display = Display.getCurrent();
		final Shell shell = new Shell(display);
		shell.setLayout(new GridLayout(2, false));
	  //shell.setText("Miscellaneous options");
		
		// Tabs Definitions
		TabFolder tabfolder = new TabFolder(shell, SWT.BORDER);
		
		TabItem tabMisc = new TabItem(tabfolder, SWT.BORDER);
		tabMisc.setText("Miscellaneous options");
		Composite pageMisc = new Composite(tabfolder, SWT.BORDER);
		tabMisc.setControl(pageMisc);
		
		// Other Options
		final Button traceabilityButton = new Button(pageMisc, SWT.CHECK);
		traceabilityButton.setBounds(10, 10, 200, 25);
		traceabilityButton.setText("Traceability Mode");
		traceabilityButton.setSelection (optionManager.getOptTraceabilityMode());
		traceabilityButton.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
			 if (e.type == SWT.Selection) optionManager.setOptTraceabilityMode(traceabilityButton.getSelection());
			}
		});
		
		final Button verboseButton = new Button(pageMisc, SWT.CHECK);
		verboseButton.setBounds(10, 40, 200, 25);
		verboseButton.setText("Verbose");
		verboseButton.setSelection(optionManager.getOptVerbose());
		verboseButton.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
			 if (e.type == SWT.Selection) optionManager.setOptVerbose(verboseButton.getSelection());
			}
		});
		
		final Button statButton = new Button(pageMisc, SWT.CHECK);
		statButton.setBounds(10, 70, 200, 25);
		statButton.setText("Statistics");
		statButton.setSelection(optionManager.getOptStat());
		statButton.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
			 if (e.type == SWT.Selection)	optionManager.setOptStat( statButton.getSelection());
			}
		});
		
		final Button warnButton = new Button(pageMisc, SWT.CHECK);
		warnButton.setBounds(220, 10, 200, 25);
		warnButton.setText("Warnings");
		warnButton.setSelection(optionManager.getOptWarn());
		warnButton.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
			if (e.type == SWT.Selection) optionManager.setOptWarn(warnButton.getSelection());
			}
		});
		
		final Button debugButton = new Button(pageMisc, SWT.CHECK);
		debugButton.setBounds(220, 40, 200, 25);
		debugButton.setText("Debug");
		debugButton.setSelection(optionManager.getOptDebug());
		debugButton.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
			  if (e.type == SWT.Selection) optionManager.setOptDebug(debugButton.getSelection());
			}
		});
		
		final Button headerButton = new Button(pageMisc, SWT.CHECK);
		headerButton.setBounds(220, 70, 200, 25);
		headerButton.setText("Header");
		debugButton.setSelection(optionManager.getOptHeader());
		headerButton.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				if (e.type == SWT.Selection) optionManager.setOptHeader(headerButton.getSelection());
			}
		});
		
		final Button quitButton = new Button(shell, SWT.PUSH);
		quitButton.setBounds(220, 70, 200, 25);
		quitButton.setText("Quit");
		quitButton.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				if (e.type == SWT.Selection) shell.dispose();				 
			}
		});
		
		shell.pack();
		shell.open();
		
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) display.sleep();
			 
		}
	}
}
