/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.compilation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Generator Kind</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.pop.ssme.compilation.SsmeCompPackage#getGeneratorKind()
 * @model annotation="http://www.topcased.org/uuid uuid='_fu9rGMM-EduFJvhn52JvCw'"
 * @generated
 */
public enum GeneratorKind implements Enumerator {
	/**
	 * The '<em><b>Signal</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SIGNAL
	 * @generated
	 * @ordered
	 */
	SIGNAL_LITERAL(0, "Signal", "Signal Textual (SIG)"),

	/**
	 * The '<em><b>Signal LIS</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SIGNAL_LIS
	 * @generated
	 * @ordered
	 */
	SIGNAL_LIS_LITERAL(1, "Signal_LIS", "Signal Textual (LIS)"),

	/**
	 * The '<em><b>Signal TRA</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SIGNAL_TRA
	 * @generated
	 * @ordered
	 */
	SIGNAL_TRA_LITERAL(2, "Signal_TRA", "Signal Textual (TRA)"),

	/**
	 * The '<em><b>Ssme</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SSME
	 * @generated
	 * @ordered
	 */
	SSME_LITERAL(3, "Ssme", "Signal Model (SSME)"),
	/**
	 * The '<em><b>Signal Abstraction</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SIGNAL_ABSTRACTION
	 * @generated
	 * @ordered
	 */
	SIGNAL_ABSTRACTION_LITERAL(4, "SignalAbstraction", "Signal Abstraction"),

	/**
	 * The '<em><b>Sigali</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SIGALI
	 * @generated
	 * @ordered
	 */
	SIGALI_LITERAL(5, "Sigali", "Sigali"),

	/**
	 * The '<em><b>CANSI</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CANSI
	 * @generated
	 * @ordered
	 */
	CANSI_LITERAL(6, "C_ANSI", "C ANSI"),

	/**
	 * The '<em><b>CPP</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CPP
	 * @generated
	 * @ordered
	 */
	CPP_LITERAL(7, "CPP", "C++"),

	/**
	 * The '<em><b>Java</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #JAVA
	 * @generated
	 * @ordered
	 */
	JAVA_LITERAL(8, "Java", "Java"),

	/**
	 * The '<em><b>Profiling</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROFILING
	 * @generated
	 * @ordered
	 */
	PROFILING_LITERAL(9, "Profiling", "Profiling"),

	/**
	 * The '<em><b>Lustre</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #LUSTRE
	 * @generated
	 * @ordered
	 */
	LUSTRE_LITERAL(10, "Lustre", "Lustre"),

	/**
	 * The '<em><b>Syndex</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SYNDEX
	 * @generated
	 * @ordered
	 */
	SYNDEX_LITERAL(11, "Syndex", "SynDEx");

	/**
	 * The '<em><b>Signal</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Signal Textual (Sig): it translates the internal representation of the specification into a
	 * textual Signal file (.sig file).
	 * <!-- end-model-doc -->
	 * @see #SIGNAL_LITERAL
	 * @model name="Signal" literal="Signal Textual (SIG)"
	 *        annotation="http://www.topcased.org/uuid uuid='_fu9rGcM-EduFJvhn52JvCw'"
	 * @generated
	 * @ordered
	 */
	public static final int SIGNAL = 0;

	/**
	 * The '<em><b>Signal LIS</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Signal LIS</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SIGNAL_LIS_LITERAL
	 * @model name="Signal_LIS" literal="Signal Textual (LIS)"
	 * @generated
	 * @ordered
	 */
	public static final int SIGNAL_LIS = 1;

	/**
	 * The '<em><b>Signal TRA</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Signal TRA</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SIGNAL_TRA_LITERAL
	 * @model name="Signal_TRA" literal="Signal Textual (TRA)"
	 * @generated
	 * @ordered
	 */
	public static final int SIGNAL_TRA = 2;

	/**
	 * The '<em><b>Ssme</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Signal Model (Sme): it translates the internal representation of the specification into a XMI
	 * Model Signal file (.sme file). This model file is conformed to the SME meta-model.
	 * <!-- end-model-doc -->
	 * @see #SSME_LITERAL
	 * @model name="Ssme" literal="Signal Model (SSME)"
	 *        annotation="http://www.topcased.org/uuid uuid='_C_xYohj6Edyp0-eFBeYalQ'"
	 * @generated
	 * @ordered
	 */
	public static final int SSME = 3;

	/**
	 * The '<em><b>Signal Abstraction</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Signal Abstraction: it translates the abstraction of the internal representation into a textual
	 * Signal file (.sig file).
	 * <!-- end-model-doc -->
	 * @see #SIGNAL_ABSTRACTION_LITERAL
	 * @model name="SignalAbstraction" literal="Signal Abstraction"
	 *        annotation="http://www.topcased.org/uuid uuid='_2xo8isM-EduFJvhn52JvCw'"
	 * @generated
	 * @ordered
	 */
	public static final int SIGNAL_ABSTRACTION = 4;

	/**
	 * The '<em><b>Sigali</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Sigali: it translates the internal representation of the specification into a textual Sigali file
	 * (.z3z file). This file is then used by Sigali to prove dynamical properties.
	 * <!-- end-model-doc -->
	 * @see #SIGALI_LITERAL
	 * @model name="Sigali"
	 *        annotation="http://www.topcased.org/uuid uuid='_2xo8jMM-EduFJvhn52JvCw'"
	 * @generated
	 * @ordered
	 */
	public static final int SIGALI = 5;

	/**
	 * The '<em><b>CANSI</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * C ANSI: it translates the internal representation of the specification into a textual C ANSI
	 * files (.c and .h files). These files are used to simulate the Signal specification. It is applied to
	 * a graph which must be a sbDC+ one. The graph is with or without clusters.
	 * <!-- end-model-doc -->
	 * @see #CANSI_LITERAL
	 * @model name="C_ANSI" literal="C ANSI"
	 *        annotation="http://www.topcased.org/uuid uuid='_2xytgMM-EduFJvhn52JvCw'"
	 * @generated
	 * @ordered
	 */
	public static final int CANSI = 6;

	/**
	 * The '<em><b>CPP</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * C++: it translates the internal representation of the specification into a textual C++ files
	 * (.cpp and .h files). These files are used to simulate the Signal specification. It is applied to a
	 * graph which must be a sbDC+ one. The graph is with or without clusters.
	 * <!-- end-model-doc -->
	 * @see #CPP_LITERAL
	 * @model literal="C++"
	 *        annotation="http://www.topcased.org/uuid uuid='_2x8egMM-EduFJvhn52JvCw'"
	 * @generated
	 * @ordered
	 */
	public static final int CPP = 7;

	/**
	 * The '<em><b>Java</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Java: it translates the internal representation of the specification into a textual Java files
	 * (.java files). These files are used to simulate the Signal specification. It is applied to a graph
	 * which must be a sbDC+ one. The graph is with or without clusters.
	 * <!-- end-model-doc -->
	 * @see #JAVA_LITERAL
	 * @model name="Java"
	 *        annotation="http://www.topcased.org/uuid uuid='_2x8egcM-EduFJvhn52JvCw'"
	 * @generated
	 * @ordered
	 */
	public static final int JAVA = 8;

	/**
	 * The '<em><b>Profiling</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Profiling: it produces the morphism of the internal representation according to the
	 * definitions assigned of the Signal operators given in the "ht" table into a textual Signal file
	 * (.sig file).
	 * <!-- end-model-doc -->
	 * @see #PROFILING_LITERAL
	 * @model name="Profiling"
	 *        annotation="http://www.topcased.org/uuid uuid='_2yFocMM-EduFJvhn52JvCw'"
	 * @generated
	 * @ordered
	 */
	public static final int PROFILING = 9;

	/**
	 * The '<em><b>Lustre</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Lustre: it translates the internal representation of the specification into a textual Lustre file
	 * (.lus file).
	 * <!-- end-model-doc -->
	 * @see #LUSTRE_LITERAL
	 * @model name="Lustre"
	 *        annotation="http://www.topcased.org/uuid uuid='_QecFcRgDEdyHFcLr3WKLWw'"
	 * @generated
	 * @ordered
	 */
	public static final int LUSTRE = 10;

	/**
	 * The '<em><b>Syndex</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Syndex: it translates the internal representation of the specification into a textual SynDEx
	 * file (.sdx file) for code distribution.
	 * <!-- end-model-doc -->
	 * @see #SYNDEX_LITERAL
	 * @model name="Syndex" literal="SynDEx"
	 *        annotation="http://www.topcased.org/uuid uuid='_fBdaNHC8Edy8o4swpAVO6g'"
	 * @generated
	 * @ordered
	 */
	public static final int SYNDEX = 11;
	public static final int SME = 12;
	/**
	 * An array of all the '<em><b>Generator Kind</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final GeneratorKind[] VALUES_ARRAY =
		new GeneratorKind[] {
			SIGNAL_LITERAL,
			SIGNAL_LIS_LITERAL,
			SIGNAL_TRA_LITERAL,
			SSME_LITERAL,
			SIGNAL_ABSTRACTION_LITERAL,
			SIGALI_LITERAL,
			CANSI_LITERAL,
			CPP_LITERAL,
			JAVA_LITERAL,
			PROFILING_LITERAL,
			LUSTRE_LITERAL,
			SYNDEX_LITERAL,
		};

	/**
	 * A public read-only list of all the '<em><b>Generator Kind</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<GeneratorKind> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Generator Kind</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static GeneratorKind get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			GeneratorKind result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Generator Kind</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static GeneratorKind getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			GeneratorKind result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Generator Kind</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static GeneratorKind get(int value) {
		switch (value) {
			case SIGNAL: return SIGNAL_LITERAL;
			case SIGNAL_LIS: return SIGNAL_LIS_LITERAL;
			case SIGNAL_TRA: return SIGNAL_TRA_LITERAL;
			case SSME: return SSME_LITERAL;
			case SIGNAL_ABSTRACTION: return SIGNAL_ABSTRACTION_LITERAL;
			case SIGALI: return SIGALI_LITERAL;
			case CANSI: return CANSI_LITERAL;
			case CPP: return CPP_LITERAL;
			case JAVA: return JAVA_LITERAL;
			case PROFILING: return PROFILING_LITERAL;
			case LUSTRE: return LUSTRE_LITERAL;
			case SYNDEX: return SYNDEX_LITERAL;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private GeneratorKind(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //GeneratorKind
