/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.compilation;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Scenario</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.compilation.Scenario#getElements <em>Elements</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.compilation.Scenario#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.compilation.Scenario#isDisplayWarnings <em>Display Warnings</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.pop.ssme.compilation.SsmeCompPackage#getScenario()
 * @model annotation="http://www.topcased.org/uuid uuid='_26vDkcM9EduFJvhn52JvCw'"
 * @generated
 */
public interface Scenario extends EObject {
	
	/**
	 * Returns the value of the '<em><b>Elements</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.pop.ssme.compilation.ScenarioItem}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Elements</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Elements</em>' containment reference list.
	 * @see org.eclipse.pop.ssme.compilation.SsmeCompPackage#getScenario_Elements()
	 * @model containment="true" required="true"
	 *        annotation="http://www.topcased.org/uuid uuid='_Ao3VwsM-EduFJvhn52JvCw'"
	 * @generated
	 */
	EList<ScenarioItem> getElements();

	/**
	 * Returns the value of the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Description</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Description</em>' attribute.
	 * @see #setDescription(String)
	 * @see org.eclipse.pop.ssme.compilation.SsmeCompPackage#getScenario_Description()
	 * @model required="true"
	 *        annotation="http://www.topcased.org/uuid uuid='_IvY0gxj_Edy0-YMMPKJZWQ'"
	 * @generated
	 */
	String getDescription();

	/**
	 * Sets the value of the '{@link org.eclipse.pop.ssme.compilation.Scenario#getDescription <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Description</em>' attribute.
	 * @see #getDescription()
	 * @generated
	 */
	void setDescription(String value);

	/**
	 * Returns the value of the '<em><b>Display Warnings</b></em>' attribute.
	 * The default value is <code>"false"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This attribute will be true if we want to display all warning during compilation phase.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Display Warnings</em>' attribute.
	 * @see #setDisplayWarnings(boolean)
	 * @see org.eclipse.pop.ssme.compilation.SsmeCompPackage#getScenario_DisplayWarnings()
	 * @model default="false"
	 * @generated
	 */
	boolean isDisplayWarnings();

	/**
	 * Sets the value of the '{@link org.eclipse.pop.ssme.compilation.Scenario#isDisplayWarnings <em>Display Warnings</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Display Warnings</em>' attribute.
	 * @see #isDisplayWarnings()
	 * @generated
	 */
	void setDisplayWarnings(boolean value);

} // Scenario
