/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.pop.ssme.AssertSignal;
import org.eclipse.pop.ssme.SsmeFactory;
import org.eclipse.pop.ssme.SsmePackage;

/**
 * This is the item provider adapter for a {@link org.eclipse.pop.ssme.AssertSignal} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class AssertSignalItemProvider
	extends SignalElementItemProvider {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AssertSignalItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addExprSignalPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Expr Signal feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addExprSignalPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_AssertSignal_exprSignal_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_AssertSignal_exprSignal_feature", "_UI_AssertSignal_type"),
				 SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures.add(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal());
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

	/**
	 * This returns AssertSignal.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object getImage(Object object) {
		return overlayImage(object, getResourceLocator().getImage("full/obj16/AssertSignal"));
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getText(Object object) {
		return getString("_UI_AssertSignal_type");
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(AssertSignal.class)) {
			case SsmePackage.ASSERT_SIGNAL__EXPR_SIGNAL:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
				return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s describing the children
	 * that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createAfter()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createAnd()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createArrayElem()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createArrayElementsEnumeration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createArrayProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createArrayRestructuration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createAssertSignal()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createCartesianProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createCell()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createClock()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createClockDifference()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createClockProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createClockUnion()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createComplexConstructor()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createConcatenation()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createConstantCharacter()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createConstantDoubleReal()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createConstantEnum()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createConstantInteger()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createConstantLogical()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createConstantReal()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createConversion()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createCount()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createDefault()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createDelay()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createDiv()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createElemDefinitionEnumeration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createEqualEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createFieldAccess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createFrom()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createGreater()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createGreaterOrEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createIdentifier()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createIfThenElse()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createIndex()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createLess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createLessLessEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createLessOrEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createListFlows()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createMinus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createModulo()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createNot()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createNotEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createNullClock()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createOr()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createPlus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createPower()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createPreviousIterationRef()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createProcessCall()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createProcessExpansion()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createRecover()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createRepetition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createSequentialDefinition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createStateVariableValue()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createStringValue()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createTransposition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createUnaryMinus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createUnaryPlus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createUnaryWhen()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createVar()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createWhen()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createWindow()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getAssertSignal_ExprSignal(),
				 SsmeFactory.eINSTANCE.createXor()));
	}

	/**
	 * This returns the label text for {@link org.eclipse.emf.edit.command.CreateChildCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getCreateChildText(Object owner, Object feature, Object child, Collection<?> selection) {
		Object childFeature = feature;
		Object childObject = child;

		boolean qualify =
			childFeature == SsmePackage.eINSTANCE.getSignalElement_CommentPre() ||
			childFeature == SsmePackage.eINSTANCE.getSignalElement_CommentPost();

		if (qualify) {
			return getString
				("_UI_CreateChild_text2",
				 new Object[] { getTypeText(childObject), getFeatureText(childFeature), getTypeText(owner) });
		}
		return super.getCreateChildText(owner, feature, child, selection);
	}

}
