/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.pop.ssme.CaseProcess;
import org.eclipse.pop.ssme.SsmeFactory;
import org.eclipse.pop.ssme.SsmePackage;

/**
 * This is the item provider adapter for a {@link org.eclipse.pop.ssme.CaseProcess} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class CaseProcessItemProvider
	extends SignalElementItemProvider {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CaseProcessItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addIdentifierPropertyDescriptor(object);
			addListCaseBranchPropertyDescriptor(object);
			addElseCasePropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Identifier feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addIdentifierPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_CaseProcess_identifier_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_CaseProcess_identifier_feature", "_UI_CaseProcess_type"),
				 SsmePackage.eINSTANCE.getCaseProcess_Identifier(),
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the List Case Branch feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addListCaseBranchPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_CaseProcess_listCaseBranch_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_CaseProcess_listCaseBranch_feature", "_UI_CaseProcess_type"),
				 SsmePackage.eINSTANCE.getCaseProcess_ListCaseBranch(),
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Else Case feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addElseCasePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_CaseProcess_elseCase_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_CaseProcess_elseCase_feature", "_UI_CaseProcess_type"),
				 SsmePackage.eINSTANCE.getCaseProcess_ElseCase(),
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures.add(SsmePackage.eINSTANCE.getCaseProcess_Identifier());
			childrenFeatures.add(SsmePackage.eINSTANCE.getCaseProcess_ListCaseBranch());
			childrenFeatures.add(SsmePackage.eINSTANCE.getCaseProcess_ElseCase());
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

	/**
	 * This returns CaseProcess.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object getImage(Object object) {
		return overlayImage(object, getResourceLocator().getImage("full/obj16/CaseProcess"));
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getText(Object object) {
		return getString("_UI_CaseProcess_type");
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(CaseProcess.class)) {
			case SsmePackage.CASE_PROCESS__IDENTIFIER:
			case SsmePackage.CASE_PROCESS__LIST_CASE_BRANCH:
			case SsmePackage.CASE_PROCESS__ELSE_CASE:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
				return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s describing the children
	 * that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getCaseProcess_Identifier(),
				 SsmeFactory.eINSTANCE.createIdentifier()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getCaseProcess_ListCaseBranch(),
				 SsmeFactory.eINSTANCE.createCaseBranch()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getCaseProcess_ElseCase(),
				 SsmeFactory.eINSTANCE.createArrayProcess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getCaseProcess_ElseCase(),
				 SsmeFactory.eINSTANCE.createAssertProcess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getCaseProcess_ElseCase(),
				 SsmeFactory.eINSTANCE.createAssertSignal()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getCaseProcess_ElseCase(),
				 SsmeFactory.eINSTANCE.createCaseProcess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getCaseProcess_ElseCase(),
				 SsmeFactory.eINSTANCE.createClockEquality()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getCaseProcess_ElseCase(),
				 SsmeFactory.eINSTANCE.createClockExclusiveRelation()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getCaseProcess_ElseCase(),
				 SsmeFactory.eINSTANCE.createClockInfRelation()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getCaseProcess_ElseCase(),
				 SsmeFactory.eINSTANCE.createClockSupRelation()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getCaseProcess_ElseCase(),
				 SsmeFactory.eINSTANCE.createComposition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getCaseProcess_ElseCase(),
				 SsmeFactory.eINSTANCE.createConditionedDependence()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getCaseProcess_ElseCase(),
				 SsmeFactory.eINSTANCE.createIdentityEquation()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getCaseProcess_ElseCase(),
				 SsmeFactory.eINSTANCE.createIterationProcess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getCaseProcess_ElseCase(),
				 SsmeFactory.eINSTANCE.createLabelledProcess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getCaseProcess_ElseCase(),
				 SsmeFactory.eINSTANCE.createMasking()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getCaseProcess_ElseCase(),
				 SsmeFactory.eINSTANCE.createNullProc()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getCaseProcess_ElseCase(),
				 SsmeFactory.eINSTANCE.createProcessCall()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getCaseProcess_ElseCase(),
				 SsmeFactory.eINSTANCE.createProcessExpansion()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getCaseProcess_ElseCase(),
				 SsmeFactory.eINSTANCE.createRestrictionProcess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getCaseProcess_ElseCase(),
				 SsmeFactory.eINSTANCE.createSignalsDefinition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getCaseProcess_ElseCase(),
				 SsmeFactory.eINSTANCE.createSignalsPartialDefaultDefinition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getCaseProcess_ElseCase(),
				 SsmeFactory.eINSTANCE.createSignalsPartialDefinition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getCaseProcess_ElseCase(),
				 SsmeFactory.eINSTANCE.createUnconditionedDependences()));
	}

	/**
	 * This returns the label text for {@link org.eclipse.emf.edit.command.CreateChildCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getCreateChildText(Object owner, Object feature, Object child, Collection<?> selection) {
		Object childFeature = feature;
		Object childObject = child;

		boolean qualify =
			childFeature == SsmePackage.eINSTANCE.getSignalElement_CommentPre() ||
			childFeature == SsmePackage.eINSTANCE.getSignalElement_CommentPost();

		if (qualify) {
			return getString
				("_UI_CreateChild_text2",
				 new Object[] { getTypeText(childObject), getFeatureText(childFeature), getTypeText(owner) });
		}
		return super.getCreateChildText(owner, feature, child, selection);
	}

}
