/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.pop.ssme.Index;
import org.eclipse.pop.ssme.SsmeFactory;
import org.eclipse.pop.ssme.SsmePackage;

/**
 * This is the item provider adapter for a {@link org.eclipse.pop.ssme.Index} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class IndexItemProvider
	extends SignalElementItemProvider {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IndexItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addExprSignal1PropertyDescriptor(object);
			addExprSignal2PropertyDescriptor(object);
			addExprSignal3PropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Expr Signal1 feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addExprSignal1PropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_TernaryOperators_exprSignal1_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_TernaryOperators_exprSignal1_feature", "_UI_TernaryOperators_type"),
				 SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Expr Signal2 feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addExprSignal2PropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_TernaryOperators_exprSignal2_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_TernaryOperators_exprSignal2_feature", "_UI_TernaryOperators_type"),
				 SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Expr Signal3 feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addExprSignal3PropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_TernaryOperators_exprSignal3_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_TernaryOperators_exprSignal3_feature", "_UI_TernaryOperators_type"),
				 SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures.add(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1());
			childrenFeatures.add(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2());
			childrenFeatures.add(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3());
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

	/**
	 * This returns Index.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object getImage(Object object) {
		return overlayImage(object, getResourceLocator().getImage("full/obj16/Index"));
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getText(Object object) {
		return getString("_UI_Index_type");
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(Index.class)) {
			case SsmePackage.INDEX__EXPR_SIGNAL1:
			case SsmePackage.INDEX__EXPR_SIGNAL2:
			case SsmePackage.INDEX__EXPR_SIGNAL3:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
				return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s describing the children
	 * that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createAfter()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createAnd()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createArrayElem()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createArrayElementsEnumeration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createArrayProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createArrayRestructuration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createAssertSignal()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createCartesianProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createCell()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createClock()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createClockDifference()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createClockProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createClockUnion()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createComplexConstructor()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createConcatenation()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createConstantCharacter()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createConstantDoubleReal()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createConstantEnum()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createConstantInteger()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createConstantLogical()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createConstantReal()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createConversion()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createCount()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createDefault()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createDelay()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createDiv()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createElemDefinitionEnumeration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createEqualEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createFieldAccess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createFrom()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createGreater()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createGreaterOrEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createIdentifier()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createIfThenElse()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createIndex()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createLess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createLessLessEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createLessOrEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createListFlows()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createMinus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createModulo()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createNot()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createNotEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createNullClock()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createOr()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createPlus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createPower()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createPreviousIterationRef()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createProcessCall()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createProcessExpansion()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createRecover()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createRepetition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createSequentialDefinition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createStateVariableValue()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createStringValue()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createTransposition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createUnaryMinus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createUnaryPlus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createUnaryWhen()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createVar()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createWhen()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createWindow()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1(),
				 SsmeFactory.eINSTANCE.createXor()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createAfter()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createAnd()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createArrayElem()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createArrayElementsEnumeration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createArrayProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createArrayRestructuration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createAssertSignal()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createCartesianProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createCell()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createClock()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createClockDifference()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createClockProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createClockUnion()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createComplexConstructor()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createConcatenation()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createConstantCharacter()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createConstantDoubleReal()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createConstantEnum()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createConstantInteger()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createConstantLogical()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createConstantReal()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createConversion()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createCount()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createDefault()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createDelay()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createDiv()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createElemDefinitionEnumeration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createEqualEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createFieldAccess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createFrom()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createGreater()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createGreaterOrEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createIdentifier()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createIfThenElse()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createIndex()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createLess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createLessLessEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createLessOrEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createListFlows()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createMinus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createModulo()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createNot()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createNotEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createNullClock()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createOr()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createPlus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createPower()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createPreviousIterationRef()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createProcessCall()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createProcessExpansion()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createRecover()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createRepetition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createSequentialDefinition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createStateVariableValue()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createStringValue()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createTransposition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createUnaryMinus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createUnaryPlus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createUnaryWhen()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createVar()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createWhen()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createWindow()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2(),
				 SsmeFactory.eINSTANCE.createXor()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createAfter()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createAnd()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createArrayElem()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createArrayElementsEnumeration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createArrayProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createArrayRestructuration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createAssertSignal()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createCartesianProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createCell()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createClock()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createClockDifference()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createClockProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createClockUnion()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createComplexConstructor()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createConcatenation()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createConstantCharacter()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createConstantDoubleReal()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createConstantEnum()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createConstantInteger()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createConstantLogical()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createConstantReal()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createConversion()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createCount()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createDefault()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createDelay()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createDiv()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createElemDefinitionEnumeration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createEqualEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createFieldAccess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createFrom()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createGreater()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createGreaterOrEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createIdentifier()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createIfThenElse()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createIndex()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createLess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createLessLessEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createLessOrEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createListFlows()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createMinus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createModulo()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createNot()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createNotEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createNullClock()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createOr()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createPlus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createPower()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createPreviousIterationRef()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createProcessCall()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createProcessExpansion()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createRecover()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createRepetition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createSequentialDefinition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createStateVariableValue()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createStringValue()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createTransposition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createUnaryMinus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createUnaryPlus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createUnaryWhen()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createVar()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createWhen()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createWindow()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3(),
				 SsmeFactory.eINSTANCE.createXor()));
	}

	/**
	 * This returns the label text for {@link org.eclipse.emf.edit.command.CreateChildCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getCreateChildText(Object owner, Object feature, Object child, Collection<?> selection) {
		Object childFeature = feature;
		Object childObject = child;

		boolean qualify =
			childFeature == SsmePackage.eINSTANCE.getSignalElement_CommentPre() ||
			childFeature == SsmePackage.eINSTANCE.getSignalElement_CommentPost() ||
			childFeature == SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal1() ||
			childFeature == SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal2() ||
			childFeature == SsmePackage.eINSTANCE.getTernaryOperators_ExprSignal3();

		if (qualify) {
			return getString
				("_UI_CreateChild_text2",
				 new Object[] { getTypeText(childObject), getFeatureText(childFeature), getTypeText(owner) });
		}
		return super.getCreateChildText(owner, feature, child, selection);
	}

}
